/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.tls.AbstractTlsContext;
import org.spongycastle.crypto.tls.Certificate;
import org.spongycastle.crypto.tls.CertificateRequest;
import org.spongycastle.crypto.tls.CertificateStatus;
import org.spongycastle.crypto.tls.CipherSuite;
import org.spongycastle.crypto.tls.DigitallySigned;
import org.spongycastle.crypto.tls.NewSessionTicket;
import org.spongycastle.crypto.tls.ProtocolVersion;
import org.spongycastle.crypto.tls.SecurityParameters;
import org.spongycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.spongycastle.crypto.tls.TlsContext;
import org.spongycastle.crypto.tls.TlsCredentials;
import org.spongycastle.crypto.tls.TlsExtensionsUtils;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsHandshakeHash;
import org.spongycastle.crypto.tls.TlsKeyExchange;
import org.spongycastle.crypto.tls.TlsPeer;
import org.spongycastle.crypto.tls.TlsProtocol;
import org.spongycastle.crypto.tls.TlsServer;
import org.spongycastle.crypto.tls.TlsServerContextImpl;
import org.spongycastle.crypto.tls.TlsSigner;
import org.spongycastle.crypto.tls.TlsUtils;
import org.spongycastle.crypto.util.PublicKeyFactory;
import org.spongycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    TlsServerContextImpl tlsServerContext = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected short clientCertificateType = (short)-1;
    protected TlsHandshakeHash prepareFinishHash = null;

    public TlsServerProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        super(input, output, secureRandom);
    }

    public TlsServerProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("'accept' can only be called once");
        }
        this.tlsServer = tlsServer;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 0;
        this.tlsServerContext = new TlsServerContextImpl(this.secureRandom, this.securityParameters);
        this.securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(tlsServer.shouldUseGMTUnixTime(), this.tlsServerContext.getNonceRandomGenerator());
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        this.recordStream.setRestrictReadVersion(false);
        this.blockForHandshake();
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.serverCredentials = null;
        this.certificateRequest = null;
        this.prepareFinishHash = null;
    }

    protected TlsContext getContext() {
        return this.tlsServerContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsServerContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    /*
     * Unable to fully structure code
     */
    protected void handleHandshakeMessage(short type, byte[] data) throws IOException {
        buf = new ByteArrayInputStream(data);
        block0 : switch (type) {
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        this.receiveClientHelloMessage(buf);
                        this.connection_state = 1;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        serverSupplementalData = this.tlsServer.getServerSupplementalData();
                        if (serverSupplementalData != null) {
                            this.sendSupplementalDataMessage(serverSupplementalData);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = this.tlsServer.getKeyExchange();
                        this.keyExchange.init(this.getContext());
                        this.serverCredentials = this.tlsServer.getCredentials();
                        serverCertificate = null;
                        if (this.serverCredentials == null) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            serverCertificate = this.serverCredentials.getCertificate();
                            this.sendCertificateMessage(serverCertificate);
                        }
                        this.connection_state = (short)4;
                        if (serverCertificate == null || serverCertificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        if (this.allowCertificateStatus && (certificateStatus = this.tlsServer.getCertificateStatus()) != null) {
                            this.sendCertificateStatusMessage(certificateStatus);
                        }
                        this.connection_state = (short)5;
                        serverKeyExchange = this.keyExchange.generateServerKeyExchange();
                        if (serverKeyExchange != null) {
                            this.sendServerKeyExchangeMessage(serverKeyExchange);
                        }
                        this.connection_state = (short)6;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                if (TlsUtils.isTLSv12(this.getContext()) != (this.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                                    throw new TlsFatalAlert(80);
                                }
                                this.keyExchange.validateCertificateRequest(this.certificateRequest);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                                TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                            }
                        }
                        this.connection_state = (short)7;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)8;
                        this.recordStream.getHandshakeHash().sealHashAlgorithms();
                        break block0;
                    }
                    case 16: {
                        this.refuseRenegotiation();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(buf));
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 11: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest == null) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateMessage(buf);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 16: {
                switch (this.connection_state) {
                    case 8: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 9: {
                        if (this.certificateRequest != null) ** GOTO lbl78
                        this.keyExchange.skipClientCredentials();
                        ** GOTO lbl85
lbl78:
                        // 1 sources

                        if (TlsUtils.isTLSv12(this.getContext())) {
                            throw new TlsFatalAlert(10);
                        }
                        if (TlsUtils.isSSL(this.getContext())) {
                            if (this.peerCertificate == null) {
                                throw new TlsFatalAlert(10);
                            }
                        } else {
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
lbl85:
                    // 4 sources

                    case 10: {
                        this.receiveClientKeyExchangeMessage(buf);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 11: {
                        if (!this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.receiveCertificateVerifyMessage(buf);
                        this.connection_state = (short)12;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        if (this.expectCertificateVerifyMessage()) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 12: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                            this.sendChangeCipherSpecMessage();
                        }
                        this.connection_state = (short)14;
                        this.sendFinishedMessage();
                        this.connection_state = (short)15;
                        this.connection_state = (short)16;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleWarningMessage(short description) throws IOException {
        switch (description) {
            case 41: {
                if (!TlsUtils.isSSL(this.getContext()) || this.certificateRequest == null) break;
                this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                break;
            }
            default: {
                super.handleWarningMessage(description);
            }
        }
    }

    protected void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (this.peerCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        this.peerCertificate = clientCertificate;
        if (clientCertificate.isEmpty()) {
            this.keyExchange.skipClientCredentials();
        } else {
            this.clientCertificateType = TlsUtils.getClientCertificateType(clientCertificate, this.serverCredentials.getCertificate());
            this.keyExchange.processClientCertificate(clientCertificate);
        }
        this.tlsServer.notifyClientCertificate(clientCertificate);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream buf) throws IOException {
        Certificate clientCertificate = Certificate.parse(buf);
        TlsServerProtocol.assertEmpty(buf);
        this.notifyClientCertificate(clientCertificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream buf) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        DigitallySigned clientCertificateVerify = DigitallySigned.parse(this.getContext(), buf);
        TlsServerProtocol.assertEmpty(buf);
        try {
            byte[] hash;
            SignatureAndHashAlgorithm signatureAlgorithm = clientCertificateVerify.getAlgorithm();
            if (TlsUtils.isTLSv12(this.getContext())) {
                TlsUtils.verifySupportedSignatureAlgorithm(this.certificateRequest.getSupportedSignatureAlgorithms(), signatureAlgorithm);
                hash = this.prepareFinishHash.getFinalHash(signatureAlgorithm.getHash());
            } else {
                hash = this.securityParameters.getSessionHash();
            }
            org.spongycastle.asn1.x509.Certificate x509Cert = this.peerCertificate.getCertificateAt(0);
            SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(keyInfo);
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(this.clientCertificateType);
            tlsSigner.init(this.getContext());
            if (!tlsSigner.verifyRawSignature(signatureAlgorithm, clientCertificateVerify.getSignature(), publicKey, hash)) {
                throw new TlsFatalAlert(51);
            }
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream buf) throws IOException {
        byte[] renegExtData;
        ProtocolVersion client_version = TlsUtils.readVersion(buf);
        this.recordStream.setWriteVersion(client_version);
        if (client_version.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] client_random = TlsUtils.readFully(32, (InputStream)buf);
        byte[] sessionID = TlsUtils.readOpaque8(buf);
        if (sessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        int cipher_suites_length = TlsUtils.readUint16(buf);
        if (cipher_suites_length < 2 || (cipher_suites_length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(cipher_suites_length / 2, buf);
        short compression_methods_length = TlsUtils.readUint8(buf);
        if (compression_methods_length < 1) {
            throw new TlsFatalAlert(47);
        }
        this.offeredCompressionMethods = TlsUtils.readUint8Array(compression_methods_length, buf);
        this.clientExtensions = TlsServerProtocol.readExtensions(buf);
        this.securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions);
        this.getContextAdmin().setClientVersion(client_version);
        this.tlsServer.notifyClientVersion(client_version);
        this.tlsServer.notifyFallback(Arrays.contains(this.offeredCipherSuites, 22016));
        this.securityParameters.clientRandom = client_random;
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        this.tlsServer.notifyOfferedCompressionMethods(this.offeredCompressionMethods);
        if (Arrays.contains(this.offeredCipherSuites, 255)) {
            this.secure_renegotiation = true;
        }
        if ((renegExtData = TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(renegExtData, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsServer.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(this.clientExtensions);
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream buf) throws IOException {
        this.keyExchange.processClientKeyExchange(buf);
        TlsServerProtocol.assertEmpty(buf);
        this.prepareFinishHash = this.recordStream.prepareToFinish();
        this.securityParameters.sessionHash = TlsServerProtocol.getCurrentPRFHash(this.getContext(), this.prepareFinishHash, null);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.recordStream.setPendingConnectionState(this.getPeer().getCompression(), this.getPeer().getCipher());
        if (!this.expectSessionTicket) {
            this.sendChangeCipherSpecMessage();
        }
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(13);
        certificateRequest.encode(message);
        message.writeToRecordStream();
    }

    protected void sendCertificateStatusMessage(CertificateStatus certificateStatus) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(22);
        certificateStatus.encode(message);
        message.writeToRecordStream();
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(4);
        newSessionTicket.encode(message);
        message.writeToRecordStream();
    }

    protected void sendServerHelloMessage() throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(2);
        ProtocolVersion server_version = this.tlsServer.getServerVersion();
        if (!server_version.isEqualOrEarlierVersionOf(this.getContext().getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.recordStream.setReadVersion(server_version);
        this.recordStream.setWriteVersion(server_version);
        this.recordStream.setRestrictReadVersion(true);
        this.getContextAdmin().setServerVersion(server_version);
        TlsUtils.writeVersion(server_version, message);
        message.write(this.securityParameters.serverRandom);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, message);
        int selectedCipherSuite = this.tlsServer.getSelectedCipherSuite();
        if (!Arrays.contains(this.offeredCipherSuites, selectedCipherSuite) || selectedCipherSuite == 0 || CipherSuite.isSCSV(selectedCipherSuite) || !TlsUtils.isValidCipherSuiteForVersion(selectedCipherSuite, this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.cipherSuite = selectedCipherSuite;
        short selectedCompressionMethod = this.tlsServer.getSelectedCompressionMethod();
        if (!Arrays.contains(this.offeredCompressionMethods, selectedCompressionMethod)) {
            throw new TlsFatalAlert(80);
        }
        this.securityParameters.compressionAlgorithm = selectedCompressionMethod;
        TlsUtils.writeUint16(selectedCipherSuite, message);
        TlsUtils.writeUint8(selectedCompressionMethod, (OutputStream)message);
        this.serverExtensions = this.tlsServer.getServerExtensions();
        if (this.secure_renegotiation) {
            boolean noRenegExt;
            byte[] renegExtData = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
            boolean bl = noRenegExt = null == renegExtData;
            if (noRenegExt) {
                this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.securityParameters.extendedMasterSecret) {
            this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.serverExtensions);
        }
        if (this.serverExtensions != null) {
            this.securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(this.serverExtensions);
            this.securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(this.clientExtensions, this.serverExtensions, (short)80);
            this.securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(this.serverExtensions);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(this.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
            TlsServerProtocol.writeExtensions(message, this.serverExtensions);
        }
        this.securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.getContext(), this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
        this.applyMaxFragmentLengthExtension();
        message.writeToRecordStream();
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] message = new byte[4];
        TlsUtils.writeUint8((short)14, message, 0);
        TlsUtils.writeUint24(0, message, 1);
        this.writeHandshakeMessage(message, 0, message.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] serverKeyExchange) throws IOException {
        TlsProtocol.HandshakeMessage message = new TlsProtocol.HandshakeMessage(12, serverKeyExchange.length);
        message.write(serverKeyExchange);
        message.writeToRecordStream();
    }

    protected boolean expectCertificateVerifyMessage() {
        return this.clientCertificateType >= 0 && TlsUtils.hasSigningCapability(this.clientCertificateType);
    }
}

