/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.tests;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class XOMTestCase
extends TestCase {
    public XOMTestCase(String string) {
        super(string);
    }

    public static void assertEquals(Text text, Text text2) {
        XOMTestCase.assertEquals(null, text, text2);
    }

    public static void assertEquals(String string, Text text, Text text2) {
        if (text2 == text) {
            return;
        }
        XOMTestCase.nullCheck(string, text, text2);
        XOMTestCase.assertEquals(string, text.getValue(), text2.getValue());
    }

    private static void nullCheck(String string, Node node, Node node2) {
        if (node == null) {
            throw new ComparisonFailure(string, null, node2.toXML());
        }
        if (node2 == null) {
            throw new ComparisonFailure(string, node.toXML(), null);
        }
    }

    public static void assertEquals(Attribute attribute, Attribute attribute2) {
        XOMTestCase.assertEquals(null, attribute, attribute2);
    }

    public static void assertEquals(String string, Attribute attribute, Attribute attribute2) {
        if (attribute2 == attribute) {
            return;
        }
        XOMTestCase.nullCheck(string, attribute, attribute2);
        String string2 = attribute.getValue();
        String string3 = attribute2.getValue();
        if ("xml:base".equals(attribute.getQualifiedName())) {
            if (string2.equals(string3)) {
                return;
            }
            if (string2.startsWith("../")) {
                XOMTestCase.assertTrue(string, string3.endsWith(string2.substring(2)));
            } else {
                XOMTestCase.assertTrue(string, string2.endsWith('/' + string3) || string3.endsWith('/' + string2));
            }
        } else {
            XOMTestCase.assertEquals(string, string2, string3);
            XOMTestCase.assertEquals(string, attribute.getLocalName(), attribute2.getLocalName());
            XOMTestCase.assertEquals(string, attribute.getQualifiedName(), attribute2.getQualifiedName());
            XOMTestCase.assertEquals(string, attribute.getNamespaceURI(), attribute2.getNamespaceURI());
        }
    }

    public static void assertEquals(DocType docType, DocType docType2) {
        XOMTestCase.assertEquals(null, docType, docType2);
    }

    public static void assertEquals(String string, DocType docType, DocType docType2) {
        if (docType2 == docType) {
            return;
        }
        XOMTestCase.nullCheck(string, docType, docType2);
        XOMTestCase.assertEquals(string, docType.getPublicID(), docType2.getPublicID());
        XOMTestCase.assertEquals(string, docType.getSystemID(), docType2.getSystemID());
        XOMTestCase.assertEquals(string, docType.getRootElementName(), docType2.getRootElementName());
    }

    public static void assertEquals(Element element, Element element2) {
        XOMTestCase.assertEquals(null, element, element2);
    }

    public static void assertEquals(String string, Element element, Element element2) {
        Object object;
        Object object2;
        int n;
        if (element2 == element) {
            return;
        }
        XOMTestCase.nullCheck(string, element, element2);
        XOMTestCase.assertEquals(string, element.getLocalName(), element2.getLocalName());
        XOMTestCase.assertEquals(string, element.getNamespacePrefix(), element2.getNamespacePrefix());
        XOMTestCase.assertEquals(string, element.getNamespaceURI(), element2.getNamespaceURI());
        XOMTestCase.assertEquals(string, element.getAttributeCount(), element2.getAttributeCount());
        for (n = 0; n < element.getAttributeCount(); ++n) {
            object2 = element.getAttribute(n);
            object = element2.getAttribute(((Attribute)object2).getLocalName(), ((Attribute)object2).getNamespaceURI());
            XOMTestCase.assertNotNull(string, object);
            XOMTestCase.assertEquals(string, (Attribute)object2, (Attribute)object);
        }
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            object2 = element.getNamespacePrefix(n);
            object = element.getNamespaceURI((String)object2);
            XOMTestCase.assertNotNull(string, element2.getNamespaceURI((String)object2));
            XOMTestCase.assertEquals(string, (String)object, element2.getNamespaceURI((String)object2));
        }
        for (n = 0; n < element2.getNamespaceDeclarationCount(); ++n) {
            object2 = element2.getNamespacePrefix(n);
            object = element2.getNamespaceURI((String)object2);
            XOMTestCase.assertNotNull(string, element.getNamespaceURI((String)object2));
            XOMTestCase.assertEquals(string, (String)object, element.getNamespaceURI((String)object2));
        }
        XOMTestCase.compareChildren(string, element, element2);
    }

    private static boolean hasAdjacentTextNodes(Element element) {
        boolean bl = false;
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                if (bl) {
                    return true;
                }
                if ("".equals(node.getValue())) {
                    return true;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
        return false;
    }

    private static void compareChildren(String string, Element element, Element element2) {
        int n;
        Element element3 = element;
        Element element4 = element2;
        if (XOMTestCase.hasAdjacentTextNodes(element)) {
            element3 = XOMTestCase.combineTextNodes(element);
        }
        if (XOMTestCase.hasAdjacentTextNodes(element2)) {
            element4 = XOMTestCase.combineTextNodes(element2);
        }
        int n2 = element3.getChildCount();
        XOMTestCase.assertEquals(string, n2, element4.getChildCount());
        int n3 = n2;
        for (n = 0; n < n2; ++n) {
            Node node = element3.getChild(n);
            if (!(node instanceof Text)) continue;
            --n3;
            Node node2 = element4.getChild(n);
            XOMTestCase.assertEquals(string, node, node2);
        }
        n = 0;
        int n4 = element.getChildCount();
        for (int i = 0; i < n4; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) continue;
            Node node3 = element2.getChild(n);
            ++n;
            while (node3 instanceof Text) {
                node3 = element2.getChild(n);
                ++n;
            }
            XOMTestCase.assertEquals(string, node, node3);
        }
    }

    private static Element combineTextNodes(Element element) {
        Element element2 = new Element("a");
        Comment comment = new Comment("c");
        StringBuffer stringBuffer = new StringBuffer();
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                if ("".equals(node.getValue())) continue;
                stringBuffer.setLength(0);
                do {
                    stringBuffer.append(node.getValue());
                } while (++i != n && (node = element.getChild(i)) instanceof Text);
                --i;
                element2.appendChild(stringBuffer.toString());
                continue;
            }
            element2.appendChild(comment.copy());
        }
        return element2;
    }

    public static void assertEquals(Document document, Document document2) {
        XOMTestCase.assertEquals(null, document, document2);
    }

    public static void assertEquals(String string, Document document, Document document2) {
        if (document2 == document) {
            return;
        }
        XOMTestCase.nullCheck(string, document, document2);
        XOMTestCase.assertEquals(string, document.getChildCount(), document2.getChildCount());
        for (int i = 0; i < document2.getChildCount(); ++i) {
            Node node = document.getChild(i);
            Node node2 = document2.getChild(i);
            XOMTestCase.assertEquals(string, node, node2);
        }
    }

    public static void assertEquals(Comment comment, Comment comment2) {
        XOMTestCase.assertEquals(null, comment, comment2);
    }

    public static void assertEquals(String string, Comment comment, Comment comment2) {
        if (comment2 == comment) {
            return;
        }
        XOMTestCase.nullCheck(string, comment, comment2);
        XOMTestCase.assertEquals(string, comment.getValue(), comment2.getValue());
    }

    public static void assertEquals(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        XOMTestCase.assertEquals(null, processingInstruction, processingInstruction2);
    }

    public static void assertEquals(String string, ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        if (processingInstruction2 == processingInstruction) {
            return;
        }
        XOMTestCase.nullCheck(string, processingInstruction, processingInstruction2);
        XOMTestCase.assertEquals(string, processingInstruction.getValue(), processingInstruction2.getValue());
        XOMTestCase.assertEquals(string, processingInstruction.getTarget(), processingInstruction2.getTarget());
    }

    public static void assertEquals(String string, Namespace namespace, Namespace namespace2) {
        if (namespace2 == namespace) {
            return;
        }
        XOMTestCase.nullCheck(string, namespace, namespace2);
        XOMTestCase.assertEquals(string, namespace.getValue(), namespace2.getValue());
        XOMTestCase.assertEquals(string, namespace.getPrefix(), namespace2.getPrefix());
    }

    public static void assertEquals(Node node, Node node2) {
        XOMTestCase.assertEquals(null, node, node2);
    }

    public static void assertEquals(String string, Node node, Node node2) {
        block11: {
            if (node2 == node) {
                return;
            }
            XOMTestCase.nullCheck(string, node, node2);
            try {
                if (node instanceof Document) {
                    XOMTestCase.assertEquals(string, (Document)node, (Document)node2);
                    break block11;
                }
                if (node instanceof Element) {
                    XOMTestCase.assertEquals(string, (Element)node, (Element)node2);
                    break block11;
                }
                if (node instanceof Text) {
                    XOMTestCase.assertEquals(string, (Text)node, (Text)node2);
                    break block11;
                }
                if (node instanceof DocType) {
                    XOMTestCase.assertEquals(string, (DocType)node, (DocType)node2);
                    break block11;
                }
                if (node instanceof Comment) {
                    XOMTestCase.assertEquals(string, (Comment)node, (Comment)node2);
                    break block11;
                }
                if (node instanceof ProcessingInstruction) {
                    XOMTestCase.assertEquals(string, (ProcessingInstruction)node, (ProcessingInstruction)node2);
                    break block11;
                }
                if (node instanceof Attribute) {
                    XOMTestCase.assertEquals(string, (Attribute)node, (Attribute)node2);
                    break block11;
                }
                if (node instanceof Namespace) {
                    XOMTestCase.assertEquals(string, (Namespace)node, (Namespace)node2);
                    break block11;
                }
                throw new IllegalArgumentException("Unexpected node type " + node.getClass().getName());
            }
            catch (ClassCastException classCastException) {
                throw new ComparisonFailure(string + "; Mismatched node types: " + node.getClass().getName() + " != " + node2.getClass().getName(), node.toXML(), node2.toXML());
            }
        }
    }
}

