/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatcher;
import net.sf.jmimemagic.MagicParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class MagicParser
extends DefaultHandler {
    private static String magicFile = "/magic.xml";
    private boolean initialized = false;
    private XMLReader parser = null;
    private final ArrayList<MagicMatcher> stack = new ArrayList();
    private final Collection<MagicMatcher> matchers = new ArrayList<MagicMatcher>();
    private MagicMatcher matcher = null;
    private MagicMatch match = null;
    private HashMap<String, String> properties = null;
    private String finalValue = "";
    private boolean isMimeType = false;
    private boolean isExtension = false;
    private boolean isDescription = false;
    private boolean isTest = false;

    public synchronized void initialize() throws MagicParseException {
        if (!this.initialized) {
            try {
                this.parser = (XMLReader)MagicMatcher.classForName("com.sun.org.apache.xerces.internal.parsers.SAXParser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                try {
                    this.parser = (XMLReader)MagicMatcher.classForName("org.apache.xerces.parsers.SAXParser").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e2) {
                    Logger.getLogger("es.gob.afirma").info("No se ha podido obtener el analizador SAX de Apache Xerces, se usara el por defecto: " + e2);
                    try {
                        this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                    }
                    catch (Exception e3) {
                        throw new MagicParseException("unable to instantiate parser", e3);
                    }
                }
            }
            this.parser.setErrorHandler(this);
            this.parser.setContentHandler(this);
            try {
                String magicURL = MagicParser.class.getResource(magicFile).toString();
                if (magicURL == null) {
                    throw new MagicParseException("couldn't load '" + magicURL + "'");
                }
                this.parser.parse(magicURL);
            }
            catch (SAXParseException magicURL) {
            }
            catch (Exception e) {
                throw new MagicParseException("Parse error occurred: " + e);
            }
            this.initialized = true;
        }
    }

    public Collection<MagicMatcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        String value = new String(ch, offset, length);
        this.finalValue = this.finalValue + value;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int offset, int length) {
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) {
        if (localName.equals("match")) {
            this.match = new MagicMatch();
            this.matcher = new MagicMatcher();
            this.matcher.setMatch(this.match);
        }
        if (this.matcher != null) {
            if (localName.equals("mimetype")) {
                this.isMimeType = true;
            } else if (localName.equals("extension")) {
                this.isExtension = true;
            } else if (localName.equals("description")) {
                this.isDescription = true;
            } else if (localName.equals("test")) {
                this.isTest = true;
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrLocalName = attributes.getLocalName(i);
                    String attrValue = attributes.getValue(i);
                    if (attrLocalName.equals("offset")) {
                        if (attrValue.equals("")) continue;
                        this.match.setOffset(Integer.valueOf(attrValue));
                        continue;
                    }
                    if (attrLocalName.equals("length")) {
                        if (attrValue.equals("")) continue;
                        this.match.setLength(Integer.valueOf(attrValue));
                        continue;
                    }
                    if (attrLocalName.equals("type")) {
                        this.match.setType(attrValue);
                        continue;
                    }
                    if (attrLocalName.equals("bitmask")) {
                        if (attrValue.equals("")) continue;
                        this.match.setBitmask(attrValue);
                        continue;
                    }
                    if (!attrLocalName.equals("comparator")) continue;
                    this.match.setComparator(attrValue);
                }
            } else if (localName.equals("property")) {
                int length = attributes.getLength();
                String name = null;
                String value = null;
                for (int i = 0; i < length; ++i) {
                    String attrLocalName = attributes.getLocalName(i);
                    String attrValue = attributes.getValue(i);
                    if (attrLocalName.equals("name")) {
                        if (attrValue.equals("")) continue;
                        name = attrValue;
                        continue;
                    }
                    if (!attrLocalName.equals("value") || attrValue.equals("")) continue;
                    value = attrValue;
                }
                if (name != null && value != null) {
                    if (this.properties == null) {
                        this.properties = new HashMap();
                    }
                    if (!this.properties.containsKey(name)) {
                        this.properties.put(name, value);
                    }
                }
            } else if (localName.equals("match-list")) {
                this.stack.add(this.matcher);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        if (this.isMimeType) {
            this.isMimeType = false;
            this.match.setMimeType(this.finalValue);
        } else if (this.isExtension) {
            this.isExtension = false;
            this.match.setExtension(this.finalValue);
        } else if (this.isDescription) {
            this.isDescription = false;
            this.match.setDescription(this.finalValue);
        } else if (this.isTest) {
            this.isTest = false;
            this.match.setTest(MagicParser.convertOctals(this.finalValue));
        }
        this.finalValue = "";
        if (localName.equals("match")) {
            if (this.matcher.isValid()) {
                this.match.setProperties(this.properties);
                if (this.stack.size() == 0) {
                    this.matchers.add(this.matcher);
                } else {
                    MagicMatcher m = this.stack.get(this.stack.size() - 1);
                    m.addSubMatcher(this.matcher);
                }
            }
            this.matcher = null;
            this.properties = null;
        } else if (localName.equals("match-list")) {
            if (this.stack.size() > 0) {
                this.matcher = this.stack.get(this.stack.size() - 1);
                this.stack.remove(this.matcher);
            }
        } else if (localName.equals("mimetype")) {
            this.isMimeType = false;
        } else if (localName.equals("extension")) {
            this.isExtension = false;
        } else if (localName.equals("description")) {
            this.isDescription = false;
        } else if (localName.equals("test")) {
            this.isTest = false;
        }
    }

    @Override
    public void warning(SAXParseException ex) {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    private static ByteBuffer convertOctals(String s) {
        int beg = 0;
        int end = 0;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((end = s.indexOf(92, beg)) != -1) {
            if (s.charAt(end + 1) != '\\') {
                for (int z = beg; z < end; ++z) {
                    buf.write(s.charAt(z));
                }
                if (end + 4 <= s.length()) {
                    try {
                        int chr = Integer.parseInt(s.substring(end + 1, end + 4), 8);
                        buf.write(chr);
                        end = beg = end + 4;
                    }
                    catch (NumberFormatException nfe) {
                        buf.write(92);
                        end = beg = end + 1;
                    }
                    continue;
                }
                buf.write(92);
                end = beg = end + 1;
                continue;
            }
            buf.write(92);
            end = beg = end + 1;
        }
        if (end < s.length()) {
            for (int z = beg; z < s.length(); ++z) {
                buf.write(s.charAt(z));
            }
        }
        try {
            ByteBuffer b = ByteBuffer.allocate(buf.size());
            return b.put(buf.toByteArray());
        }
        catch (Exception e) {
            return ByteBuffer.allocate(0);
        }
    }
}

