/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicMatcher;
import net.sf.jmimemagic.MagicParseException;
import net.sf.jmimemagic.MagicParser;

public final class Magic {
    private static boolean initialized = false;
    private static MagicParser magicParser = null;
    private static HashMap<String, ArrayList<MagicMatcher>> hintMap = new HashMap();

    private static void addHint(String extension, MagicMatcher matcher) {
        if (hintMap.keySet().contains(extension)) {
            ArrayList<MagicMatcher> a = hintMap.get(extension);
            a.add(matcher);
        } else {
            ArrayList<MagicMatcher> a = new ArrayList<MagicMatcher>();
            a.add(matcher);
            hintMap.put(extension, a);
        }
    }

    public static synchronized void initialize() throws MagicParseException {
        if (!initialized) {
            magicParser = new MagicParser();
            magicParser.initialize();
            for (MagicMatcher matcher : magicParser.getMatchers()) {
                String[] exts;
                String ext = matcher.getMatch().getExtension();
                if (ext != null && !ext.trim().equals("")) {
                    Magic.addHint(ext, matcher);
                    continue;
                }
                if (!matcher.getMatch().getType().equals("detector")) continue;
                for (String ext2 : exts = matcher.getDetectorExtensions()) {
                    Magic.addHint(ext2, matcher);
                }
            }
            initialized = true;
        }
    }

    public static MagicMatch getMagicMatch(byte[] data) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        return Magic.getMagicMatch(data, false);
    }

    public static MagicMatch getMagicMatch(byte[] data, boolean onlyMimeMatch) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        if (!initialized) {
            Magic.initialize();
        }
        Collection<MagicMatcher> matchers = magicParser.getMatchers();
        MagicMatcher matcher2 = null;
        MagicMatch match = null;
        for (MagicMatcher matcher2 : matchers) {
            try {
                match = matcher2.test(data, onlyMimeMatch);
                if (match == null) continue;
                return match;
            }
            catch (Throwable e) {
                throw new MagicException(e);
            }
        }
        throw new MagicMatchNotFoundException();
    }
}

