/*
 * Decompiled with CFR 0.152.
 */
package net.gestores.pdfbox.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.EnumMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.spongycastle.asn1.x500.RDN;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x500.style.BCStyle;
import org.spongycastle.asn1.x500.style.IETFUtils;
import org.spongycastle.cert.jcajce.JcaX509CertificateHolder;

public class Utilidades {
    private static final String ES_JSON_ERROR_HTTP = "{\"result\":\"error\"";
    private static final String INICIO_JSON_ERROR_HTTP = "\"message\":\"";
    private static final String FIN_JSON_ERROR_HTTP = "\"}";
    private static final String INICIO_SERIALNUMBER_CERTIFICADO = "SERIALNUMBER=";
    private static final String FIN_SERIALNUMBER_CERTIFICADO = ",";

    public static String trim(String string) {
        String string2 = string;
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.toString());
    }

    public static boolean cadenaEsError(String string) {
        return Utilidades.trim(string) != null && string.startsWith(ES_JSON_ERROR_HTTP);
    }

    public static String cadenaGetError(String string) {
        if (Utilidades.cadenaEsError(string)) {
            String string2 = string.substring(string.indexOf(INICIO_JSON_ERROR_HTTP) + INICIO_JSON_ERROR_HTTP.length(), string.indexOf(FIN_JSON_ERROR_HTTP));
            return string2;
        }
        return null;
    }

    public static X509Certificate getCertificado(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public static String getNifCertificado(byte[] byArray) {
        X509Certificate x509Certificate = Utilidades.getCertificado(byArray);
        if (x509Certificate != null) {
            String string = x509Certificate.getSubjectDN().toString();
            return Utilidades.devuelveNifCadena(string);
        }
        return null;
    }

    public static String getNombreCertificado(byte[] byArray) {
        X509Certificate x509Certificate = Utilidades.getCertificado(byArray);
        if (x509Certificate != null) {
            try {
                X500Name x500Name = new JcaX509CertificateHolder(x509Certificate).getSubject();
                RDN rDN = x500Name.getRDNs(BCStyle.CN)[0];
                return IETFUtils.valueToString(rDN.getFirst().getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String devuelveNifCadena(String string) {
        String string2 = Utilidades.extraerRegexpCadena("SERIALNUMBER=(([0-9]{8}[A-Z]{1})|([LMXYZ]{1}[0-9]{7}[A-Z]{1}))", string);
        if (string2 == null) {
            string2 = Utilidades.extraerRegexpCadena("SERIALNUMBER=IDCES-(([0-9]{8}[A-Z]{1})|([LMXYZ]{1}[0-9]{7}[A-Z]{1}))", string);
        }
        if (string2 == null) {
            string2 = Utilidades.extraerRegexpCadena("CN=NOMBRE [^-]+ - NIF (([0-9]{8}[A-Z]{1})|([LMXYZ]{1}[0-9]{7}[A-Z]{1}))", string);
        }
        if (string2 == null) {
            string2 = Utilidades.extraerRegexpCadena("CN\\s*=\\s*([0-9]{8}[A-Z]{1})|([LMXYZ]{1}[0-9]{7}[A-Z]{1})", string);
        }
        return string2;
    }

    public static String extraerRegexpCadena(String string, String string2) {
        int n;
        Pattern pattern = Pattern.compile(string, 2);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find() && (n = 1) < matcher.groupCount()) {
            return matcher.group(n);
        }
        return null;
    }

    public static String extraerCadena(String string, String string2, String string3) {
        if (Utilidades.trim(string) != null && string.contains(string2)) {
            String string4 = string.substring(string.indexOf(string2) + string2.length(), string.length());
            return string4.substring(0, string4.indexOf(string3));
        }
        return null;
    }

    public static byte[] generateQRCode(String string, int n, int n2, String string2) {
        try {
            EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            enumMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            enumMap.put(EncodeHintType.MARGIN, Integer.valueOf(0));
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n2, n2, enumMap);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream(bitMatrix, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            Font font = new Font("Arial", 0, 35);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString("Firmado por:", n2 + 15, fontMetrics.getAscent() * 2 + 20);
            graphics2D.drawString(string2, n2 + 15, fontMetrics.getAscent() * 5 + 30);
            Font font2 = new Font("Arial", 0, 35);
            graphics2D.setFont(font2);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, n2 + 15, fontMetrics.getAscent() * 8 + 60);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BufferedImage bufferedImage2 = ImageIO.read(byteArrayInputStream);
            graphics2D.drawImage(bufferedImage2, 0, 0, n2, n2, null);
            graphics2D.dispose();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream2);
            byteArrayOutputStream2.flush();
            byArray = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream2.close();
            return byArray;
        }
        catch (WriterException | IOException exception) {
            return null;
        }
    }
}

