/*
 * Decompiled with CFR 0.152.
 */
package net.gestores.pdfbox.utils;

import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.util.Properties;
import net.gestores.pdfbox.utils.Utilidades;

public class RequestParams {
    public static final String APPLET_PARAM_OPERATION = "Operation";
    public static final String APPLET_PARAM_SUB_OPERATION = "SubOperation";
    public static final String APPLET_PARAM_USER_AGENT = "UserAgent";
    public static final String APPLET_PARAM_USER_KEYSTORE = "Keystore";
    public static final String APPLET_PARAM_USER_SESSION_ID = "SessionId";
    public static final String APPLET_PARAM_USER_SESSION_NAME = "SessionName";
    public static final String APPLET_PARAM_USER_LAST_REFRESH = "LastRefresh";
    public static final String APPLET_PARAM_USER_LAST_REFRESH_NAME = "LastRefreshName";
    public static final String APPLET_PARAM_USER_ROOT = "HtmlRoot";
    public static final String APPLET_PARAM_USER_ROOT_GET = "HtmlRootGet";
    public static final String APPLET_PARAM_USER_ROOT_POST = "HtmlRootPost";
    public static final String APPLET_PARAM_SIGNATURE_ALGORITHM = "Algorithm";
    public static final String APPLET_PARAM_DOCUMENT_SOURCE = "Source";
    public static final String APPLET_PARAM_USER_CSRF_NAME = "CSRFName";
    public static final String APPLET_PARAM_USER_CSRF = "CSRF";
    public static final String APPLET_PARAM_GFX_BACKGROUND = "gfx.background";
    public static final String APPLET_PARAM_GFX_ICON = "gfx.icon";
    public static final String APPLET_PARAM_GFX_PROGRESS_BAR = "gfx.progressbar";
    public static final String APPLET_PARAM_GFX_TITLE = "gfx.title";
    public static final String APPLET_PARAM_ERRORS_ENABLED = "errors.enabled";
    public static final String APPLET_PARAM_FIREFOX_KEYSTORE = "firefox.keystore";
    public static final String APPLET_PARAM_FORMAT = "format";
    public static final String APPLET_PARAM_NIF_GESTOR = "NifGestor";
    public static final String APPLET_PARAM_FORZAR_CERTFICICADO_PETICION = "RequestCert";
    public static final String APPLET_PARAM_MODE = "mode";
    public static final String APPLET_PARAM_HEADLESS = "headless";
    public static final String APPLET_PARAM_HTTPS = "https";
    public static final String APPLET_PARAM_FILTER = "filter";
    public static final String APPLET_PARAM_LAUNCH = "Launch";
    public static final String APPLET_PARAM_DISTINTO_CERT = "DistintoCert";
    public static final String PDFBOX_POSICION_X = "pdfbox.posicionX";
    public static final String PDFBOX_POSICION_Y = "pdfbox.posicionY";
    public static final String PDFBOX_ANCHO = "pdfbox.ancho";
    public static final String PDFBOX_ALTO = "pdfbox.alto";
    public static final String APPLET_DEBUG = "debug";
    public static final String URL_CSV = "UrlCsv";
    private static Properties parametrosRequest;
    private static String parametrosString;

    public static Properties getParametros() {
        return parametrosRequest;
    }

    public static String getParametro(String string) {
        return parametrosRequest != null ? parametrosRequest.getProperty(string) : null;
    }

    public static boolean getParametroBoolean(String string) {
        String string2 = RequestParams.getParametro(string);
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getParametroEntero(String string) {
        String string2 = RequestParams.getParametro(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void setParametros(String string) {
        parametrosString = string;
        parametrosRequest = new Properties();
        if (string != null) {
            try {
                parametrosRequest.load(new ByteArrayInputStream(string.getBytes()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getCookieString() throws Exception {
        String string = RequestParams.getParametro(APPLET_PARAM_USER_SESSION_NAME);
        String string2 = RequestParams.getParametro(APPLET_PARAM_USER_SESSION_ID);
        String string3 = RequestParams.getParametro(APPLET_PARAM_USER_LAST_REFRESH_NAME);
        String string4 = RequestParams.getParametro(APPLET_PARAM_USER_LAST_REFRESH);
        String string5 = "";
        if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
            if (!string5.equals("")) {
                string5 = string5 + "; ";
            }
            string5 = string5 + URLEncoder.encode(string, "UTF-8") + "=" + URLEncoder.encode(string2, "UTF-8");
        }
        if (string3 != null && !string3.equals("") && string4 != null && !string4.equals("")) {
            if (!string5.equals("")) {
                string5 = string5 + "; ";
            }
            string5 = string5 + URLEncoder.encode(string3, "UTF-8") + "=" + URLEncoder.encode(string4, "UTF-8");
        }
        return string5;
    }

    public static String getParametrosSolicitud() {
        return "id=" + RequestParams.getParametro(APPLET_PARAM_USER_SESSION_ID) + "&token=" + RequestParams.getParametro(APPLET_PARAM_USER_CSRF);
    }

    public static String getExtraParamsCertificado() {
        String string = "UserAgent=" + RequestParams.getParametro(APPLET_PARAM_USER_AGENT) + "\n";
        string = string + "Operation=" + RequestParams.getParametro(APPLET_PARAM_OPERATION) + "\n";
        string = string + "Algorithm=" + RequestParams.getParametro(APPLET_PARAM_SIGNATURE_ALGORITHM) + "\n";
        string = string + "format=" + RequestParams.getParametro(APPLET_PARAM_FORMAT) + "\n";
        string = string + "mode=" + RequestParams.getParametro(APPLET_PARAM_MODE) + "\n";
        string = string + "headless=" + RequestParams.getParametro(APPLET_PARAM_HEADLESS) + "\n";
        string = string + "errors.enabled=" + RequestParams.getParametro(APPLET_PARAM_ERRORS_ENABLED);
        if (Utilidades.trim(RequestParams.getParametro(APPLET_PARAM_HTTPS)) != null) {
            string = string + "\nhttps=" + RequestParams.getParametro(APPLET_PARAM_HTTPS);
        }
        if (Utilidades.trim(RequestParams.getParametro(APPLET_PARAM_FILTER)) != null) {
            string = string + "\nfilter=" + RequestParams.getParametro(APPLET_PARAM_FILTER);
        }
        return string;
    }

    public static final String getParametrosCompletosString() {
        String string = parametrosString;
        if (Utilidades.trim(RequestParams.getParametro(APPLET_PARAM_HTTPS)) != null) {
            string = string + "\nhttps=" + RequestParams.getParametro(APPLET_PARAM_HTTPS);
        }
        if (Utilidades.trim(RequestParams.getParametro(APPLET_PARAM_FILTER)) != null) {
            string = string + "\nfilter=" + RequestParams.getParametro(APPLET_PARAM_FILTER);
        }
        return string;
    }
}

