/*
 * Decompiled with CFR 0.152.
 */
package net.gestores.pdfbox.utils;

import es.gob.afirma.core.misc.Base64;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.gestores.pdfbox.SignerThempusActionApplet;
import net.gestores.pdfbox.ssl.KeyManager;
import net.gestores.pdfbox.ssl.SigaSSLSocketFactory;
import net.gestores.pdfbox.utils.RequestParams;
import net.gestores.pdfbox.utils.Utilidades;

public class HttpUtils {
    private static final String CHARSET_HTTP_REQUESTS = "UTF-8";

    public static HttpURLConnection obtenerConexion(String string, boolean bl, KeyStore.PrivateKeyEntry privateKeyEntry) throws Exception {
        Object object;
        Object object2;
        boolean bl2 = string.startsWith("https");
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = null;
        if (!bl2) {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        } else {
            object2 = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            object = SSLContext.getInstance("SSL");
            ((SSLContext)object).init(null, (TrustManager[])object2, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)object).getSocketFactory());
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            if (bl) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(new SigaSSLSocketFactory(new KeyManager(privateKeyEntry)));
            }
        }
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Accept-Charset", CHARSET_HTTP_REQUESTS);
        httpURLConnection.setRequestProperty("charset", CHARSET_HTTP_REQUESTS);
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        object2 = RequestParams.getParametro("UserAgent");
        object = RequestParams.getCookieString();
        if (Utilidades.trim((String)object2) != null) {
            httpURLConnection.setRequestProperty("User-Agent", (String)object2);
        }
        if (Utilidades.trim((String)object) != null) {
            httpURLConnection.setRequestProperty("Cookie", (String)object);
        }
        SignerThempusActionApplet.log("Llamando a la URL: " + uRL);
        SignerThempusActionApplet.log("User-Agent: " + (String)object2);
        SignerThempusActionApplet.log("Cookies: " + (String)object);
        return httpURLConnection;
    }

    public static String getArchivoBase64(String string, boolean bl, KeyStore.PrivateKeyEntry privateKeyEntry) throws Exception {
        StringBuilder stringBuilder;
        String string2 = RequestParams.getParametrosSolicitud();
        String string3 = string + "?" + string2;
        HttpURLConnection httpURLConnection = HttpUtils.obtenerConexion(string3, bl, privateKeyEntry);
        httpURLConnection.setRequestMethod("GET");
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = httpURLConnection.getInputStream();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, CHARSET_HTTP_REQUESTS));){
            String string4;
            stringBuilder = new StringBuilder();
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string4);
            }
        }
        return stringBuilder.toString();
    }

    public static void postArchivoBase64(String string, String string2, boolean bl, KeyStore.PrivateKeyEntry privateKeyEntry) throws Exception {
        HttpURLConnection httpURLConnection = HttpUtils.obtenerConexion(string, bl, privateKeyEntry);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        String string3 = "oak_csrf_token=" + URLEncoder.encode(RequestParams.getParametro("CSRF"), CHARSET_HTTP_REQUESTS);
        string3 = string3 + "&firma[]=" + URLEncoder.encode(string2, CHARSET_HTTP_REQUESTS);
        byte[] byArray = string3.getBytes();
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string3.length()));
        Closeable closeable = httpURLConnection.getOutputStream();
        Serializable serializable = null;
        try {
            ((OutputStream)closeable).write(byArray);
            ((OutputStream)closeable).flush();
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (serializable != null) {
                    try {
                        ((OutputStream)closeable).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)closeable).close();
                }
            }
        }
        closeable = httpURLConnection.getErrorStream();
        if (closeable == null) {
            closeable = httpURLConnection.getInputStream();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)closeable, CHARSET_HTTP_REQUESTS));){
            String string4;
            serializable = new StringBuilder();
            while ((string4 = bufferedReader.readLine()) != null) {
                ((StringBuilder)serializable).append(string4);
            }
        }
    }

    public static String getArchivoThempus(String string, KeyStore.PrivateKeyEntry privateKeyEntry) throws Exception {
        StringBuilder stringBuilder;
        HttpURLConnection httpURLConnection = HttpUtils.obtenerConexion(string, true, privateKeyEntry);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setDoOutput(true);
        SignerThempusActionApplet.log("URL GET: " + string);
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = httpURLConnection.getInputStream();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, CHARSET_HTTP_REQUESTS));){
            String string2;
            stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    public static void postArchivoThempus(String string, String string2, boolean bl, KeyStore.PrivateKeyEntry privateKeyEntry) throws Exception {
        HttpURLConnection httpURLConnection = HttpUtils.obtenerConexion(string, bl, privateKeyEntry);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("Accept", "application/vnd.copperforest.oak+xml");
        httpURLConnection.setRequestProperty("Html-Root", RequestParams.getParametro("HtmlRoot"));
        String string3 = Base64.encode(privateKeyEntry.getCertificate().getEncoded());
        String string4 = "cert=" + URLEncoder.encode(string3, CHARSET_HTTP_REQUESTS) + "&status=" + URLEncoder.encode("0", CHARSET_HTTP_REQUESTS) + "&status_error=" + URLEncoder.encode("", CHARSET_HTTP_REQUESTS);
        string4 = string4 + "&firma[]=" + URLEncoder.encode(string2, CHARSET_HTTP_REQUESTS);
        string4 = string4 + "&oak_action=" + URLEncoder.encode(RequestParams.getParametro("format"), CHARSET_HTTP_REQUESTS);
        String string5 = RequestParams.getParametro("SubOperation");
        if (string5 != null && !string5.equals("")) {
            string4 = string4 + "&oak_sub_action=" + string5;
        }
        String string6 = RequestParams.getParametro("CSRFName");
        String string7 = RequestParams.getParametro("CSRF");
        if (string7 != null && !string7.equals("")) {
            string4 = string4 + "&" + string6 + "=" + string7;
        }
        SignerThempusActionApplet.log("Par\u00e1metros: " + string4);
        byte[] byArray = string4.getBytes();
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = httpURLConnection.getInputStream();
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, CHARSET_HTTP_REQUESTS));){
            String string8;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string8 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string8);
            }
        }
    }
}

