/*
 * Decompiled with CFR 0.152.
 */
package net.gestores.pdfbox.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SigaSSLSocketFactory
extends SSLSocketFactory {
    private SSLContext sslContext;
    private String contextProtocol = "TLS";
    private String[] protocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private String[] cipherSuite = new String[]{"TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", "TLS_DHE_RSA_WITH_SEED_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", "TLS_RSA_WITH_SEED_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};

    public SigaSSLSocketFactory(KeyManager keyManager) throws Exception {
        TrustManager[] trustManagerArray = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                System.out.println("checkServerTrusted " + string);
            }
        }};
        this.sslContext = SSLContext.getInstance(this.contextProtocol);
        this.sslContext.init(new KeyManager[]{keyManager}, trustManagerArray, new SecureRandom());
        System.out.println("CONTEXT PROVIDER:" + this.sslContext.getProvider().getName());
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        socket = this.sslContext.getSocketFactory().createSocket(socket, string, n, bl);
        ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        ((SSLSocket)socket).setUseClientMode(true);
        ((SSLSocket)socket).setEnabledCipherSuites(this.filteredCipherSuites());
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket();
        ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        ((SSLSocket)socket).setUseClientMode(true);
        ((SSLSocket)socket).setEnabledCipherSuites(this.filteredCipherSuites());
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslContext.getSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSocketFactory().getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = this.sslContext.getSocketFactory().createSocket(string, n);
        ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        ((SSLSocket)socket).setUseClientMode(true);
        ((SSLSocket)socket).setEnabledCipherSuites(this.filteredCipherSuites());
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = this.sslContext.getSocketFactory().createSocket(string, n, inetAddress, n2);
        ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        ((SSLSocket)socket).setUseClientMode(true);
        ((SSLSocket)socket).setEnabledCipherSuites(this.filteredCipherSuites());
        String[] stringArray = ((SSLSocket)socket).getEnabledProtocols();
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket(inetAddress, n);
        ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        ((SSLSocket)socket).setUseClientMode(true);
        ((SSLSocket)socket).setEnabledCipherSuites(this.filteredCipherSuites());
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket(inetAddress, n, inetAddress2, n2);
        ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        ((SSLSocket)socket).setUseClientMode(true);
        ((SSLSocket)socket).setEnabledCipherSuites(this.filteredCipherSuites());
        return socket;
    }

    public String[] filteredCipherSuites() {
        SSLSocketFactory sSLSocketFactory = this.sslContext.getSocketFactory();
        String[] stringArray = sSLSocketFactory.getSupportedCipherSuites();
        return stringArray;
    }
}

