/*
 * Decompiled with CFR 0.152.
 */
package net.gestores.pdfbox;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.miniapplet.MiniAfirmaApplet;
import java.security.KeyStore;
import java.util.logging.Level;
import javax.swing.UIManager;
import net.gestores.pdfbox.MiniAfirmaWindow;
import net.gestores.pdfbox.utils.HttpUtils;
import net.gestores.pdfbox.utils.RequestParams;
import net.gestores.pdfbox.utils.Utilidades;

public class SignerActionApplet {
    private static boolean DEBUG = true;
    private static final String VALOR_TITULO_DEFECTO = "PDFBox-Firma";
    private static final MiniAfirmaApplet applet = new MiniAfirmaApplet();
    private static final MiniAfirmaWindow ventanaAviso = new MiniAfirmaWindow();

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        String string;
        String[] stringArray2;
        String string2;
        String string3;
        void var4_10;
        try {
            for (UIManager.LookAndFeelInfo object2 : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(object2.getName())) continue;
                UIManager.setLookAndFeel(object2.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperty("https.protocols", "TLSv1.2,TLSv1.1,TLSv1");
        RequestParams.setParametros(stringArray[0]);
        DEBUG = RequestParams.getParametroBoolean("debug");
        boolean bl = RequestParams.getParametroBoolean("RequestCert");
        String string4 = null;
        int n = RequestParams.getParametroBoolean("errors.enabled") ? 1 : 0;
        ventanaAviso.setEnableErrors(n != 0);
        String string5 = VALOR_TITULO_DEFECTO;
        if (RequestParams.getParametro("gfx.title") != null) {
            String string6 = RequestParams.getParametro("gfx.title");
        }
        ventanaAviso.setTitle((String)var4_10);
        String string7 = RequestParams.getParametro("gfx.icon");
        if (string7 != null && string7.length() > 0) {
            ventanaAviso.setTrayIconB64(string7);
        }
        if ((string3 = RequestParams.getParametro("gfx.background")) != null && string3.length() > 0) {
            ventanaAviso.setBackgroundB64(string3);
        }
        if ((string2 = RequestParams.getParametro("gfx.progressbar")) != null && string2.length() > 0 && (stringArray2 = string2.split(",")).length >= 4) {
            try {
                ventanaAviso.setProgressBarBounds(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]));
            }
            catch (Exception privateKeyEntry) {
                // empty catch block
            }
        }
        ventanaAviso.open();
        boolean bl2 = false;
        ventanaAviso.setProgress(10, "Comprobando almac\u00e9n de certificados");
        applet.setStickySignatory(true);
        try {
            string4 = applet.selectCertificate(RequestParams.getExtraParamsCertificado());
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            ventanaAviso.addError("No se ha seleccionado un certificado");
            bl2 = true;
        }
        catch (Exception exception) {
            ventanaAviso.addError("Fall\u00f3 al obtener el certificado");
            bl2 = true;
        }
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        try {
            privateKeyEntry = applet.selectPrivateKey(null);
        }
        catch (Exception string6) {
            string6.printStackTrace();
        }
        if (RequestParams.getParametroBoolean("DistintoCert")) {
            applet.setStickySignatory(false);
            applet.setStickySignatory(true);
            try {
                string4 = applet.selectCertificate(RequestParams.getExtraParamsCertificado());
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                ventanaAviso.addError("No se ha seleccionado un certificado");
                bl2 = true;
            }
            catch (Exception exception) {
                ventanaAviso.addError("Fall\u00f3 al obtener el certificado");
                bl2 = true;
            }
        }
        applet.setStickySignatory(true);
        ventanaAviso.setProgress(20, "Comprobando certificado");
        String string8 = null;
        String string9 = null;
        if (!bl2 && string4 != null) {
            try {
                string8 = Utilidades.trim(Utilidades.getNifCertificado(Base64.decode(string4)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = Utilidades.trim(RequestParams.getParametro("NifGestor"));
            if (string8 == null || !string8.equals(string)) {
                ventanaAviso.addError("El NIF no es v\u00e1lido");
                bl2 = true;
            }
            try {
                string9 = Utilidades.trim(Utilidades.getNombreCertificado(Base64.decode(string4)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2) {
            try {
                String string10;
                String string11;
                string = RequestParams.getParametro("HtmlRoot");
                ventanaAviso.setProgress(30, "Descargando archivo PDF");
                boolean bl3 = false;
                String string12 = null;
                try {
                    string12 = HttpUtils.getArchivoBase64(string, bl, privateKeyEntry);
                }
                catch (Exception exception) {
                    ventanaAviso.addError("Fall\u00f3 al obtener el PDF");
                    bl3 = true;
                }
                if (!bl3 && (Utilidades.trim(string12) == null || Utilidades.cadenaEsError(string12))) {
                    String string13 = Utilidades.cadenaGetError(string12);
                    ventanaAviso.addError("Error al obtener el PDF: " + string13);
                    bl3 = true;
                } else {
                    ventanaAviso.setProgress(50, "Archivo PDF obtenido correctamente");
                    applet.addData(string12);
                }
                boolean bl4 = false;
                StringBuilder stringBuilder = null;
                if (!bl3) {
                    string11 = "allowSigningCertifiedPdfs=true";
                    string10 = RequestParams.getParametro("UrlCsv");
                    if (Utilidades.trim(string10) != null) {
                        byte[] byArray = Utilidades.generateQRCode(string10, 1700, 200, string9 + " (" + string8 + ")");
                        string11 = "allowSigningCertifiedPdfs=true\nsignatureRubricImage=" + Base64.encode(byArray) + "\nsignaturePositionOnPageLowerLeftX = 160\nsignaturePositionOnPageLowerLeftY = 5\nsignaturePositionOnPageUpperRightX = 550\nsignaturePositionOnPageUpperRightY = 45\nlayer2FontSize = 10\nsignaturePage = 1";
                    }
                    ventanaAviso.setProgress(60, "Firmando archivo PDF");
                    try {
                        stringBuilder = new StringBuilder(applet.sign(RequestParams.getParametro("Algorithm"), "Adobe PDF", string11));
                        bl4 = true;
                        ventanaAviso.setProgress(70, "PDF firmado correctamente");
                    }
                    catch (AOCancelledOperationException aOCancelledOperationException) {
                        ventanaAviso.addError("No se ha seleccionado un certificado");
                    }
                    catch (Exception exception) {
                        ventanaAviso.addError("Fall\u00f3 al firmar el PDF");
                    }
                }
                SignerActionApplet.log("FIN DE LA PRIMERA FIRMA");
                if (!bl3) {
                    SignerActionApplet.log("FIRMANDO LOS DATOS");
                    if (bl4) {
                        string11 = applet.getRemainingData();
                        while (!"%%EOF%%".equals(string11)) {
                            stringBuilder.append(string11);
                            string11 = applet.getRemainingData();
                        }
                        string10 = stringBuilder.substring(stringBuilder.indexOf("|") + 1);
                        SignerActionApplet.log("INICIO ENVIO DE FIRMA");
                        ventanaAviso.setProgress(70, "Enviando PDF firmado");
                        if (Utilidades.trim(string10) != null) {
                            HttpUtils.postArchivoBase64(string, string10, bl, privateKeyEntry);
                        }
                        ventanaAviso.setProgress(100, "Archivo PDF recibido correctamente");
                        ventanaAviso.setSuccessMensaje("Proceso completado correctamente");
                        SignerActionApplet.log("FIN ENVIO DE FIRMA");
                        SignerActionApplet.log("FIN DE FIRMA CON CERTIFICADO");
                    } else {
                        SignerActionApplet.log("NO SE HA SELECCIONADO UN CERTIFICADO");
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ventanaAviso.addError("Error inesperado");
                SignerActionApplet.log("TERMINANDO" + exception);
            }
        }
        ventanaAviso.close();
        SignerActionApplet.log("TERMINANDO");
    }

    private static void log(String string) {
        if (DEBUG) {
            Utilidades.getLogger(SignerActionApplet.class).log(Level.INFO, string);
        }
    }
}

