/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml;

import es.uji.crypto.xades.jxades.security.xml.InvalidSignature;
import es.uji.crypto.xades.jxades.security.xml.InvalidSignatureReason;
import es.uji.crypto.xades.jxades.security.xml.SignatureStatus;
import es.uji.crypto.xades.jxades.security.xml.ValidateResult;
import es.uji.crypto.xades.jxades.security.xml.X509DataKeySelectorResult;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSignatureElement {
    private Element signatureElement;
    private XMLSignatureFactory xmlSignatureFactory;
    private KeySelector keySelector;

    public XMLSignatureElement(Element signatureElement) {
        if (signatureElement == null) {
            throw new IllegalArgumentException("Signature Element can not be NULL.");
        }
        this.signatureElement = signatureElement;
    }

    protected XMLSignatureFactory getXMLSignatureFactory() {
        if (this.xmlSignatureFactory == null) {
            this.xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
        return this.xmlSignatureFactory;
    }

    protected KeySelector getKeySelector() {
        if (this.keySelector == null) {
            this.keySelector = new KeyValueKeySelector();
        }
        return this.keySelector;
    }

    public XMLSignature getXMLSignature() throws MarshalException {
        DOMValidateContext valContext = new DOMValidateContext(this.getKeySelector(), (Node)this.signatureElement);
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        return fac.unmarshalXMLSignature(valContext);
    }

    public KeyInfo getKeyInfo() throws MarshalException {
        XMLSignature xmlSignature = this.getXMLSignature();
        if (xmlSignature != null) {
            return xmlSignature.getKeyInfo();
        }
        return null;
    }

    public X509Data getX509Data() throws MarshalException {
        KeyInfo keyInfo = this.getKeyInfo();
        if (keyInfo != null) {
            for (XMLStructure o1 : keyInfo.getContent()) {
                if (!(o1 instanceof X509Data)) continue;
                return (X509Data)o1;
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws MarshalException {
        X509Data x509Data = this.getX509Data();
        if (x509Data != null) {
            for (Object o1 : x509Data.getContent()) {
                if (!(o1 instanceof X509Certificate)) continue;
                return (X509Certificate)o1;
            }
        }
        return null;
    }

    public SignatureStatus validate() {
        SignatureStatus validateResult;
        DOMValidateContext valContext = new DOMValidateContext(this.getKeySelector(), (Node)this.signatureElement);
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        String signatureId = this.signatureElement.getAttribute("Id");
        XMLSignature signature = null;
        try {
            signature = fac.unmarshalXMLSignature(valContext);
        }
        catch (NullPointerException ex) {
            return new SignatureStatus(signatureId, ex);
        }
        catch (ClassCastException ex) {
            return new SignatureStatus(signatureId, ex);
        }
        catch (MarshalException ex) {
            return new SignatureStatus(signatureId, ex);
        }
        String signId = signature.getId();
        if (signatureId == null || signId != null && !signId.equals(signatureId)) {
            signatureId = signId;
        }
        boolean status = false;
        try {
            status = signature.validate(valContext);
        }
        catch (ClassCastException ex) {
            InvalidSignatureReason reason = new InvalidSignatureReason(InvalidSignature.NOT_COMPATIBLE_VALIDATE_CONTEXT, ex);
            return new SignatureStatus(signatureId, ValidateResult.INVALID, reason);
        }
        catch (NullPointerException ex) {
            InvalidSignatureReason reason = new InvalidSignatureReason("XMLSignature", ex);
            return new SignatureStatus(signatureId, ValidateResult.INVALID, reason);
        }
        catch (XMLSignatureException ex) {
            InvalidSignatureReason reason = new InvalidSignatureReason("XMLSignature", ex);
            return new SignatureStatus(signatureId, ValidateResult.INVALID, reason);
        }
        if (!status) {
            InvalidSignatureReason reason;
            validateResult = new SignatureStatus(signatureId, ValidateResult.INVALID);
            XMLSignature.SignatureValue sv = signature.getSignatureValue();
            try {
                if (!sv.validate(valContext)) {
                    InvalidSignatureReason reason2 = new InvalidSignatureReason(sv);
                    validateResult.addInvalidSignatureReason(reason2);
                }
            }
            catch (NullPointerException ex) {
                reason = new InvalidSignatureReason("SignatureValue", ex);
                validateResult.addInvalidSignatureReason(reason);
            }
            catch (XMLSignatureException ex) {
                reason = new InvalidSignatureReason("SignatureValue", ex);
                validateResult.addInvalidSignatureReason(reason);
            }
            Iterator<Reference> iter = signature.getSignedInfo().getReferences().iterator();
            int i = 0;
            while (iter.hasNext()) {
                InvalidSignatureReason reason3;
                Reference ref = iter.next();
                try {
                    if (!ref.validate(valContext)) {
                        InvalidSignatureReason reason4 = new InvalidSignatureReason(ref);
                        validateResult.addInvalidSignatureReason(reason4);
                    }
                }
                catch (NullPointerException ex) {
                    reason3 = new InvalidSignatureReason("Reference", ex);
                    validateResult.addInvalidSignatureReason(reason3);
                }
                catch (XMLSignatureException ex) {
                    reason3 = new InvalidSignatureReason("Reference", ex);
                    validateResult.addInvalidSignatureReason(reason3);
                }
                ++i;
            }
        } else {
            validateResult = new SignatureStatus(signatureId, ValidateResult.VALID);
        }
        return validateResult;
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (xmlStructure instanceof KeyValue) {
                    PublicKey pk = null;
                    try {
                        pk = ((KeyValue)xmlStructure).getPublicKey();
                    }
                    catch (KeyException ke) {
                        throw new KeySelectorException(ke);
                    }
                    if (!KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                    return new SimpleKeySelectorResult(pk);
                }
                if (!(xmlStructure instanceof X509Data)) continue;
                Certificate cert = null;
                List<?> dataList = ((X509Data)xmlStructure).getContent();
                for (Object dataObject : dataList) {
                    if (!(dataObject instanceof X509Certificate)) continue;
                    cert = (X509Certificate)dataObject;
                }
                if (cert == null) continue;
                PublicKey pk = cert.getPublicKey();
                if (!KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new X509DataKeySelectorResult((X509Data)xmlStructure);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }

        static boolean algEquals(String algURI, String algName) {
            if (algName.equalsIgnoreCase("DSA") && algURI.toUpperCase().contains("DSA")) {
                return true;
            }
            return algName.equalsIgnoreCase("RSA") && algURI.toUpperCase().contains("RSA");
        }
    }
}

