/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.SignatureStatus;
import es.uji.crypto.xades.jxades.security.xml.WrappedKeyStorePlace;
import es.uji.crypto.xades.jxades.security.xml.XAdES.BasicXAdESImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.QualifyingProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.QualifyingPropertiesReference;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignedProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_BES;
import es.uji.crypto.xades.jxades.security.xml.XMLSignatureElement;
import es.uji.crypto.xades.jxades.security.xml.XmlWrappedKeyInfo;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLAdvancedSignature {
    public static final String XADES_v132 = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String XADES_v141 = "http://uri.etsi.org/01903/v1.4.1#";
    public String signedPropertiesTypeUrl = "http://uri.etsi.org/01903#SignedProperties";
    public static final String ELEMENT_SIGNATURE = "Signature";
    public static final String ELEMENT_SIGNATURE_VALUE = "SignatureValue";
    protected BasicXAdESImpl xades;
    protected Element baseElement;
    protected XMLSignatureFactory xmlSignatureFactory;
    protected DigestMethod digestMethod;
    protected String xadesNamespace;
    protected XmlWrappedKeyInfo wrappedKeyInfo = XmlWrappedKeyInfo.CERTIFICATE;
    protected List<XMLObject> xmlObjects = new ArrayList<XMLObject>();
    protected List<XMLStructure> defaultXMLObjectItems = new ArrayList<XMLStructure>();
    protected String defaultXMLObjectId;
    protected String defaultXMLObjectMimeType;
    protected String defaultXMLObjectEncoding;
    protected XMLSignature signature;
    protected DOMSignContext signContext;
    private List<QualifyingPropertiesReference> qualifyingPropertiesReferences;

    protected XMLAdvancedSignature(XAdES_BES xades) {
        if (xades == null) {
            throw new IllegalArgumentException("XAdES parameter can not be NULL.");
        }
        this.baseElement = xades.getBaseElement();
        this.xades = (BasicXAdESImpl)xades;
    }

    public static XMLAdvancedSignature newInstance(XAdES_BES xades) throws GeneralSecurityException {
        XMLAdvancedSignature result = new XMLAdvancedSignature(xades);
        result.setDigestMethod(xades.getDigestMethod());
        result.setXadesNamespace(xades.getXadesNamespace());
        return result;
    }

    public static XMLAdvancedSignature getInstance(XAdES_BES xades) throws GeneralSecurityException {
        return XMLAdvancedSignature.newInstance(xades);
    }

    public Element getBaseElement() {
        return this.baseElement;
    }

    public Document getBaseDocument() {
        return this.xades.getBaseDocument();
    }

    public void setXadesNamespace(String xadesNamespace) {
        this.xadesNamespace = xadesNamespace;
    }

    public void setSignedPropertiesTypeUrl(String signedPropertiesTypeUrl) {
        this.signedPropertiesTypeUrl = signedPropertiesTypeUrl;
    }

    public void sign(X509Certificate certificate, PrivateKey privateKey, String signatureMethod, List refsIdList, String signatureIdPrefix) throws MarshalException, XMLSignatureException, GeneralSecurityException, TransformException, IOException, ParserConfigurationException, SAXException {
        ArrayList referencesIdList = new ArrayList(refsIdList);
        if (WrappedKeyStorePlace.SIGNING_CERTIFICATE_PROPERTY.equals((Object)this.getWrappedKeyStorePlace())) {
            this.xades.setSigningCertificate(certificate);
        }
        XMLObject xadesObject = this.marshalXMLSignature(this.xadesNamespace, this.signedPropertiesTypeUrl, signatureIdPrefix, referencesIdList);
        this.addXMLObject(xadesObject);
        String signatureId = this.getSignatureId(signatureIdPrefix);
        String signatureValueId = this.getSignatureValueId(signatureIdPrefix);
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        List<Reference> documentReferences = this.getReferences(referencesIdList);
        String keyInfoId = this.getKeyInfoId(signatureIdPrefix);
        documentReferences.add(fac.newReference("#" + keyInfoId, this.getDigestMethod()));
        SignatureMethod sm = fac.newSignatureMethod(signatureMethod, null);
        SignedInfo si = fac.newSignedInfo(cm, sm, documentReferences);
        this.signature = fac.newXMLSignature(si, this.newKeyInfo(certificate, keyInfoId), this.getXMLObjects(), signatureId, signatureValueId);
        this.signContext = this.baseElement != null ? new DOMSignContext(privateKey, (Node)this.getBaseElement()) : new DOMSignContext(privateKey, (Node)this.getBaseDocument());
        this.signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.xades.getXmlSignaturePrefix());
        this.signContext.putNamespacePrefix(this.xadesNamespace, this.xades.getXadesPrefix());
        this.signature.sign(this.signContext);
    }

    public List<SignatureStatus> validate() {
        List<XMLSignatureElement> signatureElements = this.getXMLSignatureElements();
        ArrayList<SignatureStatus> validateResult = new ArrayList<SignatureStatus>(signatureElements.size());
        for (XMLSignatureElement signatureElement : signatureElements) {
            validateResult.add(signatureElement.validate());
        }
        return validateResult;
    }

    public WrappedKeyStorePlace getWrappedKeyStorePlace() {
        return WrappedKeyStorePlace.KEY_INFO;
    }

    public void setWrappedKeyStorePlace(WrappedKeyStorePlace wrappedKeyStorePlace) {
    }

    public XmlWrappedKeyInfo getXmlWrappedKeyInfo() {
        return this.wrappedKeyInfo;
    }

    public List<XMLObject> getXMLObjects() {
        return this.xmlObjects;
    }

    public void setXmlWrappedKeyInfo(XmlWrappedKeyInfo wrappedKeyInfo) {
        this.wrappedKeyInfo = wrappedKeyInfo;
    }

    protected List<XMLSignatureElement> getXMLSignatureElements() {
        NodeList nl = null;
        nl = this.baseElement != null ? this.getBaseElement().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", ELEMENT_SIGNATURE) : this.getBaseDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", ELEMENT_SIGNATURE);
        int size = nl.getLength();
        ArrayList<XMLSignatureElement> signatureElements = new ArrayList<XMLSignatureElement>(size);
        for (int i = 0; i < size; ++i) {
            signatureElements.add(new XMLSignatureElement((Element)nl.item(i)));
        }
        return signatureElements;
    }

    protected String getSignatureId(String idPrefix) {
        return idPrefix + "-Signature";
    }

    protected String getSignatureValueId(String idPrefix) {
        return idPrefix + "-SignatureValue";
    }

    protected String getKeyInfoId(String idPrefix) {
        return idPrefix + "-KeyInfo";
    }

    protected XMLSignatureFactory getXMLSignatureFactory() {
        if (this.xmlSignatureFactory == null) {
            this.xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
        return this.xmlSignatureFactory;
    }

    protected Reference getReference(String uri) throws GeneralSecurityException {
        return this.getReference(uri, null);
    }

    protected Reference getReference(String uri, String type) throws GeneralSecurityException {
        return this.getReference(uri, null, type, null);
    }

    protected Reference getReference(String uri, List<Transform> transforms, String type) throws GeneralSecurityException {
        return this.getReference(uri, transforms, type, null);
    }

    protected Reference getReference(String uri, List<Transform> transforms, String type, String referenceId) throws GeneralSecurityException {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        DigestMethod dm = this.getDigestMethod();
        if ((uri = uri.trim()).equals("")) {
            Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            if (transforms != null) {
                transforms.add(envelopedTransform);
            } else {
                transforms = Collections.singletonList(envelopedTransform);
            }
        } else if (!(uri.startsWith("#") || uri.startsWith("http://") || uri.startsWith("https://"))) {
            uri = "#" + uri;
        }
        return fac.newReference(uri, dm, transforms, type, referenceId);
    }

    protected List<Reference> getReferences(List<?> idList) throws GeneralSecurityException {
        ArrayList<Reference> references = new ArrayList<Reference>(idList.size());
        for (Object id : idList) {
            if (id instanceof Reference) {
                references.add((Reference)id);
                continue;
            }
            references.add(this.getReference((String)id));
        }
        return references;
    }

    protected DigestMethod getDigestMethod() throws GeneralSecurityException {
        if (this.digestMethod == null) {
            this.digestMethod = this.getXMLSignatureFactory().newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        }
        return this.digestMethod;
    }

    public void setDigestMethod(String method) throws GeneralSecurityException {
        this.digestMethod = this.getXMLSignatureFactory().newDigestMethod(method, null);
    }

    protected KeyInfo newKeyInfo(X509Certificate certificate, String keyInfoId) throws KeyException {
        KeyInfoFactory keyInfoFactory = this.getXMLSignatureFactory().getKeyInfoFactory();
        KeyValue keyValue = keyInfoFactory.newKeyValue(certificate.getPublicKey());
        ArrayList<Object> x509DataList = new ArrayList<Object>();
        if (!XmlWrappedKeyInfo.PUBLIC_KEY.equals((Object)this.getXmlWrappedKeyInfo())) {
            x509DataList.add(certificate);
        }
        X509IssuerSerial x509IssuerSerial = keyInfoFactory.newX509IssuerSerial(certificate.getIssuerDN().getName(), certificate.getSerialNumber());
        x509DataList.add(certificate.getSubjectX500Principal().getName("RFC1779"));
        x509DataList.add(x509IssuerSerial);
        X509Data x509Data = keyInfoFactory.newX509Data(x509DataList);
        ArrayList<XMLStructure> newList = new ArrayList<XMLStructure>();
        newList.add(keyValue);
        newList.add(x509Data);
        return keyInfoFactory.newKeyInfo(newList, keyInfoId);
    }

    protected XMLObject newXMLObject(List<XMLStructure> xmlObjects) {
        return this.newXMLObject(xmlObjects, this.getDefaultXMLObjectId());
    }

    protected XMLObject newXMLObject(List<XMLStructure> xmlObjects, String id) {
        return this.newXMLObject(xmlObjects, id, this.getDefaultXMLObjectMimeType());
    }

    protected XMLObject newXMLObject(List<XMLStructure> xmlObjects, String id, String mimeType) {
        return this.newXMLObject(xmlObjects, id, mimeType, this.getDefaultXMLObjectEncoding());
    }

    protected XMLObject newXMLObject(List<XMLStructure> xmlObjects, String id, String mimeType, String encoding) {
        XMLSignatureFactory fac = this.getXMLSignatureFactory();
        return fac.newXMLObject(xmlObjects, id, mimeType, encoding);
    }

    protected String getDefaultXMLObjectId() {
        return this.defaultXMLObjectId;
    }

    protected String getDefaultXMLObjectMimeType() {
        return this.defaultXMLObjectMimeType;
    }

    protected String getDefaultXMLObjectEncoding() {
        return this.defaultXMLObjectEncoding;
    }

    public XMLObject addXMLObject(XMLObject xmlObject) {
        this.xmlObjects.add(xmlObject);
        return xmlObject;
    }

    protected QualifyingProperties marshalQualifyingProperties(String xmlNamespace, String signedPropertiesTypeUrl, String signatureIdPrefix, List referencesIdList) throws GeneralSecurityException, MarshalException {
        return this.marshalQualifyingProperties(xmlNamespace, signedPropertiesTypeUrl, signatureIdPrefix, referencesIdList, null);
    }

    protected QualifyingProperties marshalQualifyingProperties(String xmlNamespace, String signedPropertiesTypeUrl, String signatureIdPrefix, List referencesIdList, List<Transform> transforms) throws GeneralSecurityException, MarshalException {
        QualifyingProperties qp = new QualifyingProperties(this.xades.getBaseDocument(), (Node)this.getBaseElement(), signatureIdPrefix, this.xades.getXadesPrefix(), xmlNamespace, this.xades.getXmlSignaturePrefix());
        this.xades.marshalQualifyingProperties(qp, signatureIdPrefix, referencesIdList);
        SignedProperties sp = qp.getSignedProperties();
        String spId = sp.getId();
        Reference spReference = this.getReference(spId, transforms, this.signedPropertiesTypeUrl);
        referencesIdList.add(spReference);
        return qp;
    }

    protected XMLObject marshalXMLSignature(String xadesNamespace, String signedPropertiesTypeUrl, String signatureIdPrefix, List referencesIdList) throws GeneralSecurityException, MarshalException {
        return this.marshalXMLSignature(xadesNamespace, signedPropertiesTypeUrl, signatureIdPrefix, referencesIdList, null);
    }

    protected XMLObject marshalXMLSignature(String xadesNamespace, String signedPropertiesTypeUrl, String signatureIdPrefix, List referencesIdList, List<Transform> SignedPropertiesTransforms) throws GeneralSecurityException, MarshalException {
        QualifyingProperties qp = this.marshalQualifyingProperties(xadesNamespace, signedPropertiesTypeUrl, signatureIdPrefix, referencesIdList, SignedPropertiesTransforms);
        List<QualifyingPropertiesReference> qpr = this.getQualifyingPropertiesReferences();
        ArrayList<XMLStructure> content = new ArrayList<XMLStructure>(qpr.size() + 1);
        content.add(qp);
        content.addAll(qpr);
        return this.newXMLObject(content);
    }

    public List<QualifyingPropertiesReference> getQualifyingPropertiesReferences() {
        if (this.qualifyingPropertiesReferences == null) {
            this.qualifyingPropertiesReferences = new ArrayList<QualifyingPropertiesReference>();
        }
        return this.qualifyingPropertiesReferences;
    }

    public void setQualifyingPropertiesReferences(List<QualifyingPropertiesReference> refs) {
        this.qualifyingPropertiesReferences = refs;
    }
}

