/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.SigningCertificate;
import es.uji.crypto.xades.jxades.util.Base64;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;

public class SigningCertificateImpl
implements SigningCertificate {
    private X509Certificate certificate;
    private String digestMethod;

    public SigningCertificateImpl(X509Certificate certificate, String digestMethod) {
        this.certificate = certificate;
        this.digestMethod = digestMethod;
    }

    @Override
    public String getDigestMethodAlgorithm() {
        return this.digestMethod;
    }

    @Override
    public String getDigestValue() throws GeneralSecurityException {
        String result;
        try {
            String algorithm = "SHA-1";
            if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(this.digestMethod)) {
                algorithm = "SHA-256";
            } else if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(this.digestMethod)) {
                algorithm = "SHA-512";
            }
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(this.certificate.getEncoded());
            result = Base64.encodeBytes(md.digest());
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
        return result;
    }

    @Override
    public String getIssuerName() {
        return this.certificate.getIssuerDN().getName();
    }

    @Override
    public BigInteger getX509SerialNumber() {
        return this.certificate.getSerialNumber();
    }
}

