/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.SignedSignatureProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SigningCertificate;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdESStructure;
import java.security.GeneralSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SigningCertificateDetails
extends XAdESStructure {
    public SigningCertificateDetails(Document document, SignedSignatureProperties ssp, SigningCertificate signingCertificate, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) throws GeneralSecurityException {
        super(document, ssp, "SigningCertificate", xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        Element cert = this.createElement("Cert");
        Element certDigest = this.createElement("CertDigest");
        Element digestMethod = this.createElementNS("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix, "DigestMethod");
        digestMethod.setPrefix(xmlSignaturePrefix);
        digestMethod.setAttributeNS(xmlSignaturePrefix, "Algorithm", signingCertificate.getDigestMethodAlgorithm());
        Element digestValue = this.createElementNS("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix, "DigestValue");
        digestValue.setPrefix(xmlSignaturePrefix);
        digestValue.setTextContent(signingCertificate.getDigestValue());
        certDigest.appendChild(digestMethod);
        certDigest.appendChild(digestValue);
        Element issuerSerial = this.createElement("IssuerSerial");
        Element x509IssuerName = this.createElementNS("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix, "X509IssuerName");
        x509IssuerName.setPrefix(xmlSignaturePrefix);
        x509IssuerName.setTextContent(signingCertificate.getIssuerName());
        Element x509SerialNumber = this.createElementNS("http://www.w3.org/2000/09/xmldsig#", xmlSignaturePrefix, "X509SerialNumber");
        x509SerialNumber.setPrefix(xmlSignaturePrefix);
        x509SerialNumber.setTextContent(signingCertificate.getX509SerialNumber() + "");
        issuerSerial.appendChild(x509IssuerName);
        issuerSerial.appendChild(x509SerialNumber);
        cert.appendChild(certDigest);
        cert.appendChild(issuerSerial);
        this.getNode().appendChild(cert);
    }

    public SigningCertificateDetails(Node node, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(node, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }
}

