/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.SignedSignatureProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.Signer;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdESStructure;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SignerDetails
extends XAdESStructure {
    public static final String USERNAME_ATTRIBUTE = "Username";

    public SignerDetails(Document document, SignedSignatureProperties ssp, Signer signer, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(document, ssp, "SignerDetails", xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        String value = signer.getPersonName();
        if (value == null) {
            throw new IllegalArgumentException("The Signer personal name can not be NULL.");
        }
        this.setTextContent(value);
        value = signer.getUserId();
        if (value != null) {
            this.setAttributeNS(null, "Id", value);
        }
        if ((value = signer.getUsername()) != null) {
            this.setAttributeNS(null, USERNAME_ATTRIBUTE, value);
        }
    }

    public SignerDetails(Node node, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(node, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }

    public Signer getSigner() {
        SignerImpl signer = new SignerImpl();
        signer.setPersonName(this.getTextContent());
        signer.setUserId(this.getAttribute("Id"));
        signer.setUsername(this.getAttribute(USERNAME_ATTRIBUTE));
        return signer;
    }
}

