/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.SignaturePolicyIdentifier;
import es.uji.crypto.xades.jxades.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignaturePolicyIdentifierImpl
implements SignaturePolicyIdentifier {
    private boolean implied;
    private String sigPolicyId;
    private String description;
    private String sigPolicyQualifierSPURI;
    private String sigPolicyHashBase64;
    private String sigPolicyHashHashAlgorithm;

    public SignaturePolicyIdentifierImpl(boolean implied) {
        this.implied = implied;
    }

    private byte[] inputStreamToByteArray(InputStream in) throws IOException {
        byte[] buffer = new byte[2048];
        int length = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((length = in.read(buffer)) >= 0) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    @Override
    public void setIdentifier(String identifier) throws IOException, NoSuchAlgorithmException {
        this.setIdentifier(identifier, null, null);
    }

    @Override
    public void setIdentifier(String identifier, String hashBase64, String hashAlgorithm) throws IOException, NoSuchAlgorithmException {
        if (hashBase64 == null || "".equals(hashBase64) || hashAlgorithm == null || "".equals(hashAlgorithm)) {
            URLConnection conn = new URL(identifier).openConnection();
            byte[] data = this.inputStreamToByteArray(conn.getInputStream());
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(data);
            this.sigPolicyHashBase64 = Base64.encodeBytes(md.digest());
            this.sigPolicyHashHashAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        } else {
            this.sigPolicyHashBase64 = hashBase64;
            this.sigPolicyHashHashAlgorithm = hashAlgorithm;
        }
        this.sigPolicyId = identifier;
    }

    @Override
    public boolean isImplied() {
        return this.implied;
    }

    @Override
    public void setImplied(boolean implied) {
        this.implied = implied;
    }

    @Override
    public String getIdentifier() {
        return this.sigPolicyId;
    }

    @Override
    public String getHashBase64() {
        return this.sigPolicyHashBase64;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getQualifier() {
        return this.sigPolicyQualifierSPURI;
    }

    @Override
    public void setQualifier(String qualifier) {
        this.sigPolicyQualifierSPURI = qualifier;
    }

    @Override
    public String getHashAlgorithm() {
        return this.sigPolicyHashHashAlgorithm;
    }
}

