/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdESStructure;
import es.uji.crypto.xades.jxades.util.Base64;
import es.uji.crypto.xades.jxades.util.SystemUtils;
import es.uji.crypto.xades.jxades.util.XMLUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OCSPIdentifier
extends XAdESStructure {
    private X500Principal responderName;
    private byte[] responderKey;
    private Date producedAt;

    public OCSPIdentifier(Node node, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(node, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }

    public X500Principal getResponderName() {
        String value;
        Element element;
        if (this.responderName == null && (element = this.getChildElementNS("ResponderID")) != null && (element = XMLUtils.getChildElementByTagName(element, "ByName")) != null && (value = element.getTextContent()) != null && (value = value.trim()).length() > 0) {
            this.responderName = new X500Principal(value);
        }
        return this.responderName;
    }

    public byte[] getResponderKey() throws IOException {
        String value;
        Element element;
        if (this.responderKey == null && (element = this.getChildElementNS("ResponderID")) != null && (element = XMLUtils.getChildElementByTagName(element, "ByKey")) != null && (value = element.getTextContent()) != null && (value = value.trim()).length() > 0) {
            this.responderKey = Base64.decode(value);
        }
        return this.responderKey;
    }

    public Date getProducedAt() throws ParseException {
        String value;
        if (this.producedAt == null && (value = this.getChildElementTextContent("ProducedAt")) != null) {
            this.producedAt = SystemUtils.parseDate(value);
        }
        return this.producedAt;
    }
}

