/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.CertDigest;
import es.uji.crypto.xades.jxades.security.xml.XAdES.IssuerSerial;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdESStructure;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Cert
extends XAdESStructure {
    private CertDigest certDigest;
    private IssuerSerial issuerSerial;

    public Cert(Document document, XAdESStructure parent, X509Certificate cert, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) throws GeneralSecurityException {
        super(document, parent, "Cert", xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        this.certDigest = new CertDigest(document, (XAdESStructure)this, cert, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
        this.issuerSerial = new IssuerSerial(document, (XAdESStructure)this, cert, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }

    public Cert(Node node, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix) {
        super(node, xadesPrefix, xadesNamespace, xmlSignaturePrefix);
    }

    public CertDigest getCertDigest() {
        Element element;
        if (this.certDigest == null && (element = this.getChildElementNS("CertDigest")) != null) {
            this.certDigest = new CertDigest(element, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
        return this.certDigest;
    }

    public IssuerSerial getIssuerSerial() {
        Element element;
        if (this.issuerSerial == null && (element = this.getChildElementNS("IssuerSerial")) != null) {
            this.issuerSerial = new IssuerSerial(element, this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
        return this.issuerSerial;
    }
}

