/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.AllDataObjectsTimeStamp;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeIndication;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CounterSignature;
import es.uji.crypto.xades.jxades.security.xml.XAdES.DataObjectFormat;
import es.uji.crypto.xades.jxades.security.xml.XAdES.IndividualDataObjectsTimeStamp;
import es.uji.crypto.xades.jxades.security.xml.XAdES.QualifyingProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignaturePolicyIdentifier;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignatureProductionPlace;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignatureTimeStamp;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignedDataObjectProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignedSignatureProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.Signer;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerRole;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SigningCertificate;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SigningCertificateImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.UnsignedSignatureProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdESTimeStamp;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_BES;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.xml.crypto.MarshalException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicXAdESImpl
implements XAdES_BES {
    protected boolean readOnlyMode = true;
    protected TreeMap<XAdES.Element, Object> data;
    private final Element baseElement;
    private Document baseDocument;
    private QualifyingProperties qualifyingProperties;
    public String xadesPrefix;
    public String xadesNamespace;
    public String xmlSignaturePrefix;
    public String digestMethod;

    public BasicXAdESImpl(Document document, Element baseElement, boolean readOnlyMode, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix, String digestMethod) {
        this.baseDocument = document;
        if (baseElement != null) {
            this.baseDocument = baseElement.getOwnerDocument();
        }
        this.baseElement = baseElement;
        this.readOnlyMode = readOnlyMode;
        this.data = new TreeMap();
        this.xadesPrefix = xadesPrefix;
        this.xadesNamespace = xadesNamespace;
        this.xmlSignaturePrefix = xmlSignaturePrefix;
        this.digestMethod = digestMethod;
    }

    @Override
    public Document getBaseDocument() {
        return this.baseDocument;
    }

    @Override
    public Element getBaseElement() {
        return this.baseElement;
    }

    @Override
    public String getDigestMethod() {
        return this.digestMethod;
    }

    @Override
    public Date getSigningTime() {
        return (Date)this.data.get(XAdES.Element.SIGNING_TIME);
    }

    @Override
    public X509Certificate getSigningCertificate() {
        return (X509Certificate)this.data.get(XAdES.Element.SIGNING_CERTIFICATE);
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        return (SignatureProductionPlace)this.data.get(XAdES.Element.SIGNATURE_PRODUCTION_PLACE);
    }

    @Override
    public SignerRole getSignerRole() {
        return (SignerRole)this.data.get(XAdES.Element.SIGNER_ROLE);
    }

    @Override
    public Signer getSigner() {
        return (Signer)this.data.get(XAdES.Element.SIGNER);
    }

    @Override
    public List<DataObjectFormat> getDataObjectFormats() {
        return (List)this.data.get(XAdES.Element.DATA_OBJECT_FORMATS);
    }

    @Override
    public List<CommitmentTypeIndication> getCommitmentTypeIndications() {
        return (List)this.data.get(XAdES.Element.COMMITMENT_TYPE_INDICATIONS);
    }

    @Override
    public List<AllDataObjectsTimeStamp> getAllDataObjectsTimeStamps() {
        return (List)this.data.get(XAdES.Element.ALL_DATA_OBJECTS_TIMESTAMPS);
    }

    @Override
    public List<XAdESTimeStamp> getIndividualDataObjectsTimeStamps() {
        return (List)this.data.get(XAdES.Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMPS);
    }

    @Override
    public List<CounterSignature> getCounterSignatures() {
        return (List)this.data.get(XAdES.Element.COUNTER_SIGNATURES);
    }

    public List<SignatureTimeStamp> getSignatureTimeStamps() {
        return (List)this.data.get(XAdES.Element.SIGNATURE_TIME_STAMP);
    }

    @Override
    public void setSigningTime(Date signingTime) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (signingTime != null) {
            this.data.put(XAdES.Element.SIGNING_TIME, signingTime);
        } else {
            this.data.remove(XAdES.Element.SIGNING_TIME);
        }
    }

    @Override
    public void setSigningCertificate(X509Certificate certificate) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        SigningCertificateImpl sci = new SigningCertificateImpl(certificate, this.digestMethod);
        if (certificate != null) {
            this.data.put(XAdES.Element.SIGNING_CERTIFICATE, sci);
        } else {
            this.data.remove(XAdES.Element.SIGNING_CERTIFICATE);
        }
    }

    @Override
    public void setSignatureProductionPlace(SignatureProductionPlace productionPlace) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (productionPlace != null) {
            this.data.put(XAdES.Element.SIGNATURE_PRODUCTION_PLACE, productionPlace);
        } else {
            this.data.remove(XAdES.Element.SIGNATURE_PRODUCTION_PLACE);
        }
    }

    @Override
    public void setSignerRole(SignerRole signerRole) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (signerRole != null) {
            this.data.put(XAdES.Element.SIGNER_ROLE, signerRole);
        } else {
            this.data.remove(XAdES.Element.SIGNER_ROLE);
        }
    }

    @Override
    public void setSigner(Signer signer) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (signer != null) {
            this.data.put(XAdES.Element.SIGNER, signer);
        } else {
            this.data.remove(XAdES.Element.SIGNER);
        }
    }

    @Override
    public void setDataObjectFormats(List<DataObjectFormat> dataObjectFormats) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (dataObjectFormats != null && dataObjectFormats.size() > 0) {
            this.data.put(XAdES.Element.DATA_OBJECT_FORMATS, dataObjectFormats);
        } else {
            this.data.remove(XAdES.Element.DATA_OBJECT_FORMATS);
        }
    }

    @Override
    public void setCommitmentTypeIndications(List<CommitmentTypeIndication> commitmentTypeIndications) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (commitmentTypeIndications != null && commitmentTypeIndications.size() > 0) {
            this.data.put(XAdES.Element.COMMITMENT_TYPE_INDICATIONS, commitmentTypeIndications);
        } else {
            this.data.remove(XAdES.Element.COMMITMENT_TYPE_INDICATIONS);
        }
    }

    @Override
    public void setAllDataObjectsTimeStamps(List<AllDataObjectsTimeStamp> allDataObjectsTimeStamps) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (allDataObjectsTimeStamps != null && allDataObjectsTimeStamps.size() > 0) {
            this.data.put(XAdES.Element.ALL_DATA_OBJECTS_TIMESTAMPS, allDataObjectsTimeStamps);
        } else {
            this.data.remove(XAdES.Element.ALL_DATA_OBJECTS_TIMESTAMPS);
        }
    }

    @Override
    public void setIndividualDataObjectsTimeStamps(List<IndividualDataObjectsTimeStamp> individualDataObjectsTimeStamps) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (individualDataObjectsTimeStamps != null && individualDataObjectsTimeStamps.size() > 0) {
            this.data.put(XAdES.Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMPS, individualDataObjectsTimeStamps);
        } else {
            this.data.remove(XAdES.Element.INDIVIDUAL_DATA_OBJECTS_TIMESTAMPS);
        }
    }

    @Override
    public void setCounterSignatures(List<CounterSignature> counterSignatures) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (counterSignatures != null && counterSignatures.size() > 0) {
            this.data.put(XAdES.Element.COUNTER_SIGNATURES, counterSignatures);
        } else {
            this.data.remove(XAdES.Element.COUNTER_SIGNATURES);
        }
    }

    public void setSignatureTimeStamps(List<SignatureTimeStamp> signatureTimeStamps) {
        if (this.readOnlyMode) {
            throw new UnsupportedOperationException("Set Method is not allowed. Read-only mode.");
        }
        if (signatureTimeStamps != null && signatureTimeStamps.size() > 0) {
            this.data.put(XAdES.Element.SIGNATURE_TIME_STAMP, signatureTimeStamps);
        } else {
            this.data.remove(XAdES.Element.SIGNATURE_TIME_STAMP);
        }
    }

    protected XAdES getXAdESType() {
        return XAdES.BES;
    }

    protected QualifyingProperties getQualifyingProperties() {
        NodeList nl;
        if (this.qualifyingProperties == null && (nl = this.baseElement.getElementsByTagNameNS(this.xadesNamespace, XAdES.Element.QUALIFYING_PROPERTIES.getElementName())) != null && nl.getLength() > 0) {
            this.qualifyingProperties = new QualifyingProperties(nl.item(0), this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
        }
        return this.qualifyingProperties;
    }

    protected SignedSignatureProperties getSignedSignatureProperties(QualifyingProperties qp) {
        return qp.getSignedProperties().getSignedSignatureProperties();
    }

    protected SignedDataObjectProperties getSignedDataObjectProperties(QualifyingProperties qp) {
        return qp.getSignedProperties().getSignedDataObjectProperties();
    }

    protected UnsignedSignatureProperties getUnsignedSignatureProperties(QualifyingProperties qp) {
        return qp.getUnsignedProperties().getUnsignedSignatureProperties();
    }

    protected void marshalQualifyingProperties(QualifyingProperties qp, String signatureIdPrefix, List referencesIdList) throws MarshalException {
        try {
            for (XAdES.Element key : XAdES.Element.values()) {
                SignedDataObjectProperties sdop;
                SignedSignatureProperties ssp;
                if (XAdES.Element.SIGNING_TIME.equals(key)) {
                    ssp = this.getSignedSignatureProperties(qp);
                    ssp.setSigningTime();
                    continue;
                }
                Object value = this.data.get(key);
                if (value == null) continue;
                if (XAdES.Element.SIGNER.equals(key)) {
                    ssp = this.getSignedSignatureProperties(qp);
                    ssp.setSigner((Signer)value);
                    continue;
                }
                if (XAdES.Element.SIGNING_CERTIFICATE.equals(key)) {
                    ssp = this.getSignedSignatureProperties(qp);
                    ssp.setSigningCertificate((SigningCertificate)value);
                    continue;
                }
                if (XAdES.Element.SIGNATURE_POLICY_IDENTIFIER.equals(key)) {
                    ssp = this.getSignedSignatureProperties(qp);
                    ssp.setSignaturePolicyIdentifier((SignaturePolicyIdentifier)value);
                    continue;
                }
                if (XAdES.Element.SIGNATURE_PRODUCTION_PLACE.equals(key)) {
                    ssp = this.getSignedSignatureProperties(qp);
                    ssp.setSignatureProductionPlace((SignatureProductionPlace)value);
                    continue;
                }
                if (XAdES.Element.SIGNER_ROLE.equals(key)) {
                    ssp = this.getSignedSignatureProperties(qp);
                    ssp.setSignerRole((SignerRole)value);
                    continue;
                }
                if (XAdES.Element.DATA_OBJECT_FORMATS.equals(key)) {
                    sdop = this.getSignedDataObjectProperties(qp);
                    sdop.setDataObjectFormat((ArrayList)value);
                    continue;
                }
                if (XAdES.Element.COMMITMENT_TYPE_INDICATIONS.equals(key)) {
                    sdop = this.getSignedDataObjectProperties(qp);
                    sdop.setCommitmentTypeIndications((ArrayList)value);
                    continue;
                }
                if (!XAdES.Element.COMPLETE_CERTIFICATE_REFS.equals(key)) continue;
                UnsignedSignatureProperties usp = this.getUnsignedSignatureProperties(qp);
                usp.setCompleteCertificateRefs((Collection)value, signatureIdPrefix);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new MarshalException(ex);
        }
    }

    @Override
    public String getXadesPrefix() {
        return this.xadesPrefix;
    }

    @Override
    public String getXmlSignaturePrefix() {
        return this.xmlSignaturePrefix;
    }

    @Override
    public String getXadesNamespace() {
        return this.xadesNamespace;
    }
}

