/*
 * Decompiled with CFR 0.152.
 */
package es.uji.crypto.xades.jxades.security.xml.XAdES;

import es.uji.crypto.xades.jxades.security.xml.XAdES.CompleteCertificateRefsImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CompleteRevocationRefsImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.ExtendedLongXAdESImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.QualifyingProperties;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerDetails;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SigningTime;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES;
import java.util.Date;
import javax.xml.crypto.MarshalException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ArchivalXAdESImpl
extends ExtendedLongXAdESImpl {
    public ArchivalXAdESImpl(Document document, Element baseElement, boolean readOnlyMode, String xadesPrefix, String xadesNamespace, String xmlSignaturePrefix, String digestMethod) {
        super(document, baseElement, readOnlyMode, xadesPrefix, xadesNamespace, xmlSignaturePrefix, digestMethod);
    }

    protected void unmarshal() throws MarshalException {
        QualifyingProperties qp = this.getQualifyingProperties();
        if (qp != null) {
            try {
                Element qpElement = qp.getElement();
                for (XAdES.Element key : XAdES.Element.values()) {
                    int size;
                    NodeList nl = qpElement.getElementsByTagNameNS(this.xadesNamespace, key.getElementName());
                    if (nl == null || (size = nl.getLength()) <= 0) continue;
                    if (XAdES.Element.SIGNING_TIME.equals(key)) {
                        SigningTime signingTime = new SigningTime(nl.item(0), this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
                        Date date = signingTime.getSigningTime();
                        if (date == null) continue;
                        this.data.put(XAdES.Element.SIGNING_TIME, date);
                        continue;
                    }
                    if (XAdES.Element.SIGNER_DETAILS.equals(key)) {
                        SignerDetails signerDetails = new SignerDetails(nl.item(0), this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
                        this.data.put(XAdES.Element.SIGNER, signerDetails.getSigner());
                        continue;
                    }
                    if (XAdES.Element.COMPLETE_CERTIFICATE_REFS.equals(key)) {
                        CompleteCertificateRefsImpl completeCertificateRefs = new CompleteCertificateRefsImpl(nl.item(0), this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
                        this.data.put(XAdES.Element.COMPLETE_CERTIFICATE_REFS, completeCertificateRefs);
                        continue;
                    }
                    if (!XAdES.Element.COMPLETE_REVOCATION_REFS.equals(key)) continue;
                    CompleteRevocationRefsImpl completeRevocationRefs = new CompleteRevocationRefsImpl(nl.item(0), this.xadesPrefix, this.xadesNamespace, this.xmlSignaturePrefix);
                    this.data.put(XAdES.Element.COMPLETE_REVOCATION_REFS, completeRevocationRefs);
                }
            }
            catch (Exception ex) {
                throw new MarshalException(ex);
            }
        }
    }
}

