/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.gui.AccesiblityConstants;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.IconLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.JAccessibilityCustomDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

final class ResizingAdaptor
extends ComponentAdapter {
    private final JAccessibilityCustomDialog theCustomDialog;

    ResizingAdaptor(JAccessibilityCustomDialog customDialog) {
        this.theCustomDialog = customDialog;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.theCustomDialog != null) {
            this.adjustFontSize(this.theCustomDialog.getComponents());
        }
    }

    private void adjustFontSize(Component[] components) {
        float relation = 1.0f;
        if (this.theCustomDialog != null) {
            double relHeight;
            double relWidth;
            if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold() || this.theCustomDialog.isBigSizeDefault()) {
                relWidth = this.theCustomDialog.getSize().getWidth() / (double)this.theCustomDialog.getInitialWidth();
                relHeight = this.theCustomDialog.getSize().getHeight() / (double)this.theCustomDialog.getInitialHeight();
            } else {
                relWidth = this.theCustomDialog.getSize().getWidth() / (double)this.theCustomDialog.getInitialWidth();
                relHeight = this.theCustomDialog.getSize().getHeight() / (double)this.theCustomDialog.getInitialHeight();
            }
            relation = Math.round(relWidth * relHeight * (double)this.theCustomDialog.getMinimumRelation());
        }
        for (Component component : components) {
            String name;
            Border componentBorder;
            Component actualComponent = component;
            if (ResizingAdaptor.isResizable(actualComponent)) {
                if (relation > 10.0f) {
                    float resizeFactor = 0.0f;
                    resizeFactor = this.theCustomDialog != null ? (float)Math.round(relation / ResizingAdaptor.getResizingFactorCustomDialog()) : (float)Math.round(relation / ResizingAdaptor.getResizingFactorFileChooser());
                    actualComponent.setFont(actualComponent.getFont().deriveFont(ResizingAdaptor.getFontSize() + resizeFactor));
                } else {
                    if (actualComponent instanceof JComboBox) {
                        actualComponent.setPreferredSize(new Dimension(100, 25));
                    }
                    actualComponent.setFont(actualComponent.getFont().deriveFont(ResizingAdaptor.getFontSize()));
                }
            }
            if (actualComponent instanceof JPanel && (componentBorder = ((JPanel)actualComponent).getBorder()) instanceof TitledBorder && ((name = actualComponent.getName()) == null || !name.equalsIgnoreCase("AccessibilityButtonsPanel"))) {
                TitledBorder b = (TitledBorder)componentBorder;
                float resizeFactor = Math.round(relation / ResizingAdaptor.getResizingFactorFrame());
                if (b.getTitleFont() != null) {
                    b.setTitleFont(b.getTitleFont().deriveFont(ResizingAdaptor.getFontSize() - 2.0f + resizeFactor));
                } else {
                    b.setTitleFont(actualComponent.getFont().deriveFont(ResizingAdaptor.getFontSize() - 2.0f + resizeFactor));
                }
            }
            if (actualComponent instanceof Container && !(actualComponent instanceof JComboBox)) {
                Container actualContainer = (Container)actualComponent;
                this.adjustFontSize(actualContainer.getComponents());
            }
            if (actualComponent instanceof IconLabel) {
                int multiplicando = 4;
                IconLabel iconLabel = (IconLabel)actualComponent;
                if (iconLabel.getOriginalIcon() != null) {
                    float resizeFactor = this.getImageResizeFactor(0.0015);
                    int w = iconLabel.getOriginalDimension().width;
                    int h = iconLabel.getOriginalDimension().height;
                    ResizingAdaptor.resizeImage(resizeFactor, actualComponent, w, h, 4);
                }
            }
            if (!(actualComponent instanceof JButton) || ((JButton)actualComponent).getIcon() == null) continue;
            float resizeFactor = 0.0f;
            resizeFactor = this.theCustomDialog != null ? this.getImageResizeFactor(0.0025) : this.getImageResizeFactor(0.0015);
            ResizingAdaptor.resizeImageButton(resizeFactor, actualComponent);
        }
    }

    private float getImageResizeFactor(double factor) {
        float resizeFactor = 0.0f;
        if (this.theCustomDialog != null) {
            resizeFactor = (float)((double)this.theCustomDialog.getHeight() * factor);
        }
        return resizeFactor;
    }

    private static Image iconToImage(Icon icon) {
        return ResizingAdaptor.iconToImage(icon, new Dimension(icon.getIconWidth(), icon.getIconWidth()));
    }

    private static Image iconToImage(Icon icon, Dimension d) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = d.width;
        int h = d.height;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    private static void resizeImage(double factor, Component c, int w, int h, int multiplicando) {
        Image image = null;
        if (c instanceof IconLabel) {
            IconLabel iconLabel = (IconLabel)c;
            image = ResizingAdaptor.iconToImage(iconLabel.getOriginalIcon(), iconLabel.getOriginalDimension());
        } else {
            image = ResizingAdaptor.iconToImage(((JLabel)c).getIcon());
        }
        ImageIcon newImage = new ImageIcon(image.getScaledInstance((int)Math.round((double)(w * multiplicando) * factor), (int)Math.round((double)(h * multiplicando) * factor), 4));
        ((JLabel)c).setIcon(newImage);
    }

    private static final void resizeImageButton(double factor, Component c) {
        JButton button = (JButton)c;
        ImageIcon imageIcon = null;
        double factorAux = factor;
        imageIcon = button.getName() != null && button.getName().equalsIgnoreCase("maximizar") ? AccesiblityConstants.IMAGEICON_MAXIMIZE : (button.getName() != null && button.getName().equalsIgnoreCase("restaurar") ? AccesiblityConstants.IMAGEICONRESTORE : new ImageIcon(ResizingAdaptor.iconToImage(button.getIcon())));
        int lado = (int)Math.round(50.0 * factorAux);
        lado = lado < 25 ? 25 : lado;
        ImageIcon newImage = new ImageIcon(imageIcon.getImage().getScaledInstance(lado, lado, 4));
        button.setIcon(newImage);
        button.setPreferredSize(new Dimension(lado, lado));
    }

    private static float getFontSize() {
        if (GeneralConfig.isBigFontSize()) {
            return 16.0f;
        }
        return 14.0f;
    }

    private static boolean isResizable(Component a) {
        boolean resizable = false;
        resizable = resizable || a instanceof JButton || a instanceof JLabel;
        resizable = resizable || a instanceof JTextField;
        resizable = resizable || a instanceof JPanel;
        return resizable || a instanceof JCheckBox;
    }

    private static float getResizingFactorFrame() {
        return 3.0f;
    }

    private static float getResizingFactorFileChooser() {
        return 3.0f;
    }

    private static float getResizingFactorCustomDialog() {
        return 2.0f;
    }
}

