/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.callback.CustomAuthorizeCallback;
import es.gob.jmulticard.ui.passwordcallback.DialogBuilder;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback;
import es.gob.jmulticard.ui.passwordcallback.gui.UIPasswordCallbackCan;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class DnieCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback cb : callbacks) {
                PasswordCallback uip;
                if (cb == null) continue;
                if ("es.gob.jmulticard.callback.CustomTextInputCallback".equals(cb.getClass().getName()) || "javax.security.auth.callback.TextInputCallback".equals(cb.getClass().getName())) {
                    uip = new UIPasswordCallbackCan(Messages.getString("CanPasswordCallback.0"), null, Messages.getString("CanPasswordCallback.0"), Messages.getString("CanPasswordCallback.2"));
                    try {
                        Method m = cb.getClass().getMethod("setText", String.class);
                        m.invoke((Object)cb, new String(((UIPasswordCallbackCan)uip).getPassword()));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new UnsupportedCallbackException(cb, "No se ha podido invocar al metodo 'setText' de la callback: " + e);
                    }
                }
                if (cb instanceof CustomAuthorizeCallback) {
                    DialogBuilder.showSignatureConfirmDialog((CustomAuthorizeCallback)cb);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    uip = new CommonPasswordCallback(((PasswordCallback)cb).getPrompt(), Messages.getString("CommonPasswordCallback.1"), true);
                    ((PasswordCallback)cb).setPassword(((CommonPasswordCallback)uip).getPassword());
                    continue;
                }
                throw new UnsupportedCallbackException(cb);
            }
        } else {
            LOGGER.warning("Se ha recibido un array de Callbacks nulo");
        }
    }
}

