/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback;

import es.gob.jmulticard.callback.CustomAuthorizeCallback;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.NoConsoleException;
import es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager;
import es.gob.jmulticard.ui.passwordcallback.gui.ConfirmSmartcardDialog;
import java.awt.HeadlessException;
import java.io.Console;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.logging.Logger;

public final class DialogBuilder {
    private static boolean headless = false;

    public static void setHeadLess(boolean hl) {
        headless = hl;
    }

    private DialogBuilder() {
    }

    public static void showSignatureConfirmDialog(CustomAuthorizeCallback callBack) {
        if (!headless) {
            try {
                int i = ConfirmSmartcardDialog.showConfirmDialog(PasswordCallbackManager.getDialogOwner(), true, Messages.getString("CustomDialog.confirmDialog.prompt"), Messages.getString("CustomDialog.confirmDialog.title"), 0, "/images/dnie.png");
                callBack.setAuthorized(i == 0);
            }
            catch (HeadlessException e) {
                Logger.getLogger("es.gob.jmulticard").info("No hay entorno grafico, se revierte a consola: " + e);
                Console console = System.console();
                if (console == null) {
                    throw new NoConsoleException("No hay consola para solicitar el PIN");
                }
                callBack.setAuthorized(DialogBuilder.getConsoleConfirm(console, callBack) == 0);
            }
        }
    }

    private static int getConsoleConfirm(Console console, CustomAuthorizeCallback callBack) {
        console.printf(Messages.getString("CustomDialog.confirmDialog.prompt"), new Object[0]);
        String confirm = console.readLine().replace("\n", "").replace("\r", "").trim().toLowerCase(Locale.getDefault());
        if ("si".equals(confirm) || "s".equals(confirm) || "s\u00ed".equals(confirm)) {
            return 0;
        }
        if ("no".equals(confirm) || "n".equals(confirm)) {
            return 1;
        }
        return DialogBuilder.getConsoleConfirm(console, callBack);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DialogBuilder.setHeadLess(Boolean.getBoolean("java.awt.headless"));
                return null;
            }
        });
    }
}

