/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.smartcardio;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.ApduConnectionOpenedInExclusiveModeException;
import es.gob.jmulticard.apdu.connection.ApduConnectionProtocol;
import es.gob.jmulticard.apdu.connection.CardConnectionListener;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.LostChannelException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.apdu.iso7816four.GetResponseApduCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.TerminalFactory;

public final class SmartcardIoConnection
implements ApduConnection {
    private static final boolean DEBUG = false;
    private static final String SCARD_W_RESET_CARD = "SCARD_W_RESET_CARD";
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private int terminalNumber = -1;
    private CardChannel canal = null;
    private Card card = null;
    private boolean exclusive = false;
    private ApduConnectionProtocol protocol = ApduConnectionProtocol.ANY;
    private static final byte TAG_RESPONSE_PENDING = 97;
    private static final byte TAG_RESPONSE_INVALID_LENGTH = 108;

    @Override
    public void addCardConnectionListener(CardConnectionListener ccl) {
        throw new UnsupportedOperationException("JSR-268 no soporta eventos de insercion o extraccion");
    }

    @Override
    public void close() throws ApduConnectionException {
        if (this.card != null) {
            try {
                this.card.disconnect(false);
            }
            catch (Exception e) {
                throw new ApduConnectionException("Error intentando cerrar el objeto de tarjeta inteligente, la conexion puede quedar abierta pero inutil: " + e, e);
            }
            this.card = null;
        }
        this.canal = null;
    }

    @Override
    public String getTerminalInfo(int terminal) throws ApduConnectionException {
        try {
            CardTerminal cardTerminal;
            List<CardTerminal> terminales = TerminalFactory.getDefault().terminals().list();
            if (terminal < terminales.size() && (cardTerminal = terminales.get(terminal)) != null) {
                return cardTerminal.getName();
            }
            return null;
        }
        catch (Exception ex) {
            throw new ApduConnectionException("Error recuperando la lista de lectores de tarjetas del sistema: " + ex, ex);
        }
    }

    @Override
    public long[] getTerminals(boolean onlyWithCardPresent) throws ApduConnectionException {
        List<CardTerminal> terminales;
        try {
            terminales = TerminalFactory.getDefault().terminals().list();
        }
        catch (CardException e) {
            LOGGER.warning("No se ha podido recuperar la lista de lectores del sistema: " + e);
            return new long[0];
        }
        try {
            ArrayList<Long> idsTerminales = new ArrayList<Long>(terminales.size());
            for (int idx = 0; idx < terminales.size(); ++idx) {
                if (onlyWithCardPresent) {
                    if (!terminales.get(idx).isCardPresent()) continue;
                    idsTerminales.add(Long.valueOf(idx));
                    continue;
                }
                idsTerminales.add(Long.valueOf(idx));
            }
            long[] ids = new long[idsTerminales.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (Long)idsTerminales.get(i);
            }
            return ids;
        }
        catch (Exception ex) {
            throw new ApduConnectionException("Error recuperando la lista de lectores de tarjetas del sistema: " + ex, ex);
        }
    }

    @Override
    public boolean isOpen() {
        return this.card != null;
    }

    @Override
    public void open() throws ApduConnectionException {
        List<CardTerminal> terminales;
        System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
        System.setProperty("sun.security.smartcardio.t1GetResponse", "false");
        if (this.isExclusiveUse() && this.isOpen()) {
            throw new ApduConnectionOpenedInExclusiveModeException();
        }
        try {
            terminales = TerminalFactory.getDefault().terminals().list();
        }
        catch (Exception e) {
            throw new NoReadersFoundException("No se han podido listar los lectores del sistema: " + e, e);
        }
        try {
            if (terminales.size() < 1) {
                throw new NoReadersFoundException();
            }
            if (this.terminalNumber == -1) {
                long[] cadsWithCard = this.getTerminals(true);
                if (cadsWithCard.length > 0) {
                    this.terminalNumber = (int)cadsWithCard[0];
                } else {
                    throw new ApduConnectionException("En el sistema no hay ningun terminal con tarjeta insertada");
                }
            }
            if (terminales.size() <= this.terminalNumber) {
                throw new ApduConnectionException("No se detecto el lector de tarjetas numero " + Integer.toString(this.terminalNumber));
            }
            this.card = terminales.get(this.terminalNumber).connect(this.protocol.toString());
        }
        catch (javax.smartcardio.CardNotPresentException e) {
            throw new CardNotPresentException(e);
        }
        catch (CardException e) {
            throw new ApduConnectionException("No se ha podido abrir la conexion con el lector de tarjetas numero " + Integer.toString(this.terminalNumber) + ": " + e, e);
        }
        if (this.exclusive) {
            try {
                this.card.beginExclusive();
            }
            catch (CardException e) {
                throw new ApduConnectionException("No se ha podido abrir la conexion exclusiva con el lector de tarjetas numero " + Integer.toString(this.terminalNumber) + ": " + e, e);
            }
        }
        this.canal = this.card.getBasicChannel();
    }

    @Override
    public void removeCardConnectionListener(CardConnectionListener ccl) {
        throw new UnsupportedOperationException("JSR-268 no soporta eventos de insercion o extraccion");
    }

    @Override
    public byte[] reset() throws ApduConnectionException {
        if (this.card != null) {
            try {
                this.card.disconnect(true);
            }
            catch (CardException e) {
                LOGGER.warning("Error reiniciando la tarjeta: " + e);
            }
        }
        this.card = null;
        this.open();
        if (this.card != null) {
            return this.card.getATR().getBytes();
        }
        throw new ApduConnectionException("Error indefinido reiniciando la conexion con la tarjeta");
    }

    public void setExclusiveUse(boolean ex) {
        if (this.card == null) {
            this.exclusive = ex;
        } else {
            LOGGER.warning("No se puede cambiar el modo de acceso a la tarjeta con la conexion abierta, se mantendra el modo EXCLUSIVE=" + Boolean.toString(this.exclusive));
        }
    }

    @Override
    public void setProtocol(ApduConnectionProtocol p) {
        if (p == null) {
            LOGGER.warning("El protocolo de conexion no puede ser nulo, se usara T=0");
            this.protocol = ApduConnectionProtocol.T0;
            return;
        }
        this.protocol = p;
    }

    @Override
    public void setTerminal(int terminalN) {
        if (this.terminalNumber == terminalN) {
            return;
        }
        boolean wasOpened = this.isOpen();
        if (wasOpened) {
            try {
                this.close();
            }
            catch (Exception e) {
                LOGGER.warning("Error intentando cerrar la conexion con el lector: " + e);
            }
        }
        this.terminalNumber = terminalN;
        if (wasOpened) {
            try {
                this.open();
            }
            catch (Exception e) {
                LOGGER.warning("Error intentando abrir la conexion con el lector: " + e);
            }
        }
    }

    @Override
    public ResponseApdu transmit(CommandApdu command) throws ApduConnectionException {
        if (this.canal == null) {
            throw new ApduConnectionException("No se puede transmitir sobre una conexion cerrada");
        }
        if (command == null) {
            throw new IllegalArgumentException("No se puede transmitir una APDU nula");
        }
        try {
            byte[] sendApdu;
            if (command.getData() != null) {
                if (command.getData().length > 255) {
                    byte[] apduChunk;
                    int sentLength = 0;
                    int totalLength = command.getBytes().length;
                    int CONTENT_SIZE_ENVELOPE = 250;
                    while (totalLength - sentLength > 250) {
                        apduChunk = Arrays.copyOfRange(command.getBytes(), sentLength, sentLength + 250);
                        CommandAPDU apdu = new CommandAPDU(-112, -62, 0, 0, apduChunk);
                        ResponseApdu response = new ResponseApdu(this.canal.transmit(apdu).getBytes());
                        if (!response.isOk()) {
                            return response;
                        }
                        sentLength += 250;
                    }
                    apduChunk = Arrays.copyOfRange(command.getBytes(), sentLength, totalLength);
                    sendApdu = new CommandAPDU(-112, -62, 0, 0, apduChunk).getBytes();
                } else {
                    sendApdu = command.getBytes();
                }
            } else {
                sendApdu = command.getBytes();
            }
            ResponseApdu response = new ResponseApdu(this.canal.transmit(new CommandAPDU(sendApdu)).getBytes());
            if (response.getStatusWord().getMsb() == 97) {
                if (response.getData().length > 0) {
                    byte[] data = response.getData();
                    byte[] additionalData = this.transmit(new GetResponseApduCommand(0, response.getStatusWord().getLsb())).getBytes();
                    byte[] fullResponse = new byte[data.length + additionalData.length];
                    System.arraycopy(data, 0, fullResponse, 0, data.length);
                    System.arraycopy(additionalData, 0, fullResponse, data.length, additionalData.length);
                    return new ResponseApdu(fullResponse);
                }
                return this.transmit(new GetResponseApduCommand(0, response.getStatusWord().getLsb()));
            }
            if (response.getStatusWord().getMsb() == 108 && command.getCla() == 0) {
                command.setLe(response.getStatusWord().getLsb());
                return this.transmit(command);
            }
            return response;
        }
        catch (CardException e) {
            Throwable t = e.getCause();
            if (t != null && SCARD_W_RESET_CARD.equals(t.getMessage())) {
                throw new LostChannelException(t.getMessage());
            }
            throw new ApduConnectionException("Error de comunicacion con la tarjeta tratando de transmitir la APDU " + HexUtils.hexify(command.getBytes(), true) + " al lector " + Integer.toString(this.terminalNumber) + " en modo EXCLUSIVE=" + Boolean.toString(this.exclusive) + " con el protocolo " + this.protocol.toString(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApduConnectionException("Error tratando de transmitir la APDU " + HexUtils.hexify(command.getBytes(), true) + " al lector " + Integer.toString(this.terminalNumber) + " en modo EXCLUSIVE=" + Boolean.toString(this.exclusive) + " con el protocolo " + this.protocol.toString(), e);
        }
    }

    public ApduConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isExclusiveUse() {
        return this.exclusive;
    }
}

