/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.gide;

import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.gide.smartcafe.SmartCafePkcs15Applet;
import es.gob.jmulticard.card.gide.smartcafe.SmartCafePrivateKeyReference;
import es.gob.jmulticard.jse.provider.SignatureAuthException;
import es.gob.jmulticard.jse.provider.gide.SmartCafePrivateKey;
import es.gob.jmulticard.jse.provider.gide.SmartCafeProvider;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class SmartCafeSignatureImpl
extends SignatureSpi {
    private final ByteArrayOutputStream data = new ByteArrayOutputStream();
    private Signature signatureVerifier = null;
    private SmartCafePrivateKey privateKey = null;
    private final String signatureAlgo;

    SmartCafeSignatureImpl(String signatureAlgorithm) {
        this.signatureAlgo = signatureAlgorithm;
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new InvalidParameterException("Parametro no soportado");
    }

    @Override
    protected void engineInitSign(PrivateKey prKey) throws InvalidKeyException {
        if (prKey == null) {
            throw new InvalidKeyException("La clave proporcionada es nula");
        }
        if (!(prKey instanceof SmartCafePrivateKey)) {
            throw new InvalidKeyException("La clave proporcionada no es de G&D Smartcafe PKCS#15: " + prKey.getClass().getName());
        }
        this.privateKey = (SmartCafePrivateKey)prKey;
        this.data.reset();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.data.reset();
        try {
            this.signatureVerifier = Signature.getInstance(this.signatureAlgo);
            try {
                if (this.signatureVerifier.getProvider() instanceof SmartCafeProvider) {
                    this.signatureVerifier = Signature.getInstance(this.signatureAlgo, "SunRsaSign");
                }
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("No esta instalado el proveedor SunRsaSign", e);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No existe un proveedor para validar firmas con el algoritmo " + this.signatureAlgo, e);
        }
        this.signatureVerifier.initVerify(publicKey);
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new InvalidParameterException("Parametro no soportado");
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (!(this.privateKey.getCryptoCard() instanceof SmartCafePkcs15Applet)) {
            throw new ProviderException("La clave proporcionada no es de G&D Smartcafe PKCS#15: " + this.privateKey.getCryptoCard().getClass().getName());
        }
        SmartCafePrivateKeyReference prkRef = new SmartCafePrivateKeyReference(this.privateKey.getId());
        try {
            return this.privateKey.getCryptoCard().sign(this.data.toByteArray(), this.signatureAlgo, prkRef);
        }
        catch (CryptoCardException e) {
            throw new SignatureException(e);
        }
        catch (PinException e) {
            throw new SignatureAuthException(e);
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        this.data.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.data.write(b, off, len);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.signatureVerifier == null) {
            throw new SignatureException("La verificacion no esta inicializada");
        }
        this.signatureVerifier.update(this.data.toByteArray());
        this.data.reset();
        return this.signatureVerifier.verify(sigBytes);
    }

    public static final class Sha512
    extends SmartCafeSignatureImpl {
        public Sha512() {
            super("SHA512withRSA");
        }
    }

    public static final class Sha384
    extends SmartCafeSignatureImpl {
        public Sha384() {
            super("SHA384withRSA");
        }
    }

    public static final class Sha256
    extends SmartCafeSignatureImpl {
        public Sha256() {
            super("SHA256withRSA");
        }
    }

    public static final class Sha1
    extends SmartCafeSignatureImpl {
        public Sha1() {
            super("SHA1withRSA");
        }
    }
}

