/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.gide;

import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.card.gide.smartcafe.SmartCafePkcs15Applet;
import es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection;
import java.security.Provider;
import java.security.ProviderException;

public final class SmartCafeProvider
extends Provider {
    private static final String SHA512WITH_RSA = "SHA512withRSA";
    private static final String SHA384WITH_RSA = "SHA384withRSA";
    private static final String SHA256WITH_RSA = "SHA256withRSA";
    private static final String SHA1WITH_RSA = "SHA1withRSA";
    private static final String SMARTCAFE_PRIVATE_KEY = "es.gob.jmulticard.jse.provider.gide.SmartCafePrivateKey";
    private static final long serialVersionUID = -1046745919235177156L;
    private static final String INFO = "Proveedor para tarjeta G&D SmartCafe con Applet PKCS#15";
    private static final double VERSION = 0.1;
    private static final String NAME = "SmartCafePkcs15JCAProvider";
    private static ApduConnection defaultConnection = null;

    static ApduConnection getDefaultApduConnection() {
        return defaultConnection;
    }

    public SmartCafeProvider() {
        this((ApduConnection)null);
    }

    public SmartCafeProvider(ApduConnection conn) {
        super(NAME, 0.1, INFO);
        try {
            defaultConnection = conn == null ? new SmartcardIoConnection() : conn;
        }
        catch (Exception e) {
            throw new ProviderException("No se ha proporcionado una conexion con un lector y no ha podido instanciarse la por defecto: " + e, e);
        }
        try {
            SmartCafePkcs15Applet.connect(defaultConnection);
            defaultConnection.close();
        }
        catch (Exception e) {
            throw new ProviderException("No se ha podido inicializar el proveedor: " + e, e);
        }
        this.put("KeyStore.GDSCPKCS15", "es.gob.jmulticard.jse.provider.gide.SmartCafeKeyStoreImpl");
        this.put("Signature.SHA1withRSA", "es.gob.jmulticard.jse.provider.gide.SmartCafeSignatureImpl$Sha1");
        this.put("Signature.SHA256withRSA", "es.gob.jmulticard.jse.provider.gide.SmartCafeSignatureImpl$Sha256");
        this.put("Signature.SHA384withRSA", "es.gob.jmulticard.jse.provider.gide.SmartCafeSignatureImpl$Sha384");
        this.put("Signature.SHA512withRSA", "es.gob.jmulticard.jse.provider.gide.SmartCafeSignatureImpl$Sha512");
        this.put("Signature.SHA1withRSA SupportedKeyClasses", SMARTCAFE_PRIVATE_KEY);
        this.put("Signature.SHA256withRSA SupportedKeyClasses", SMARTCAFE_PRIVATE_KEY);
        this.put("Signature.SHA384withRSA SupportedKeyClasses", SMARTCAFE_PRIVATE_KEY);
        this.put("Signature.SHA512withRSA SupportedKeyClasses", SMARTCAFE_PRIVATE_KEY);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.1.3.14.3.2.29", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHAwithRSA", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-1withRSA", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA1withRSAEncryption", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-1withRSAEncryption", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-256withRSA", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-256withRSAEncryption", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA256withRSAEncryption", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-384withRSA", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-384withRSAEncryption", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA384withRSAEncryption", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-512withRSA", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-512withRSAEncryption", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA512withRSAEncryption", SHA512WITH_RSA);
    }
}

