/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.gide;

import es.gob.jmulticard.JseCryptoHelper;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.gide.smartcafe.SmartCafePkcs15Applet;
import es.gob.jmulticard.card.gide.smartcafe.SmartCafePrivateKeyReference;
import es.gob.jmulticard.jse.provider.gide.SmartCafePrivateKey;
import es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public final class SmartCafeKeyStoreImpl
extends KeyStoreSpi {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private SmartCafePkcs15Applet cryptoCard = null;
    private List<String> aliases = null;

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.aliases.contains(alias);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        return this.cryptoCard.getCertificate(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        BigInteger serial = ((X509Certificate)cert).getSerialNumber();
        for (String alias : this.aliases) {
            if (((X509Certificate)this.engineGetCertificate(alias)).getSerialNumber() != serial) continue;
            return alias;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOGGER.warning("El proveedor no soporta la formacion de cadenas de certificados, se devolvera solo el certificado final");
        return new Certificate[]{this.engineGetCertificate(alias)};
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        PrivateKeyReference pkRef;
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (password != null) {
            CachePasswordCallback pwc = new CachePasswordCallback(password);
            this.cryptoCard.setPasswordCallback(pwc);
        }
        if (!((pkRef = this.cryptoCard.getPrivateKey(alias)) instanceof SmartCafePrivateKeyReference)) {
            throw new ProviderException("La clave obtenida de la tarjeta no es del tipo '" + SmartCafePrivateKeyReference.class.getName() + "', se ha obtenido: " + (pkRef != null ? pkRef.getClass().getName() : "null"));
        }
        return new SmartCafePrivateKey((SmartCafePrivateKeyReference)pkRef, this.cryptoCard);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) {
        if (protParam instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler chp = ((KeyStore.CallbackHandlerProtection)protParam).getCallbackHandler();
            if (chp != null) {
                this.cryptoCard.setCallbackHandler(chp);
            }
        } else if (protParam instanceof KeyStore.PasswordProtection) {
            CachePasswordCallback pwc = new CachePasswordCallback(((KeyStore.PasswordProtection)protParam).getPassword());
            this.cryptoCard.setPasswordCallback(pwc);
        } else {
            LOGGER.warning("Se ha proporcionado un ProtectionParameter de tipo no soportado, se ignorara: " + (protParam != null ? protParam.getClass().getName() : "NULO"));
        }
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        PrivateKey key = (PrivateKey)this.engineGetKey(alias, null);
        return new KeyStore.PrivateKeyEntry(key, this.engineGetCertificateChain(alias));
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.aliases.contains(alias);
    }

    @Override
    public int engineSize() {
        return this.aliases.size();
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (!this.engineContainsAlias(alias)) {
            return false;
        }
        return entryClass.equals(KeyStore.PrivateKeyEntry.class);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        SmartcardIoConnection conn = new SmartcardIoConnection();
        this.cryptoCard = new SmartCafePkcs15Applet(conn, new JseCryptoHelper());
        if (password != null) {
            this.cryptoCard.setPasswordCallback(new CachePasswordCallback(password));
        }
        this.aliases = Arrays.asList(this.cryptoCard.getAliases());
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException {
        SmartcardIoConnection conn = new SmartcardIoConnection();
        this.cryptoCard = new SmartCafePkcs15Applet(conn, new JseCryptoHelper());
        if (param != null) {
            KeyStore.ProtectionParameter pp = param.getProtectionParameter();
            if (pp instanceof KeyStore.CallbackHandlerProtection) {
                if (((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler() == null) {
                    throw new IllegalArgumentException("El CallbackHandler no puede ser nulo");
                }
                this.cryptoCard.setCallbackHandler(((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler());
            } else if (pp instanceof KeyStore.PasswordProtection) {
                CachePasswordCallback pwc = new CachePasswordCallback(((KeyStore.PasswordProtection)pp).getPassword());
                this.cryptoCard.setPasswordCallback(pwc);
            } else {
                LOGGER.warning("Se ha proporcionado un LoadStoreParameter de tipo no soportado, se ignorara: " + (pp != null ? pp.getClass().getName() : "NULO"));
            }
        }
        this.aliases = Arrays.asList(this.cryptoCard.getAliases());
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] pass, Certificate[] chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineStore(OutputStream os, char[] pass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineDeleteEntry(String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOGGER.warning("No se soporta la obtencion de fecha de creacion, se devuelve la fecha actual");
        return new Date();
    }

    private static final class CachePasswordCallback
    extends PasswordCallback {
        private static final long serialVersionUID = 816457144215238935L;

        public CachePasswordCallback(char[] password) {
            super(">", false);
            this.setPassword(password);
        }
    }
}

