/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider.ceres;

import es.gob.jmulticard.JseCryptoHelper;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.fnmt.ceres.Ceres;
import es.gob.jmulticard.card.fnmt.ceres.CeresPrivateKeyReference;
import es.gob.jmulticard.jse.provider.ceres.CeresPasswordCallback;
import es.gob.jmulticard.jse.provider.ceres.CeresPrivateKey;
import es.gob.jmulticard.jse.provider.ceres.CeresProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.x500.X500Principal;

public final class CeresKeyStoreImpl
extends KeyStoreSpi {
    private static List<String> userCertAliases = null;
    private Ceres cryptoCard = null;

    private void loadAliases() {
        String[] aliases = this.cryptoCard.getAliases();
        userCertAliases = new ArrayList<String>(aliases.length);
        for (String alias : aliases) {
            userCertAliases.add(alias);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(userCertAliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return userCertAliases.contains(alias);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        return this.cryptoCard.getCertificate(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        BigInteger serial = ((X509Certificate)cert).getSerialNumber();
        X500Principal principal = ((X509Certificate)cert).getIssuerX500Principal();
        for (String alias : userCertAliases) {
            X509Certificate c = (X509Certificate)this.engineGetCertificate(alias);
            if (c.getSerialNumber() != serial || !principal.equals(principal)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        return new X509Certificate[]{(X509Certificate)this.engineGetCertificate(alias)};
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        PrivateKeyReference pkRef;
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (password != null) {
            this.cryptoCard.setPasswordCallback(new CachePasswordCallback(password));
        }
        if (!((pkRef = this.cryptoCard.getPrivateKey(alias)) instanceof CeresPrivateKeyReference)) {
            throw new ProviderException("La clave obtenida de la tarjeta no es del tipo esperado, se ha obtenido: " + pkRef.getClass().getName());
        }
        return new CeresPrivateKey((CeresPrivateKeyReference)pkRef, this.cryptoCard, ((RSAPublicKey)this.engineGetCertificate(alias).getPublicKey()).getModulus());
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) {
        if (protParam instanceof KeyStore.PasswordProtection) {
            CachePasswordCallback pwc = new CachePasswordCallback(((KeyStore.PasswordProtection)protParam).getPassword());
            this.cryptoCard.setPasswordCallback(pwc);
        }
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        PrivateKey key = (PrivateKey)this.engineGetKey(alias, null);
        return new KeyStore.PrivateKeyEntry(key, this.engineGetCertificateChain(alias));
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return userCertAliases.contains(alias);
    }

    private static ApduConnection getApduConnection() {
        return CeresProvider.getDefaultApduConnection();
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException {
        if (param != null) {
            KeyStore.ProtectionParameter pp = param.getProtectionParameter();
            if (pp instanceof KeyStore.CallbackHandlerProtection) {
                if (((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler() == null) {
                    throw new IllegalArgumentException("El CallbackHandler no puede ser nulo");
                }
                this.cryptoCard = new Ceres(CeresProvider.getDefaultApduConnection(), new JseCryptoHelper());
                this.cryptoCard.setCallbackHandler(((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler());
            } else if (pp instanceof KeyStore.PasswordProtection) {
                CeresPasswordCallback pwc = new CeresPasswordCallback((KeyStore.PasswordProtection)pp);
                this.cryptoCard = new Ceres(CeresProvider.getDefaultApduConnection(), new JseCryptoHelper());
                this.cryptoCard.setPasswordCallback(pwc);
            } else {
                Logger.getLogger("es.gob.jmulticard").warning("Se ha proporcionado un LoadStoreParameter de tipo no soportado, se ignorara: " + (pp != null ? pp.getClass().getName() : "NULO"));
            }
        } else {
            this.cryptoCard = new Ceres(CeresProvider.getDefaultApduConnection(), new JseCryptoHelper());
        }
        userCertAliases = Arrays.asList(this.cryptoCard.getAliases());
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        this.cryptoCard = new Ceres(CeresKeyStoreImpl.getApduConnection(), new JseCryptoHelper());
        this.loadAliases();
    }

    @Override
    public int engineSize() {
        return userCertAliases.size();
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (!this.engineContainsAlias(alias)) {
            return false;
        }
        return entryClass.equals(KeyStore.PrivateKeyEntry.class);
    }

    @Override
    public void engineDeleteEntry(String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineStore(OutputStream os, char[] pass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] pass, Certificate[] chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Logger.getLogger("es.gob.jmulticard").warning("No se soporta la obtencion de fecha de creacion, se devuelve la fecha actual");
        return new Date();
    }

    private static final class CachePasswordCallback
    extends PasswordCallback {
        private static final long serialVersionUID = 816457144215238935L;

        CachePasswordCallback(char[] password) {
            super(">", false);
            this.setPassword(password);
        }
    }
}

