/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.jse.provider.Ceres430Provider;
import es.gob.jmulticard.jse.provider.DnieProvider;
import es.gob.jmulticard.jse.provider.ceres.CeresProvider;
import es.gob.jmulticard.jse.provider.gide.SmartCafeProvider;
import es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection;
import java.security.Provider;
import java.util.logging.Logger;

public final class JMultiCardProviderFactory {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final byte[] DNI_NFC_ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0};
    private static final Atr DNI_NFC_ATR = new Atr(new byte[]{59, -120, -128, 1, -31, -13, 94, 17, 119, -127, -95, 0, 3}, DNI_NFC_ATR_MASK);
    private static final byte[] DNI_ATR_MASK = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private static final Atr DNI_ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 68, 78, 73, 101, 0, 0, 0, 0, 0, 0, 0, -112, 0}, DNI_ATR_MASK);
    private static final Atr TIF_ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 84, 73, 70, 49, 0, 0, 0, 0, 0, 0, 0, -112, 0}, DNI_ATR_MASK);
    private static final Atr FNMT_TC_430_ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 70, 78, 77, 84, 0, 0, 0, 0, 0, 0, 0, -112, 0}, DNI_ATR_MASK);
    private static final byte[] CERES_TC_ATR_MASK = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1};
    private static final Atr CERES_TC_ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 70, 78, 77, 84, 0, 0, 0, 0, 0, 0, 3, -112, 0}, CERES_TC_ATR_MASK);
    private static final byte[] CERES_ST_ATR_MASK = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1};
    private static final Atr CERES_ST_ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 67, 69, 82, 69, 83, 2, 44, 52, 0, 0, 3, -112, 0}, CERES_ST_ATR_MASK);
    private static final byte[] CERES_SLE_FN20_ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr CERES_SLE_FN20_ATR = new Atr(new byte[]{59, -17, 0, 0, 64, 20, -128, 37, 67, 69, 82, 69, 83, 87, 5, 96, 1, 2, 3, -112, 0}, CERES_SLE_FN20_ATR_MASK);
    private static final byte[] CERES_SLE_FN19_ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr CERES_SLE_FN19_ATR = new Atr(new byte[]{59, -17, 0, 0, 64, 20, -128, 37, 67, 69, 82, 69, 83, 87, 1, 22, 1, 1, 3, -112, 0}, CERES_SLE_FN19_ATR_MASK);
    private static final byte[] GIDE_SCAF_ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15};
    private static final Atr GIDE_SCAF_ATR = new Atr(new byte[]{59, -9, 24, 0, 0, -128, 49, -2, 69, 115, 102, 116, 101, 45, 110, 102, -60}, GIDE_SCAF_ATR_MASK);
    private static final byte[] GIDE_SCAF_MSC_ATR_MASK = new byte[]{-1, -1, -1, -1, -1};
    private static final Atr GIDE_SCAF_MSC_ATR = new Atr(new byte[]{59, -128, -128, 1, 1}, GIDE_SCAF_MSC_ATR_MASK);
    private static final byte[] GIDE_SCAF_TCL_ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15};
    private static final Atr GIDE_SCAF_TCL_ATR = new Atr(new byte[]{59, -9, 24, 0, 0, -128, 49, -2, 69, 115, 102, 116, 101, 45, 110, 102, -60}, GIDE_SCAF_TCL_ATR_MASK);

    private JMultiCardProviderFactory() {
    }

    public static Provider getProvider() {
        long[] terminals;
        SmartcardIoConnection conn = new SmartcardIoConnection();
        try {
            terminals = conn.getTerminals(false);
        }
        catch (ApduConnectionException e1) {
            LOGGER.warning("No se ha podido obtener la lista de lectores de tarjetas del sistema: " + e1);
            return null;
        }
        byte[] atr = null;
        for (long terminal : terminals) {
            conn.setTerminal((int)terminal);
            try {
                atr = conn.reset();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return JMultiCardProviderFactory.getProvider(atr);
    }

    public static Provider getProvider(byte[] atr) {
        if (atr == null) {
            return null;
        }
        if (JMultiCardProviderFactory.isDni(atr)) {
            return new DnieProvider();
        }
        if (JMultiCardProviderFactory.isCeres430(atr)) {
            return new Ceres430Provider();
        }
        if (JMultiCardProviderFactory.isCeres(atr)) {
            return new CeresProvider();
        }
        if (JMultiCardProviderFactory.isGiDeSmartCafe(atr)) {
            return new SmartCafeProvider();
        }
        return null;
    }

    private static boolean isDni(byte[] atr) {
        return DNI_ATR.equals(atr) || TIF_ATR.equals(atr) || DNI_NFC_ATR.equals(atr);
    }

    private static boolean isCeres430(byte[] atr) {
        return FNMT_TC_430_ATR.equals(atr) && atr[15] >= 4 && atr[16] >= 48;
    }

    private static boolean isCeres(byte[] atr) {
        return CERES_TC_ATR.equals(atr) || CERES_ST_ATR.equals(atr) || CERES_SLE_FN20_ATR.equals(atr) || CERES_SLE_FN19_ATR.equals(atr);
    }

    private static boolean isGiDeSmartCafe(byte[] atr) {
        return GIDE_SCAF_ATR.equals(atr) || GIDE_SCAF_MSC_ATR.equals(atr) || GIDE_SCAF_TCL_ATR.equals(atr);
    }
}

