/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.card.dnie.Dnie;
import java.security.Provider;
import java.security.ProviderException;

public final class DnieProvider
extends Provider {
    private static final String SHA512WITH_RSA = "SHA512withRSA";
    private static final String SHA384WITH_RSA = "SHA384withRSA";
    private static final String SHA256WITH_RSA = "SHA256withRSA";
    private static final String SHA1WITH_RSA = "SHA1withRSA";
    private static final String DNIE_PRIVATE_KEY = "es.gob.jmulticard.jse.provider.DniePrivateKey";
    private static final long serialVersionUID = -1046745919235177156L;
    private static final String INFO = "Proveedor para el DNIe";
    private static final double VERSION = 0.2;
    private static final String NAME = "DNIeJCAProvider";
    private static ApduConnection defaultConnection = null;

    static ApduConnection getDefaultApduConnection() {
        return defaultConnection;
    }

    public DnieProvider() {
        this((ApduConnection)null);
    }

    public DnieProvider(ApduConnection conn) {
        super(NAME, 0.2, INFO);
        try {
            defaultConnection = conn == null ? (ApduConnection)Class.forName("es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection").getConstructor(new Class[0]).newInstance(new Object[0]) : conn;
        }
        catch (Exception e) {
            throw new ProviderException("No se ha proporcionado una conexion con un lector y no ha podido instanciarse la por defecto: " + e, e);
        }
        try {
            Dnie.connect(defaultConnection);
            defaultConnection.close();
        }
        catch (Exception e) {
            throw new ProviderException("No se ha podido inicializar el proveedor de DNIe: " + e, e);
        }
        this.put("KeyStore.DNI", "es.gob.jmulticard.jse.provider.DnieKeyStoreImpl");
        this.put("Signature.SHA1withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha1");
        this.put("Signature.SHA256withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha256");
        this.put("Signature.SHA384withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha384");
        this.put("Signature.SHA512withRSA", "es.gob.jmulticard.jse.provider.DnieSignatureImpl$Sha512");
        this.put("Signature.SHA1withRSA SupportedKeyClasses", DNIE_PRIVATE_KEY);
        this.put("Signature.SHA256withRSA SupportedKeyClasses", DNIE_PRIVATE_KEY);
        this.put("Signature.SHA384withRSA SupportedKeyClasses", DNIE_PRIVATE_KEY);
        this.put("Signature.SHA512withRSA SupportedKeyClasses", DNIE_PRIVATE_KEY);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.1.3.14.3.2.29", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHAwithRSA", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-1withRSA", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA1withRSAEncryption", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-1withRSAEncryption", SHA1WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-256withRSA", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-256withRSAEncryption", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.SHA256withRSAEncryption", SHA256WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-384withRSA", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-384withRSAEncryption", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.SHA384withRSAEncryption", SHA384WITH_RSA);
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-512withRSA", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA-512withRSAEncryption", SHA512WITH_RSA);
        this.put("Alg.Alias.Signature.SHA512withRSAEncryption", SHA512WITH_RSA);
    }
}

