/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

public final class DniePrivateKey
implements RSAPrivateKey {
    private static final long serialVersionUID = 4403051294889801855L;
    private final CryptoCard dnie;
    private final byte[] id;
    private final Location path;
    private final String name;
    private final byte reference;
    private final int keySize;

    DniePrivateKey(DniePrivateKeyReference keyReference) {
        this.dnie = keyReference.getDnieCard();
        this.id = keyReference.getIdentifier();
        this.path = keyReference.getKeyPath();
        this.name = keyReference.getLabel();
        this.reference = keyReference.getKeyReference();
        this.keySize = keyReference.getKeyBitSize();
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    CryptoCard getCryptoCard() {
        return this.dnie;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    byte[] getId() {
        return this.id;
    }

    @Override
    public BigInteger getModulus() {
        throw new UnsupportedOperationException();
    }

    Location getPath() {
        return this.path;
    }

    @Override
    public BigInteger getPrivateExponent() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.name;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    byte getKeyReference() {
        return this.reference;
    }

    int getKeyBitSize() {
        return this.keySize;
    }
}

