/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.jse.provider;

import es.gob.jmulticard.JseCryptoHelper;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.dnie.CeresSc;
import es.gob.jmulticard.card.dnie.Dnie;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.jse.provider.BadPasswordProviderException;
import es.gob.jmulticard.jse.provider.Ceres430Provider;
import es.gob.jmulticard.jse.provider.DniePrivateKey;
import es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public final class Ceres430KeyStoreImpl
extends KeyStoreSpi {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final String INTERMEDIATE_CA_CERT_ALIAS = "CertCAIntermediaDGP";
    private Dnie cryptoCard = null;
    private List<String> aliases = null;

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.aliases.contains(alias);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        try {
            return this.cryptoCard.getCertificate(alias);
        }
        catch (CryptoCardException e) {
            throw new ProviderException(e);
        }
        catch (PinException e) {
            throw new BadPasswordProviderException(e);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        BigInteger serial = ((X509Certificate)cert).getSerialNumber();
        for (String alias : this.aliases) {
            if (((X509Certificate)this.engineGetCertificate(alias)).getSerialNumber() != serial) continue;
            return alias;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        X509Certificate intermediateCaCert;
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add((X509Certificate)this.engineGetCertificate(alias));
        try {
            intermediateCaCert = this.cryptoCard.getCertificate(INTERMEDIATE_CA_CERT_ALIAS);
        }
        catch (AuthenticationModeLockedException e) {
            throw e;
        }
        catch (BadPinException e) {
            throw new BadPasswordProviderException(e);
        }
        catch (Exception e) {
            LOGGER.warning("No se ha podido cargar el certificado de la CA intermedia: " + e);
            intermediateCaCert = null;
        }
        X509Certificate sha2DnieRoot = null;
        if (intermediateCaCert != null) {
            certs.add(intermediateCaCert);
            try {
                sha2DnieRoot = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(Ceres430KeyStoreImpl.class.getResourceAsStream("/ACRAIZ-SHA2.crt"));
            }
            catch (Exception e) {
                sha2DnieRoot = null;
                LOGGER.warning("No se ha podido cargar el certificado de la CA raiz: " + e);
            }
            if (sha2DnieRoot != null) {
                try {
                    intermediateCaCert.verify(sha2DnieRoot.getPublicKey());
                }
                catch (Exception e) {
                    sha2DnieRoot = null;
                    LOGGER.info("La CA raiz precargada no es la emisora de esta tarjeta: " + e);
                }
            }
        }
        if (sha2DnieRoot != null) {
            certs.add(sha2DnieRoot);
        }
        return certs.toArray(new X509Certificate[0]);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        PrivateKeyReference pkRef;
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (password != null) {
            CachePasswordCallback pwc = new CachePasswordCallback(password);
            this.cryptoCard.setPasswordCallback(pwc);
        }
        if (!((pkRef = this.cryptoCard.getPrivateKey(alias)) instanceof DniePrivateKeyReference)) {
            throw new ProviderException("La clave obtenida de la tarjeta no es del tipo esperado, se ha obtenido: " + (pkRef != null ? pkRef.getClass().getName() : "null"));
        }
        return new DniePrivateKey((DniePrivateKeyReference)pkRef);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) {
        if (protParam instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler chp = ((KeyStore.CallbackHandlerProtection)protParam).getCallbackHandler();
            if (chp != null) {
                this.cryptoCard.setCallbackHandler(chp);
            }
        } else if (protParam instanceof KeyStore.PasswordProtection) {
            CachePasswordCallback pwc = new CachePasswordCallback(((KeyStore.PasswordProtection)protParam).getPassword());
            this.cryptoCard.setPasswordCallback(pwc);
        } else {
            LOGGER.warning("Se ha proporcionado un ProtectionParameter de tipo no soportado, se ignorara: " + (protParam != null ? protParam.getClass().getName() : "NULO"));
        }
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        PrivateKey key = (PrivateKey)this.engineGetKey(alias, null);
        return new KeyStore.PrivateKeyEntry(key, this.engineGetCertificateChain(alias));
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.aliases.contains(alias);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.aliases.contains(alias);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException {
        if (param != null) {
            KeyStore.ProtectionParameter pp = param.getProtectionParameter();
            if (pp instanceof KeyStore.CallbackHandlerProtection) {
                if (((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler() == null) {
                    throw new IllegalArgumentException("El CallbackHandler no puede ser nulo");
                }
                this.cryptoCard = new CeresSc(Ceres430Provider.getDefaultApduConnection(), null, new JseCryptoHelper(), ((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler());
            } else if (pp instanceof KeyStore.PasswordProtection) {
                CommonPasswordCallback pwc = new CommonPasswordCallback((KeyStore.PasswordProtection)pp);
                this.cryptoCard = new CeresSc(Ceres430Provider.getDefaultApduConnection(), pwc, new JseCryptoHelper(), null);
            } else {
                LOGGER.warning("Se ha proporcionado un LoadStoreParameter de tipo no soportado, se ignorara: " + (pp != null ? pp.getClass().getName() : "NULO"));
            }
        } else {
            this.cryptoCard = new CeresSc(Ceres430Provider.getDefaultApduConnection(), null, new JseCryptoHelper(), null);
        }
        this.aliases = Arrays.asList(this.cryptoCard.getAliases());
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        ApduConnection conn;
        try {
            conn = Ceres430Provider.getDefaultApduConnection() == null ? (ApduConnection)Class.forName("es.gob.jmulticard.jse.smartcardio.SmartcardIoConnection").getConstructor(new Class[0]).newInstance(new Object[0]) : Ceres430Provider.getDefaultApduConnection();
        }
        catch (Exception e) {
            throw new IllegalStateException("No hay una conexion de APDU por defecto: " + e);
        }
        this.cryptoCard = new CeresSc(conn, password != null ? new CachePasswordCallback(password) : null, new JseCryptoHelper(), null);
        this.aliases = Arrays.asList(this.cryptoCard.getAliases());
    }

    @Override
    public int engineSize() {
        return this.aliases.size();
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (!this.engineContainsAlias(alias)) {
            return false;
        }
        return entryClass.equals(KeyStore.PrivateKeyEntry.class);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOGGER.warning("No se soporta la obtencion de fecha de creacion, se devuelve la fecha actual");
        return new Date();
    }

    @Override
    public void engineStore(OutputStream os, char[] pass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] pass, Certificate[] chain) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineDeleteEntry(String alias) {
        throw new UnsupportedOperationException();
    }

    private static final class CachePasswordCallback
    extends PasswordCallback {
        private static final long serialVersionUID = 816457144215238935L;

        public CachePasswordCallback(char[] password) {
            super(">", false);
            this.setPassword(password);
        }
    }
}

