/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.de.tsenger.androsmex.iso7816;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.de.tsenger.androsmex.crypto.AmCryptoException;
import es.gob.jmulticard.de.tsenger.androsmex.crypto.AmCryptoProvider;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.DO87;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.DO8E;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.DO97;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.DO99;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.SecureMessagingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.spongycastle.asn1.ASN1InputStream;

public final class SecureMessaging {
    private final byte[] kenc;
    private final byte[] kmac;
    private final byte[] ssc;
    private final AmCryptoProvider crypto;

    public SecureMessaging(AmCryptoProvider acp, byte[] ksenc, byte[] ksmac, byte[] initialSSC) {
        this.crypto = acp;
        this.kenc = (byte[])ksenc.clone();
        this.kmac = (byte[])ksmac.clone();
        this.ssc = (byte[])initialSSC.clone();
    }

    public CommandApdu wrap(CommandApdu capdu) throws SecureMessagingException {
        int lc = 0;
        DO97 do97 = null;
        DO87 do87 = null;
        SecureMessaging.incrementAtIndex(this.ssc);
        byte[] header = new byte[4];
        System.arraycopy(capdu.getBytes(), 0, header, 0, 4);
        header[0] = (byte)(header[0] | 0xC);
        if (SecureMessaging.getAPDUStructure(capdu) == 3 || SecureMessaging.getAPDUStructure(capdu) == 4) {
            do87 = this.buildDO87((byte[])capdu.getData().clone());
            lc = (byte)(lc + do87.getEncoded().length);
        }
        if (SecureMessaging.getAPDUStructure(capdu) == 2 || SecureMessaging.getAPDUStructure(capdu) == 4) {
            do97 = SecureMessaging.buildDO97(capdu.getLe());
            lc = (byte)(lc + do97.getEncoded().length);
        }
        DO8E do8E = this.buildDO8E(header, do87, do97);
        lc = (byte)(lc + do8E.getEncoded().length);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            bOut.write(header);
            bOut.write(lc);
            if (do87 != null) {
                bOut.write(do87.getEncoded());
            }
            if (do97 != null) {
                bOut.write(do97.getEncoded());
            }
            bOut.write(do8E.getEncoded());
            bOut.write(0);
        }
        catch (IOException e) {
            throw new SecureMessagingException(e);
        }
        return new CommandApdu(bOut.toByteArray());
    }

    /*
     * Unable to fully structure code
     */
    public ResponseApdu unwrap(ResponseApdu responseApduEncrypted) throws SecureMessagingException {
        do87 = null;
        do99 = null;
        do8E = null;
        SecureMessaging.incrementAtIndex(this.ssc);
        rapduBytes = responseApduEncrypted.getData();
        subArray = new byte[rapduBytes.length];
        block31: for (pointer = 0; pointer < rapduBytes.length; pointer += encodedBytes.length) {
            System.arraycopy(rapduBytes, pointer, subArray, 0, rapduBytes.length - pointer);
            try {
                asn1sp = new ASN1InputStream(subArray);
                var10_13 = null;
                try {
                    encodedBytes = asn1sp.readObject().getEncoded();
                }
                catch (Throwable var11_16) {
                    var10_13 = var11_16;
                    throw var11_16;
                }
                finally {
                    if (asn1sp != null) {
                        if (var10_13 != null) {
                            try {
                                asn1sp.close();
                            }
                            catch (Throwable var11_15) {
                                var10_13.addSuppressed(var11_15);
                            }
                        } else {
                            asn1sp.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SecureMessagingException(e);
            }
            try {
                asn1in = new ASN1InputStream(encodedBytes);
                var10_13 = null;
                try {
                    switch (encodedBytes[0]) {
                        case -121: {
                            do87 = new DO87();
                            do87.fromByteArray(asn1in.readObject().getEncoded());
                            ** break;
lbl41:
                            // 1 sources

                            continue block31;
                        }
                        case -103: {
                            do99 = new DO99();
                            do99.fromByteArray(asn1in.readObject().getEncoded());
                            ** break;
lbl46:
                            // 1 sources

                            continue block31;
                        }
                        case -114: {
                            do8E = new DO8E();
                            do8E.fromByteArray(asn1in.readObject().getEncoded());
                            ** break;
lbl51:
                            // 1 sources

                            continue block31;
                        }
                        ** default:
lbl53:
                        // 1 sources

                        continue block31;
                    }
                }
                catch (Throwable var11_18) {
                    var10_13 = var11_18;
                    throw var11_18;
                }
                finally {
                    if (asn1in != null) {
                        if (var10_13 != null) {
                            try {
                                asn1in.close();
                            }
                            catch (Throwable var11_17) {
                                var10_13.addSuppressed(var11_17);
                            }
                        } else {
                            asn1in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SecureMessagingException(e);
            }
        }
        if (do99 == null || do8E == null) {
            throw new SecureMessagingException("Error en SecureMessaging: DO99 o DO8E no encontrados");
        }
        bout = new ByteArrayOutputStream();
        try {
            if (do87 != null) {
                bout.write(do87.getEncoded());
            }
            bout.write(do99.getEncoded());
        }
        catch (IOException e) {
            throw new SecureMessagingException(e);
        }
        this.crypto.init(this.kmac, this.ssc);
        cc = this.crypto.getMAC(bout.toByteArray());
        do8eData = do8E.getData();
        if (!Arrays.equals(cc, do8eData)) {
            throw new SecureMessagingException("Checksum incorrecto\n CC Calculado: " + HexUtils.hexify(cc, false) + "\nCC en DO8E: " + HexUtils.hexify(do8eData, false));
        }
        if (do87 != null) {
            this.crypto.init(this.kenc, this.ssc);
            do87Data = do87.getData();
            try {
                data = this.crypto.decrypt(do87Data);
            }
            catch (AmCryptoException e) {
                throw new SecureMessagingException(e);
            }
            unwrappedAPDUBytes = new byte[data.length + 2];
            System.arraycopy(data, 0, unwrappedAPDUBytes, 0, data.length);
            do99Data = do99.getData();
            System.arraycopy(do99Data, 0, unwrappedAPDUBytes, data.length, do99Data.length);
        } else {
            unwrappedAPDUBytes = (byte[])do99.getData().clone();
        }
        return new ResponseApdu(unwrappedAPDUBytes);
    }

    private DO87 buildDO87(byte[] data) throws SecureMessagingException {
        byte[] enc_data;
        this.crypto.init(this.kenc, this.ssc);
        try {
            enc_data = this.crypto.encrypt(data);
        }
        catch (AmCryptoException e) {
            throw new SecureMessagingException(e);
        }
        return new DO87(enc_data);
    }

    private DO8E buildDO8E(byte[] header, DO87 do87, DO97 do97) throws SecureMessagingException {
        ByteArrayOutputStream m = new ByteArrayOutputStream();
        try {
            if (do87 != null || do97 != null) {
                m.write(this.crypto.addPadding(header));
            } else {
                m.write(header);
            }
            if (do87 != null) {
                m.write(do87.getEncoded());
            }
            if (do97 != null) {
                m.write(do97.getEncoded());
            }
        }
        catch (IOException e) {
            throw new SecureMessagingException(e);
        }
        this.crypto.init(this.kmac, this.ssc);
        return new DO8E(this.crypto.getMAC(m.toByteArray()));
    }

    private static DO97 buildDO97(int le) {
        return new DO97(le);
    }

    private static byte getAPDUStructure(CommandApdu capdu) {
        byte[] cardcmd = capdu.getBytes();
        if (cardcmd.length == 4) {
            return 1;
        }
        if (cardcmd.length == 5) {
            return 2;
        }
        if (cardcmd.length == 5 + (cardcmd[4] & 0xFF) && cardcmd[4] != 0) {
            return 3;
        }
        if (cardcmd.length == 6 + (cardcmd[4] & 0xFF) && cardcmd[4] != 0) {
            return 4;
        }
        if (cardcmd.length == 7 && cardcmd[4] == 0) {
            return 5;
        }
        if (cardcmd.length == 7 + (cardcmd[5] & 0xFF) * 256 + (cardcmd[6] & 0xFF) && cardcmd[4] == 0 && (cardcmd[5] != 0 || cardcmd[6] != 0)) {
            return 6;
        }
        if (cardcmd.length == 9 + (cardcmd[5] & 0xFF) * 256 + (cardcmd[6] & 0xFF) && cardcmd[4] == 0 && (cardcmd[5] != 0 || cardcmd[6] != 0)) {
            return 7;
        }
        return 0;
    }

    private static void incrementAtIndex(byte[] array) {
        byte[] result = new BigInteger(array).add(BigInteger.ONE).toByteArray();
        if (result.length > array.length) {
            Arrays.fill(array, (byte)0);
        } else {
            int lengthA = array.length;
            int lengthR = result.length;
            for (int i = 0; i < lengthR; ++i) {
                array[lengthA - 1 - i] = result[lengthR - 1 - i];
            }
        }
    }
}

