/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.de.tsenger.androsmex.crypto;

import es.gob.jmulticard.HexUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class Crypto {
    private Crypto() {
    }

    private static byte[] padByteArray(byte[] data) {
        int i = 0;
        byte[] tempdata = new byte[data.length + 8];
        for (i = 0; i < data.length; ++i) {
            tempdata[i] = data[i];
        }
        tempdata[i] = -128;
        ++i;
        while (i % 8 != 0) {
            tempdata[i] = 0;
            ++i;
        }
        byte[] filledArray = new byte[i];
        System.arraycopy(tempdata, 0, filledArray, 0, i);
        return filledArray;
    }

    public static byte[] computeMAC(byte[] key, byte[] pt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher des;
        byte[] ka = new byte[8];
        byte[] kb = new byte[8];
        System.arraycopy(key, 0, ka, 0, 8);
        System.arraycopy(key, 8, kb, 0, 8);
        SecretKeySpec skeya = new SecretKeySpec(ka, "DES");
        SecretKeySpec skeyb = new SecretKeySpec(kb, "DES");
        byte[] current = new byte[8];
        byte[] mac = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        byte[] plaintext = Crypto.padByteArray(pt);
        for (int i = 0; i < plaintext.length; i += 8) {
            System.arraycopy(plaintext, i, current, 0, 8);
            mac = HexUtils.xor(current, mac);
            des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, skeya);
            mac = des.update(mac);
        }
        des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(2, skeyb);
        mac = des.update(mac);
        des.init(1, skeya);
        mac = des.doFinal(mac);
        return mac;
    }
}

