/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.de.tsenger.androsmex.crypto;

import es.gob.jmulticard.de.tsenger.androsmex.crypto.AmCryptoProvider;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.macs.CMac;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.paddings.ISO7816d4Padding;
import org.spongycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;

public final class AmAESCrypto
extends AmCryptoProvider {
    private byte[] keyBytes = null;
    private KeyParameter keyP = null;
    private byte[] IV = null;
    private byte[] sscBytes = null;
    private static final int BLOCK_SIZE = 16;

    private void initCiphers(byte[] key, byte[] iv) {
        this.keyBytes = new byte[key.length];
        System.arraycopy(key, 0, this.keyBytes, 0, key.length);
        this.keyP = new KeyParameter(this.keyBytes);
        this.IV = new byte[16];
        System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
        this.encryptCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()), new ISO7816d4Padding());
        this.decryptCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()), new ISO7816d4Padding());
        ParametersWithIV parameterIV = new ParametersWithIV(this.keyP, this.IV);
        this.encryptCipher.init(true, parameterIV);
        this.decryptCipher.init(false, parameterIV);
    }

    @Override
    public void init(byte[] keyBytes1, byte[] ssc) {
        this.sscBytes = (byte[])ssc.clone();
        byte[] iv = AmAESCrypto.encryptBlock(keyBytes1, this.sscBytes);
        this.initCiphers(keyBytes1, iv);
    }

    @Override
    public byte[] getMAC(byte[] data) {
        byte[] n = new byte[this.sscBytes.length + data.length];
        System.arraycopy(this.sscBytes, 0, n, 0, this.sscBytes.length);
        System.arraycopy(data, 0, n, this.sscBytes.length, data.length);
        n = this.addPadding(n);
        AESEngine cipher = new AESEngine();
        CMac mac = new CMac(cipher, 64);
        mac.init(this.keyP);
        mac.update(n, 0, n.length);
        byte[] out = new byte[mac.getMacSize()];
        mac.doFinal(out, 0);
        return out;
    }

    public static byte[] encryptBlock(byte[] key, byte[] z) {
        byte[] s = new byte[16];
        KeyParameter encKey = new KeyParameter(key);
        AESEngine cipher = new AESEngine();
        cipher.init(true, encKey);
        cipher.processBlock(z, 0, s, 0);
        return s;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }
}

