/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.pace;

import es.gob.jmulticard.apdu.iso7816four.pace.MseSetPaceAlgorithmApduCommand;
import es.gob.jmulticard.card.pace.MalformedMrzException;
import es.gob.jmulticard.card.pace.MrzInfo;
import es.gob.jmulticard.card.pace.PaceInitializer;
import java.io.IOException;

public final class PaceInitializerMrz
extends PaceInitializer {
    private final byte[] k;

    private PaceInitializerMrz(byte[] mrz) {
        if (mrz == null) {
            throw new IllegalArgumentException("La MRZ no puede ser nula");
        }
        this.k = mrz;
    }

    public String toString() {
        return new String(this.k);
    }

    @Override
    public byte[] getBytes() {
        return this.k;
    }

    @Override
    public MseSetPaceAlgorithmApduCommand.PacePasswordType getPasswordType() {
        return MseSetPaceAlgorithmApduCommand.PacePasswordType.MRZ;
    }

    public static PaceInitializerMrz deriveMrz(String mrz) throws MalformedMrzException {
        if (mrz == null || mrz.isEmpty()) {
            throw new IllegalArgumentException("El valor no puede ser nulo ni vacio");
        }
        try {
            return new PaceInitializerMrz(new MrzInfo(mrz).getMrzPswd());
        }
        catch (IOException ex) {
            throw new MalformedMrzException("La MRZ no tiene formato valido: " + ex, ex);
        }
    }
}

