/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.pace;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890OneV2Connection;
import es.gob.jmulticard.apdu.connection.cwa14890.InvalidCryptographicChecksumException;
import es.gob.jmulticard.card.SmartCard;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.SecureMessaging;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.SecureMessagingException;
import java.util.logging.Logger;

public final class PaceConnection
extends Cwa14890OneV2Connection {
    private static final StatusWord INVALID_CRYPTO_CHECKSUM = new StatusWord(102, -120);
    private static final byte MSB_INCORRECT_LE = 108;
    private final SecureMessaging sm;

    public PaceConnection(ApduConnection connection, CryptoHelper cryptoHelper, SecureMessaging secMsg) {
        super(connection, cryptoHelper);
        this.sm = secMsg;
        this.subConnection = connection;
    }

    @Override
    public void open() {
        this.openState = false;
    }

    @Override
    public ResponseApdu transmit(CommandApdu command) throws ApduConnectionException {
        ResponseApdu decipherApdu;
        CommandApdu protectedApdu;
        CommandApdu finalCommand = new CommandApdu(command.getCla(), command.getIns(), command.getP1(), command.getP2(), command.getData(), command.getLe());
        if (SmartCard.DEBUG) {
            Logger.getLogger("es.gob.jmulticard").info("APDU de comando en claro: " + HexUtils.hexify(finalCommand.getBytes(), true));
        }
        try {
            protectedApdu = this.sm.wrap(finalCommand);
        }
        catch (SecureMessagingException e) {
            throw new ApduConnectionException("No ha sido posible cifrar un mensaje seguro con el canal PACE: " + e);
        }
        ResponseApdu responseApdu = this.subConnection.transmit(protectedApdu);
        try {
            decipherApdu = this.sm.unwrap(responseApdu);
        }
        catch (SecureMessagingException e1) {
            throw new ApduConnectionException("No ha sido posible descifrar un mensaje seguro con el canal PACE: " + e1);
        }
        if (SmartCard.DEBUG) {
            Logger.getLogger("es.gob.jmulticard").info("APDU de respuesta en claro: " + HexUtils.hexify(decipherApdu.getBytes(), true));
        }
        if (INVALID_CRYPTO_CHECKSUM.equals(decipherApdu.getStatusWord())) {
            throw new InvalidCryptographicChecksumException();
        }
        if (decipherApdu.getStatusWord().getMsb() == 108) {
            command.setLe(decipherApdu.getStatusWord().getLsb());
            return this.transmit(command);
        }
        return decipherApdu;
    }
}

