/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.pace;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.iso7816four.GeneralAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.pace.MseSetPaceAlgorithmApduCommand;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import es.gob.jmulticard.card.pace.InvalidCanOrMrzException;
import es.gob.jmulticard.card.pace.PaceException;
import es.gob.jmulticard.card.pace.PaceInitializer;
import es.gob.jmulticard.de.tsenger.androsmex.crypto.AmAESCrypto;
import es.gob.jmulticard.de.tsenger.androsmex.crypto.AmCryptoProvider;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.SecureMessaging;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Random;
import java.util.logging.Logger;
import org.spongycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECFieldElement;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.util.Arrays;

public final class PaceChannelHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final byte[] CAN_MRZ_PADDING = new byte[]{0, 0, 0, 3};
    private static final byte[] KENC_PADDING = new byte[]{0, 0, 0, 1};
    private static final byte[] KMAC_PADDING = new byte[]{0, 0, 0, 2};
    private static final byte[] MAC_PADDING = new byte[]{127, 73, 79, 6};
    private static final byte[] MAC2_PADDING = new byte[]{-122, 65, 4};
    private static final byte TAG_DYNAMIC_AUTHENTICATION_DATA = 124;
    private static final byte TAG_GEN_AUTH_2 = -127;
    private static final byte TAG_GEN_AUTH_3 = -125;
    private static final byte TAG_GEN_AUTH_4 = -123;

    private PaceChannelHelper() {
    }

    public static SecureMessaging openPaceChannel(byte cla, PaceInitializer pi, ApduConnection conn, CryptoHelper cryptoHelper) throws ApduConnectionException, PaceException {
        byte[] mac8bytes;
        byte[] pukIccDh2;
        byte[] pukIccDh1;
        byte[] secret_nonce;
        byte[] nonce;
        CommandApdu comm;
        ResponseApdu res;
        if (conn == null) {
            throw new IllegalArgumentException("El canal de conexion no puede ser nulo");
        }
        if (pi == null) {
            throw new IllegalArgumentException("Es necesario proporcionar un inicializador para abrir canal PACE");
        }
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("El CryptoHelper no puede ser nulo");
        }
        if (!conn.isOpen()) {
            conn.open();
        }
        if (!(res = conn.transmit(comm = new MseSetPaceAlgorithmApduCommand(cla, MseSetPaceAlgorithmApduCommand.PaceAlgorithmOid.PACE_ECDH_GM_AES_CBC_CMAC_128, pi.getPasswordType(), MseSetPaceAlgorithmApduCommand.PaceAlgorithmParam.BRAINPOOL_256_R1))).isOk()) {
            throw new PaceException(res.getStatusWord(), comm, "Error estableciendo el algoritmo del protocolo PACE (fallo en el MSE Set)");
        }
        comm = new GeneralAuthenticateApduCommand(16, new byte[]{124, 0});
        res = conn.transmit(comm);
        if (!res.isOk()) {
            throw new PaceException(res.getStatusWord(), comm, "Error solicitando el aleatorio de calculo PACE (Nonce)");
        }
        try {
            nonce = new Tlv(new Tlv(res.getData()).getValue()).getValue();
        }
        catch (TlvException e) {
            throw new PaceException("El aleatorio de calculo PACE (Nonce) obtenido (" + HexUtils.hexify(res.getData(), true) + ") no sigue el formato esperado: " + e, e);
        }
        byte[] sk = new byte[16];
        try {
            System.arraycopy(cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, HexUtils.concatenateByteArrays(pi.getBytes(), CAN_MRZ_PADDING)), 0, sk, 0, 16);
        }
        catch (IOException e) {
            throw new PaceException("Error obteniendo el 'sk' a partir del CAN/MRZ: " + e, e);
        }
        try {
            secret_nonce = cryptoHelper.aesDecrypt(nonce, new byte[0], sk);
        }
        catch (Exception e) {
            throw new PaceException("Error descifranco el 'nonce': " + e, e);
        }
        X9ECParameters ecdhParameters = TeleTrusTNamedCurves.getByName("brainpoolp256r1");
        ECPoint pointG = ecdhParameters.getG();
        ECCurve.Fp curve = (ECCurve.Fp)ecdhParameters.getCurve();
        Random rnd = new Random();
        rnd.setSeed(rnd.nextLong());
        byte[] x1 = new byte[curve.getFieldSize() / 8];
        rnd.nextBytes(x1);
        BigInteger PrkIFDDH1 = new BigInteger(1, x1);
        ECPoint pukIFDDH1 = pointG.multiply(PrkIFDDH1);
        Tlv tlv = new Tlv(124, new Tlv(-127, pukIFDDH1.getEncoded(false)).getBytes());
        comm = new GeneralAuthenticateApduCommand(16, tlv.getBytes());
        res = conn.transmit(comm);
        if (!res.isOk()) {
            throw new PaceException(res.getStatusWord(), comm, "Error mapeando el aleatorio de calculo PACE (Nonce)");
        }
        try {
            pukIccDh1 = PaceChannelHelper.unwrapEcKey(res.getData());
        }
        catch (Exception e) {
            throw new PaceException("Error obteniendo la clave efimera EC publica de la tarjeta: " + e, e);
        }
        ECPoint y1FromG = PaceChannelHelper.byteArrayToECPoint(pukIccDh1, curve);
        ECPoint SharedSecret_H = y1FromG.multiply(PrkIFDDH1);
        BigInteger ms = new BigInteger(1, secret_nonce);
        ECPoint g_temp = pointG.multiply(ms);
        ECPoint newPointG = g_temp.add(SharedSecret_H);
        byte[] x2 = new byte[curve.getFieldSize() / 8];
        rnd.setSeed(rnd.nextLong());
        rnd.nextBytes(x2);
        BigInteger PrkIFDDH2 = new BigInteger(1, x2);
        ECPoint pukIFDDH2 = newPointG.multiply(PrkIFDDH2);
        tlv = new Tlv(124, new Tlv(-125, pukIFDDH2.getEncoded(false)).getBytes());
        comm = new GeneralAuthenticateApduCommand(16, tlv.getBytes());
        res = conn.transmit(comm);
        try {
            pukIccDh2 = PaceChannelHelper.unwrapEcKey(res.getData());
        }
        catch (Exception e) {
            throw new PaceException("Error obteniendo la clave efimera EC publica de la tarjeta: " + e, e);
        }
        ECPoint y2FromNewG = PaceChannelHelper.byteArrayToECPoint(pukIccDh2, curve);
        ECPoint.Fp SharedSecret_K = (ECPoint.Fp)y2FromNewG.multiply(PrkIFDDH2);
        byte[] secretK = PaceChannelHelper.bigIntToByteArray(SharedSecret_K.normalize().getXCoord().toBigInteger());
        byte[] kenc = new byte[16];
        try {
            System.arraycopy(cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, HexUtils.concatenateByteArrays(secretK, KENC_PADDING)), 0, kenc, 0, 16);
        }
        catch (IOException e) {
            throw new PaceException("Error obteniendo el 'kenc' a partir del CAN/MRZ: " + e, e);
        }
        byte[] kmac = new byte[16];
        try {
            System.arraycopy(cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, HexUtils.concatenateByteArrays(secretK, KMAC_PADDING)), 0, kmac, 0, 16);
        }
        catch (IOException e) {
            throw new PaceException("Error obteniendo el 'kmac' a partir del CAN: " + e, e);
        }
        byte[] pukIccDh2Descompressed = new byte[pukIccDh2.length - 1];
        System.arraycopy(pukIccDh2, 1, pukIccDh2Descompressed, 0, pukIccDh2.length - 1);
        byte[] data = HexUtils.concatenateByteArrays(MAC_PADDING, HexUtils.concatenateByteArrays(MseSetPaceAlgorithmApduCommand.PaceAlgorithmOid.PACE_ECDH_GM_AES_CBC_CMAC_128.getBytes(), HexUtils.concatenateByteArrays(MAC2_PADDING, pukIccDh2Descompressed)));
        try {
            mac8bytes = cryptoHelper.doAesCmac(data, kmac);
        }
        catch (Exception e) {
            throw new PaceException("Error descifrando el 'nonce': " + e, e);
        }
        tlv = new Tlv(124, new Tlv(-123, mac8bytes).getBytes());
        comm = new GeneralAuthenticateApduCommand(0, tlv.getBytes());
        res = conn.transmit(comm);
        if (!res.isOk()) {
            throw new InvalidCanOrMrzException(res.getStatusWord(), comm, "Error estableciendo el algoritmo del protocolo PACE (fallo en el General Authenticate)");
        }
        byte[] ssc = new byte[16];
        Arrays.fill(ssc, (byte)0);
        LOGGER.info("Canal Pace abierto");
        LOGGER.info("\nKenc: " + HexUtils.hexify(kenc, true) + "Kmac: " + HexUtils.hexify(kmac, true) + "Ssc: " + HexUtils.hexify(ssc, true));
        AmAESCrypto crypto = new AmAESCrypto();
        return new SecureMessaging(crypto, kenc, kmac, new byte[((AmCryptoProvider)crypto).getBlockSize()]);
    }

    private static byte[] bigIntToByteArray(BigInteger bi) {
        byte[] temp = bi.toByteArray();
        byte[] returnbytes = null;
        if (temp[0] == 0) {
            returnbytes = new byte[temp.length - 1];
            System.arraycopy(temp, 1, returnbytes, 0, returnbytes.length);
            return returnbytes;
        }
        return temp;
    }

    private static byte[] unwrapEcKey(byte[] key) throws TlvException {
        return new Tlv(new Tlv(key).getValue()).getValue();
    }

    private static ECPoint byteArrayToECPoint(byte[] value, ECCurve.Fp curve) throws IllegalArgumentException {
        byte[] x = new byte[(value.length - 1) / 2];
        byte[] y = new byte[(value.length - 1) / 2];
        if (value[0] != 4) {
            throw new IllegalArgumentException("No se ha encontrado un punto no comprimido");
        }
        System.arraycopy(value, 1, x, 0, (value.length - 1) / 2);
        System.arraycopy(value, 1 + (value.length - 1) / 2, y, 0, (value.length - 1) / 2);
        ECFieldElement.Fp xE = (ECFieldElement.Fp)curve.fromBigInteger(new BigInteger(1, x));
        ECFieldElement.Fp yE = (ECFieldElement.Fp)curve.fromBigInteger(new BigInteger(1, y));
        ECPoint point = curve.createPoint(xE.toBigInteger(), yE.toBigInteger());
        return point;
    }
}

