/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.pace;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.JseCryptoHelper;
import es.gob.jmulticard.card.SmartCard;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public final class MrzInfo {
    private static final int DOC_TYPE_UNSPECIFIED = 0;
    private static final int DOC_TYPE_ID1 = 1;
    private static final int DOC_TYPE_ID3 = 3;
    @Deprecated
    private int documentType;
    private String documentCode;
    private String documentNumber;
    private String dateOfBirth;
    private String dateOfExpiry;
    private char documentNumberCheckDigit;
    private String optionalData1;

    public byte[] getBytes() {
        byte[] numberBytes = this.getDocumentNumber().getBytes();
        byte[] numberCheck = new byte[]{(byte)MrzInfo.checkDigit(this.getDocumentNumber())};
        byte[] birthBytes = this.getDateOfBirth().getBytes();
        byte[] birthCheck = new byte[]{(byte)MrzInfo.checkDigit(this.getDateOfBirth())};
        byte[] expiryBytes = this.getDateOfExpiry().getBytes();
        byte[] expiryCheck = new byte[]{(byte)MrzInfo.checkDigit(this.getDateOfExpiry())};
        if (SmartCard.DEBUG) {
            Logger.getLogger("es.gob.jmulticard").info("Info de la MRZ: numero=" + new String(numberBytes) + "; nacimiento=" + new String(birthBytes) + "; caducidad=" + new String(expiryBytes));
        }
        return HexUtils.concatenateByteArrays(numberBytes, numberCheck, birthBytes, birthCheck, expiryBytes, expiryCheck);
    }

    public byte[] getMrzPswd() throws IOException {
        return new JseCryptoHelper().digest(CryptoHelper.DigestAlgorithm.SHA1, this.getBytes());
    }

    public MrzInfo(String mrzStr) {
        if (mrzStr == null || mrzStr.isEmpty()) {
            throw new IllegalArgumentException("El texto del MRZ no puede ser nulo ni vacio");
        }
        String strMrz = mrzStr.trim().replace("\n", "").replace("\r", "").replaceAll("\t", "");
        try {
            this.readObject(new ByteArrayInputStream(strMrz.getBytes(StandardCharsets.UTF_8)), strMrz.length());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    private void readObject(InputStream inputStream, int length) throws IOException {
        DataInputStream dataIn = new DataInputStream(inputStream);
        this.documentCode = MrzInfo.readStringWithFillers(dataIn, 2);
        this.documentType = MrzInfo.getDocumentTypeFromDocumentCode(this.documentCode);
        switch (length) {
            case 88: {
                this.documentType = 3;
                break;
            }
            case 90: {
                this.documentType = 1;
                break;
            }
            default: {
                this.documentType = MrzInfo.getDocumentTypeFromDocumentCode(this.documentCode);
            }
        }
        if (this.documentType == 1) {
            MrzInfo.readCountry(dataIn);
            this.documentNumber = MrzInfo.readString(dataIn, 9);
            this.documentNumberCheckDigit = (char)dataIn.readUnsignedByte();
            this.optionalData1 = MrzInfo.readStringWithFillers(dataIn, 15);
            if (this.documentNumberCheckDigit == '<') {
                this.documentNumber = this.documentNumber + this.optionalData1.substring(0, this.optionalData1.length() - 1);
                this.documentNumberCheckDigit = this.optionalData1.charAt(this.optionalData1.length() - 1);
                this.optionalData1 = null;
            }
            this.documentNumber = MrzInfo.trimFillerChars(this.documentNumber);
            this.dateOfBirth = MrzInfo.readDateOfBirth(dataIn);
            dataIn.readUnsignedByte();
            MrzInfo.readGender(dataIn);
            this.dateOfExpiry = MrzInfo.readDateOfExpiry(dataIn);
        } else {
            MrzInfo.readCountry(dataIn);
            MrzInfo.readNameIdentifiers(MrzInfo.readString(dataIn, 39));
            this.documentNumber = MrzInfo.trimFillerChars(MrzInfo.readString(dataIn, 9));
            this.documentNumberCheckDigit = (char)dataIn.readUnsignedByte();
            MrzInfo.readCountry(dataIn);
            this.dateOfBirth = MrzInfo.readDateOfBirth(dataIn);
            dataIn.readUnsignedByte();
            MrzInfo.readGender(dataIn);
            this.dateOfExpiry = MrzInfo.readDateOfExpiry(dataIn);
        }
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    static char checkDigit(String str) {
        return MrzInfo.checkDigit(str, false);
    }

    private static void readNameIdentifiers(String mrzNameString) {
        int delimIndex = mrzNameString.indexOf("<<");
        if (delimIndex < 0) {
            MrzInfo.trimFillerChars(mrzNameString);
            return;
        }
        MrzInfo.trimFillerChars(mrzNameString.substring(0, delimIndex));
    }

    private static String readString(DataInputStream in, int count) throws IOException {
        byte[] data = new byte[count];
        in.readFully(data);
        return new String(data).trim();
    }

    private static String readStringWithFillers(DataInputStream in, int count) throws IOException {
        return MrzInfo.trimFillerChars(MrzInfo.readString(in, count));
    }

    private static String readCountry(DataInputStream inputStream) throws IOException {
        return MrzInfo.readString(inputStream, 3);
    }

    private static String readGender(DataInputStream inputStream) throws IOException {
        String genderStr = MrzInfo.readString(inputStream, 1);
        return genderStr;
    }

    private static String readDateOfBirth(DataInputStream in) throws IOException {
        return MrzInfo.readString(in, 6);
    }

    private static String readDateOfExpiry(DataInputStream in) throws IOException {
        return MrzInfo.readString(in, 6);
    }

    private static int getDocumentTypeFromDocumentCode(String documentCode) {
        if (documentCode == null || documentCode.length() < 1 || documentCode.length() > 2) {
            throw new IllegalArgumentException("El tipo de documento debe tener uno o dos caracteres, pero se recibio: " + documentCode);
        }
        if (documentCode.startsWith("A") || documentCode.startsWith("C") || documentCode.startsWith("I")) {
            return 1;
        }
        if (documentCode.startsWith("V")) {
            return 1;
        }
        if (documentCode.startsWith("P")) {
            return 3;
        }
        return 0;
    }

    private static String trimFillerChars(String str) {
        byte[] chars = str.trim().getBytes();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != 60) continue;
            chars[i] = 32;
        }
        return new String(chars).trim();
    }

    private static char checkDigit(String str, boolean preferFillerOverZero) {
        try {
            byte[] chars = str == null ? new byte[]{} : str.getBytes(StandardCharsets.UTF_8);
            int[] weights = new int[]{7, 3, 1};
            int result = 0;
            for (int i = 0; i < chars.length; ++i) {
                result = (result + weights[i % 3] * MrzInfo.decodeMRZDigit(chars[i])) % 10;
            }
            String checkDigitString = Integer.toString(result);
            if (checkDigitString.length() != 1) {
                throw new IllegalStateException("Error calculando el digito de control");
            }
            int checkDigit = checkDigitString.getBytes(StandardCharsets.UTF_8)[0];
            if (preferFillerOverZero && checkDigit == 48) {
                checkDigit = 60;
            }
            return (char)checkDigit;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException("Error calculando el digito de control: " + nfe, nfe);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error calculando el digito de control: " + e, e);
        }
    }

    private static int decodeMRZDigit(byte ch) throws NumberFormatException {
        switch (ch) {
            case 48: 
            case 60: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
            case 71: 
            case 103: {
                return 16;
            }
            case 72: 
            case 104: {
                return 17;
            }
            case 73: 
            case 105: {
                return 18;
            }
            case 74: 
            case 106: {
                return 19;
            }
            case 75: 
            case 107: {
                return 20;
            }
            case 76: 
            case 108: {
                return 21;
            }
            case 77: 
            case 109: {
                return 22;
            }
            case 78: 
            case 110: {
                return 23;
            }
            case 79: 
            case 111: {
                return 24;
            }
            case 80: 
            case 112: {
                return 25;
            }
            case 81: 
            case 113: {
                return 26;
            }
            case 82: 
            case 114: {
                return 27;
            }
            case 83: 
            case 115: {
                return 28;
            }
            case 84: 
            case 116: {
                return 29;
            }
            case 85: 
            case 117: {
                return 30;
            }
            case 86: 
            case 118: {
                return 31;
            }
            case 87: 
            case 119: {
                return 32;
            }
            case 88: 
            case 120: {
                return 33;
            }
            case 89: 
            case 121: {
                return 34;
            }
            case 90: 
            case 122: {
                return 35;
            }
        }
        throw new NumberFormatException("No se ha podido decodificar el caracter del MRZ '" + ch + "' ('" + Character.toString((char)ch) + "')");
    }
}

