/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816four;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.Apdu;
import es.gob.jmulticard.apdu.StatusWord;
import java.util.Hashtable;

public class Iso7816FourCardException
extends Exception {
    private static final Hashtable<StatusWord, String> ERRORS = new Hashtable();
    private final StatusWord returnCode;
    private static final long serialVersionUID = 5935577997660561619L;

    public Iso7816FourCardException(String desc, StatusWord retCode) {
        super(desc);
        this.returnCode = retCode;
    }

    public Iso7816FourCardException(StatusWord retCode, Apdu origin) {
        super((ERRORS.get(retCode) != null ? ERRORS.get(retCode) : "Codigo de retorno " + HexUtils.hexify(retCode.getBytes(), true) + ".") + " APDU de origen: " + HexUtils.hexify(origin.getBytes(), true));
        this.returnCode = retCode;
    }

    public Iso7816FourCardException(String desc, Throwable e) {
        super(desc, e);
        this.returnCode = null;
    }

    public Iso7816FourCardException(String desc) {
        super(desc);
        this.returnCode = null;
    }

    public Iso7816FourCardException(StatusWord retCode, Apdu origin, String desc) {
        super((desc != null ? desc + " - " : "") + (ERRORS.get(retCode) != null ? ERRORS.get(retCode) : "Codigo de retorno " + HexUtils.hexify(retCode.getBytes(), true) + ".") + " APDU de origen: " + HexUtils.hexify(origin.getBytes(), true));
        this.returnCode = retCode;
    }

    public StatusWord getStatusWord() {
        return this.returnCode;
    }

    static {
        ERRORS.put(new StatusWord(98, -125), "El fichero seleccionado esta invalidado (6283).");
        ERRORS.put(new StatusWord(101, -127), "Fallo en la memoria (6581).");
        ERRORS.put(new StatusWord(103, 0), "Longitud incorrecta (6700).");
        ERRORS.put(new StatusWord(104, -126), "Securizacion de mensajes no soportada (6882).");
        ERRORS.put(new StatusWord(105, -126), "Condiciones de seguridad no satisfechas (6982).");
        ERRORS.put(new StatusWord(105, -125), "Metodo de autenticacion bloqueado (6983).");
        ERRORS.put(new StatusWord(105, -124), "Dato referenciado invalido (6984).");
        ERRORS.put(new StatusWord(105, -123), "Condiciones de uso no satisfechas (6985).");
        ERRORS.put(new StatusWord(105, -122), "Comando no permitido [no existe ningun EF seleccionado] (6986) .");
        ERRORS.put(new StatusWord(105, -121), "Falta un objeto necesario en el mensaje seguro (6987).");
        ERRORS.put(new StatusWord(105, -120), "Objetos de datos incorrectos para el mensaje seguro (6988).");
        ERRORS.put(new StatusWord(106, -128), "Parametros incorrectos en el campo de datos (6A80).");
        ERRORS.put(new StatusWord(106, -127), "Funcion no soportada (6A81).");
        ERRORS.put(new StatusWord(106, -126), "No se encuentra el fichero (6A82).");
        ERRORS.put(new StatusWord(106, -125), "Registro no encontrado (6A83).");
        ERRORS.put(new StatusWord(106, -124), "No hay suficiente espacio de memoria en el fichero (6A84).");
        ERRORS.put(new StatusWord(106, -123), "La longitud de datos (Lc) es incompatible con la estructura TLV (6A85).");
        ERRORS.put(new StatusWord(106, -122), "Parametros incorrectos en P1 o P2 (6A86).");
        ERRORS.put(new StatusWord(106, -121), "La longitud de los datos es inconsistente con P1-P2 (6A87).");
        ERRORS.put(new StatusWord(106, -120), "Datos referenciados no encontrados (6A88).");
        ERRORS.put(new StatusWord(106, -119), "El fichero ya existe (6A89).");
        ERRORS.put(new StatusWord(106, -118), "El nombre del DF ya existe (6A8A).");
        ERRORS.put(new StatusWord(107, 0), "Parametro(s) incorrecto(s) P1-P2 (6B00).");
        ERRORS.put(new StatusWord(110, 0), "Clase no soportada (6E00).");
        ERRORS.put(new StatusWord(109, 0), "Comando no permitido en la fase de vida actual (6D00).");
        ERRORS.put(new StatusWord(111, 0), "Diagnostico no preciso (6F00).");
    }
}

