/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816four;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.iso7816four.GetChallengeApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ReadBinaryApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ReadRecordApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectDfByNameApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectFileApduResponse;
import es.gob.jmulticard.apdu.iso7816four.SelectFileByIdApduCommand;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.SmartCard;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import es.gob.jmulticard.card.iso7816four.OffsetOutsideEfException;
import es.gob.jmulticard.card.iso7816four.RequiredSecurityStateNotSatisfiedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public abstract class Iso7816FourCard
extends SmartCard {
    private static final StatusWord UNSATISFIED_SECURITY_STATE = new StatusWord(105, -126);
    private static final StatusWord EOF_REACHED = new StatusWord(98, -126);
    private static final StatusWord OFFSET_OUTSIDE_EF = new StatusWord(107, 0);
    private static final int MAX_READ_CHUNK = 238;
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");

    public Iso7816FourCard(byte c, ApduConnection conn) {
        super(c, conn);
    }

    private ResponseApdu readBinary(byte msbOffset, byte lsbOffset, byte readLength) throws ApduConnectionException, RequiredSecurityStateNotSatisfiedException, OffsetOutsideEfException {
        ReadBinaryApduCommand apdu = new ReadBinaryApduCommand(this.getCla(), msbOffset, lsbOffset, readLength);
        ResponseApdu res = this.getConnection().transmit(apdu);
        if (res.isOk()) {
            return res;
        }
        if (OFFSET_OUTSIDE_EF.equals(res.getStatusWord())) {
            throw new OffsetOutsideEfException(OFFSET_OUTSIDE_EF, apdu);
        }
        if (UNSATISFIED_SECURITY_STATE.equals(res.getStatusWord())) {
            throw new RequiredSecurityStateNotSatisfiedException(res.getStatusWord());
        }
        if (EOF_REACHED.equals(res.getStatusWord())) {
            LOGGER.warning("Se ha alcanzado el final de fichero antes de poder leer los octetos indicados");
            return res;
        }
        throw new ApduConnectionException("Respuesta invalida en la lectura de binario con el codigo: " + res.getStatusWord());
    }

    public List<byte[]> readAllRecords() throws ApduConnectionException, Iso7816FourCardException {
        StatusWord readedResponseSw;
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        ReadRecordApduCommand readRecordApduCommand = new ReadRecordApduCommand(this.getCla());
        do {
            ResponseApdu readedResponse = this.sendArbitraryApdu(readRecordApduCommand);
            readedResponseSw = readedResponse.getStatusWord();
            if (!readedResponse.isOk() && !ReadRecordApduCommand.RECORD_NOT_FOUND.equals(readedResponseSw)) {
                throw new Iso7816FourCardException("Error en la lectura de registro", readedResponseSw);
            }
            ret.add(readedResponse.getData());
        } while (!ReadRecordApduCommand.RECORD_NOT_FOUND.equals(readedResponseSw));
        return ret;
    }

    public byte[] readBinaryComplete(int len) throws IOException {
        ResponseApdu readedResponse = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int off = 0; off < len; off += 238) {
            byte msbOffset = (byte)(off >> 8);
            byte lsbOffset = (byte)(off & 0xFF);
            int left = len - off;
            try {
                readedResponse = left < 238 ? this.readBinary(msbOffset, lsbOffset, (byte)left) : this.readBinary(msbOffset, lsbOffset, (byte)-18);
            }
            catch (Exception e) {
                LOGGER.warning("Se ha intentado una lectura fuera de los limites del fichero, se devolvera lo leido hasta ahora: " + e);
                return out.toByteArray();
            }
            boolean eofReached = EOF_REACHED.equals(readedResponse.getStatusWord());
            if (!readedResponse.isOk() && !eofReached) {
                throw new IOException("Error leyendo el binario (" + readedResponse.getStatusWord() + ")");
            }
            out.write(readedResponse.getData());
            if (!eofReached) continue;
            break;
        }
        return out.toByteArray();
    }

    public void selectFileByName(String name) throws ApduConnectionException, Iso7816FourCardException {
        this.selectFileByName(name.getBytes());
    }

    public void selectFileByName(byte[] name) throws ApduConnectionException, FileNotFoundException, Iso7816FourCardException {
        SelectDfByNameApduCommand selectCommand = new SelectDfByNameApduCommand(this.getCla(), name);
        ResponseApdu response = this.sendArbitraryApdu(selectCommand);
        if (response.isOk()) {
            return;
        }
        StatusWord sw = response.getStatusWord();
        if (sw.equals(new StatusWord(106, -126))) {
            throw new FileNotFoundException(name);
        }
        throw new Iso7816FourCardException(sw, selectCommand);
    }

    public int selectFileById(byte[] id) throws ApduConnectionException, Iso7816FourCardException {
        SelectFileByIdApduCommand selectCommand = new SelectFileByIdApduCommand(this.getCla(), id);
        ResponseApdu res = this.getConnection().transmit(selectCommand);
        if (HexUtils.arrayEquals(res.getBytes(), new byte[]{106, -126})) {
            throw new FileNotFoundException(id);
        }
        SelectFileApduResponse response = new SelectFileApduResponse(res);
        if (response.isOk()) {
            return response.getFileLength();
        }
        StatusWord sw = response.getStatusWord();
        if (sw.equals(new StatusWord(106, -126))) {
            throw new FileNotFoundException(id);
        }
        throw new Iso7816FourCardException(sw, selectCommand);
    }

    public byte[] selectFileByIdAndRead(byte[] id) throws Iso7816FourCardException, IOException {
        int fileLength = this.selectFileById(id);
        return this.readBinaryComplete(fileLength);
    }

    public int selectFileByLocation(Location location) throws ApduConnectionException, Iso7816FourCardException {
        int fileLength = 0;
        this.selectMasterFile();
        for (Location loc = location; loc != null; loc = loc.getChild()) {
            byte[] id = loc.getFile();
            fileLength = this.selectFileById(id);
        }
        return fileLength;
    }

    public byte[] selectFileByLocationAndRead(Location location) throws IOException, Iso7816FourCardException {
        int fileLenght = this.selectFileByLocation(location);
        return this.readBinaryComplete(fileLenght);
    }

    protected abstract void selectMasterFile() throws ApduConnectionException, FileNotFoundException, Iso7816FourCardException;

    public void setPublicKeyToVerification(byte[] refPublicKey) throws SecureChannelException, ApduConnectionException {
        ResponseApdu res = this.sendArbitraryApdu(new CommandApdu(0, 34, -127, -74, new Tlv(-125, refPublicKey).getBytes(), null));
        if (!res.isOk()) {
            throw new SecureChannelException("Error estableciendo la clave publica para verificacion, con respuesta : " + res.getStatusWord());
        }
    }

    public byte[] getChallenge() throws ApduConnectionException {
        ResponseApdu res = this.getConnection().transmit(new GetChallengeApduCommand(0));
        if (res.isOk()) {
            return res.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion de desafio con el codigo: " + res.getStatusWord());
    }

    public abstract void verifyPin(PasswordCallback var1) throws ApduConnectionException, PinException;
}

