/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.gide.smartcafe;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.gide.RetriesLeftApduCommand;
import es.gob.jmulticard.apdu.gide.VerifyApduCommand;
import es.gob.jmulticard.apdu.iso7816eight.PsoSignHashApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetComputationApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectFileApduResponse;
import es.gob.jmulticard.apdu.iso7816four.SelectFileByIdApduCommand;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.TlvException;
import es.gob.jmulticard.asn1.der.pkcs1.DigestInfo;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.Odf;
import es.gob.jmulticard.asn1.der.pkcs15.Path;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CardMessages;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.gide.smartcafe.SmartCafePrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCard;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class SmartCafePkcs15Applet
extends Iso7816FourCard
implements CryptoCard {
    private static final byte[] ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15};
    private static final Atr ATR = new Atr(new byte[]{59, -9, 24, 0, 0, -128, 49, -2, 69, 115, 102, 116, 101, 45, 110, 102, -60}, ATR_MASK);
    private static final byte[] ATR_MASK_MSC = new byte[]{-1, -1, -1, -1, -1};
    private static final Atr ATR_MSC = new Atr(new byte[]{59, -128, -128, 1, 1}, ATR_MASK_MSC);
    private static final byte[] ATR_MASK_TCL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15};
    private static final Atr ATR_TCL = new Atr(new byte[]{59, -9, 24, 0, 0, -128, 49, -2, 69, 115, 102, 116, 101, 45, 110, 102, -60}, ATR_MASK_TCL);
    private static final byte[] PKCS15_NAME = new byte[]{-96, 0, 0, 0, 99, 80, 75, 67, 83, 45, 49, 53};
    private static final byte[] ODF_PATH = new byte[]{80, 49};
    private static final byte[] MF_PATH = new byte[]{63, 0};
    private static byte CLA = 0;
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final Map<String, X509Certificate> CERTS_BY_ALIAS = new LinkedHashMap<String, X509Certificate>();
    private static final Map<String, Integer> KEYNO_BY_ALIAS = new LinkedHashMap<String, Integer>();
    private static final byte ERROR_PIN_SW1 = 99;
    private PasswordCallback passwordCallback = null;
    private CallbackHandler callbackHandler = null;
    private boolean authenticated = false;
    protected final CryptoHelper cryptoHelper;

    public SmartCafePkcs15Applet(ApduConnection conn, CryptoHelper cryptoHelper) throws IOException {
        this(conn, cryptoHelper, true);
    }

    public SmartCafePkcs15Applet(ApduConnection conn, CryptoHelper cryptoHelper, boolean failIfNoCerts) throws IOException {
        super(CLA, conn);
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("El CryptoHelper no puede ser nulo");
        }
        this.cryptoHelper = cryptoHelper;
        conn.reset();
        SmartCafePkcs15Applet.connect(conn);
        try {
            this.selectFileByName(PKCS15_NAME);
        }
        catch (Iso7816FourCardException e) {
            throw new IOException("No se ha podido seleccionar el Applet AET PKCS#15: " + e, e);
        }
        try {
            this.preloadCertificates();
        }
        catch (Asn1Exception | TlvException | Iso7816FourCardException e) {
            throw new IOException("No se han podido leer los certificados: " + e, e);
        }
        int keyCount = SmartCafePkcs15Applet.getKeyCount(this.sendArbitraryApdu(new CommandApdu(new byte[]{0, -54, 1, 2, 6})));
        LOGGER.info("Se ha" + (keyCount > 1 ? "n" : "") + " encontrado " + keyCount + " clave" + (keyCount > 1 ? "s" : "") + " y " + CERTS_BY_ALIAS.size() + " certificado" + (CERTS_BY_ALIAS.size() > 1 ? "s" : "") + " en la tarjeta");
        for (int i = 0; i < keyCount; ++i) {
            ResponseApdu res = this.sendArbitraryApdu(new CommandApdu(new byte[]{-128, 58, (byte)i, 1, 0}));
            if (!res.isOk()) {
                LOGGER.severe("Error obteniendo el modulo de la clave " + i + ": " + res);
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(0);
            baos.write(res.getData());
            BigInteger modulus = new BigInteger(baos.toByteArray());
            SmartCafePkcs15Applet.storeKeyOrdinal(i, modulus);
        }
        Set<String> aliases = CERTS_BY_ALIAS.keySet();
        for (String alias : aliases) {
            if (KEYNO_BY_ALIAS.containsKey(alias)) continue;
            LOGGER.info("El certificado '" + alias + "' se descarta por carecer de clave privada");
            CERTS_BY_ALIAS.remove(alias);
        }
        if (aliases.isEmpty()) {
            throw new IOException("La tarjeta no contiene claves");
        }
    }

    private static void storeKeyOrdinal(int ordinal, BigInteger publicKeyModulus) {
        Set<String> aliases = CERTS_BY_ALIAS.keySet();
        for (String alias : aliases) {
            BigInteger certPublicKeyModulus;
            PublicKey publicKey = CERTS_BY_ALIAS.get(alias).getPublicKey();
            if (!(publicKey instanceof RSAPublicKey) || !(certPublicKeyModulus = ((RSAPublicKey)publicKey).getModulus()).equals(publicKeyModulus)) continue;
            KEYNO_BY_ALIAS.put(alias, ordinal);
        }
    }

    private static int getKeyCount(ResponseApdu ra) throws IOException {
        if (!ra.isOk()) {
            throw new IOException("No se ha podido determinar el numero de claves en tarjeta: " + HexUtils.hexify(ra.getBytes(), true));
        }
        byte[] res = ra.getData();
        if (res.length == 6 && res[0] == 127 && res[1] == -1 && res[2] == 32 && res[4] == 12 && res[5] == 11) {
            return 32 - res[3];
        }
        throw new IOException("No se ha podido determinar el numero de claves en tarjeta: " + HexUtils.hexify(ra.getBytes(), true));
    }

    public void setPasswordCallback(PasswordCallback pwc) {
        this.passwordCallback = pwc;
    }

    public void setCallbackHandler(CallbackHandler callh) {
        this.callbackHandler = callh;
    }

    public static void connect(ApduConnection conn) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        if (!conn.isOpen()) {
            conn.open();
        }
        SmartCafePkcs15Applet.checkAtr(conn.reset());
    }

    private void preloadCertificates() throws FileNotFoundException, Iso7816FourCardException, IOException, Asn1Exception, TlvException {
        CertificateFactory cf;
        this.selectMasterFile();
        this.selectFileById(ODF_PATH);
        byte[] odfBytes = this.readBinaryComplete(162);
        Odf odf = new Odf();
        odf.setDerValue(odfBytes);
        Path cdfPath = odf.getCdfPath();
        Cdf cdf = new Cdf();
        try {
            this.selectMasterFile();
            byte[] cdfBytes = this.selectFileByIdAndRead(cdfPath.getPathBytes());
            cdf.setDerValue(cdfBytes);
        }
        catch (Exception e) {
            throw new ApduConnectionException("No se ha podido cargar el CDF de la tarjeta: " + e, e);
        }
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IOException("Error obteniendo la factoria de certificados X.509: " + e, e);
        }
        if (cdf.getCertificateCount() < 1) {
            LOGGER.warning("La tarjeta no contiene ningun certificado");
        }
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            try {
                int fileLength = -1;
                for (Location certLocation = new Location(cdf.getCertificatePath(i)); certLocation != null; certLocation = certLocation.getChild()) {
                    byte[] id = certLocation.getFile();
                    try {
                        fileLength = this.selectFileById(id);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("El CDF indicaba un certificado en la ruta '" + certLocation + "', pero un elemento de esta no existe, se ignorara: " + e);
                    }
                }
                if (fileLength <= 0) {
                    LOGGER.warning("El certificado " + i + " del dispositivo esta vacio");
                    continue;
                }
                byte[] certBytes = this.readBinaryComplete(fileLength);
                CERTS_BY_ALIAS.put(cdf.getCertificateAlias(i), (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes)));
                continue;
            }
            catch (Exception e) {
                LOGGER.severe("Error en la lectura del certificado " + i + " del dispositivo: " + e);
            }
        }
    }

    @Override
    public String getCardName() {
        return "G&D SmartCafe 3.2 (PKCS#15 Applet)";
    }

    @Override
    public String[] getAliases() {
        return CERTS_BY_ALIAS.keySet().toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return CERTS_BY_ALIAS.get(alias);
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, Iso7816FourCardException {
        this.selectFileById(MF_PATH);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getCardName()).append("\n Tarjeta con ").append(CERTS_BY_ALIAS.size()).append(" certificado(s):\n");
        String[] aliases = this.getAliases();
        for (int i = 0; i < aliases.length; ++i) {
            sb.append("  ");
            sb.append(i + 1);
            sb.append(" - ");
            sb.append(aliases[i]);
        }
        return sb.toString();
    }

    @Override
    public int selectFileById(byte[] id) throws ApduConnectionException, Iso7816FourCardException {
        SelectFileByIdApduCommand selectCommand = new SelectFileByIdApduCommand(this.getCla(), id);
        ResponseApdu res = this.getConnection().transmit(selectCommand);
        if (HexUtils.arrayEquals(res.getBytes(), new byte[]{106, -126})) {
            throw new FileNotFoundException(id);
        }
        SelectFileApduResponse response = new SelectFileApduResponse(res);
        if (response.isOk()) {
            return HexUtils.getUnsignedInt(new byte[]{response.getData()[4], response.getData()[5]}, 0);
        }
        StatusWord sw = response.getStatusWord();
        if (sw.equals(new StatusWord(106, -126))) {
            throw new FileNotFoundException(id);
        }
        throw new Iso7816FourCardException(sw, selectCommand);
    }

    @Override
    public void verifyPin(PasswordCallback psc) throws ApduConnectionException, PinException {
        if (psc == null) {
            throw new IllegalArgumentException("No se puede verificar el titular con un PasswordCallback nulo");
        }
        VerifyApduCommand verifyCommandApdu = new VerifyApduCommand(psc);
        ResponseApdu verifyResponse = this.getConnection().transmit(verifyCommandApdu);
        verifyCommandApdu = null;
        if (!verifyResponse.isOk()) {
            if (verifyResponse.getStatusWord().getMsb() == 99) {
                throw new BadPinException(verifyResponse.getStatusWord().getLsb() - -64);
            }
            if (verifyResponse.getStatusWord().getMsb() == 105 && verifyResponse.getStatusWord().getLsb() == -125) {
                throw new AuthenticationModeLockedException();
            }
            throw new ApduConnectionException(new Iso7816FourCardException("Error en la verificacion de PIN (" + verifyResponse.getStatusWord() + ")", verifyResponse.getStatusWord()));
        }
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        if (!KEYNO_BY_ALIAS.containsKey(alias)) {
            return null;
        }
        return new SmartCafePrivateKeyReference(KEYNO_BY_ALIAS.get(alias));
    }

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKeyReference keyRef) throws CryptoCardException, PinException {
        byte[] digestInfo;
        if (data == null) {
            throw new CryptoCardException("Los datos a firmar no pueden ser nulos");
        }
        if (keyRef == null) {
            throw new IllegalArgumentException("La clave privada no puede ser nula");
        }
        if (!(keyRef instanceof SmartCafePrivateKeyReference)) {
            throw new IllegalArgumentException("La clave proporcionada debe ser de tipo " + SmartCafePrivateKeyReference.class.getName() + ", pero se ha recibido de tipo " + keyRef.getClass().getName());
        }
        SmartCafePrivateKeyReference scPrivateKey = (SmartCafePrivateKeyReference)keyRef;
        if (!this.authenticated) {
            try {
                this.verifyPin(this.getInternalPasswordCallback());
                this.authenticated = true;
            }
            catch (ApduConnectionException e1) {
                throw new CryptoCardException("Error en la verificacion de PIN: " + e1, e1);
            }
        }
        ResponseApdu res = null;
        try {
            res = this.sendArbitraryApdu(new MseSetComputationApduCommand(1, new byte[]{(byte)scPrivateKey.getKeyOrdinal()}, new byte[]{2}));
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error estableciendo la clave y el algoritmo de firma (repuesta=" + res + "): " + e, e);
        }
        if (res == null || !res.isOk()) {
            throw new CryptoCardException("No se ha podido establecer la clave y el algoritmo de firma" + (res != null ? " (repuesta=" + res + ")" : ""));
        }
        try {
            digestInfo = DigestInfo.encode(algorithm, data, this.cryptoHelper);
        }
        catch (IOException e) {
            throw new CryptoCardException("Error en el calculo de la huella para firmar: " + e, e);
        }
        try {
            res = this.sendArbitraryApdu(new PsoSignHashApduCommand(1, digestInfo));
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error firmando (repuesta=" + res + "): " + e, e);
        }
        if (res == null || !res.isOk()) {
            throw new CryptoCardException("No se ha podido firmar el DigestInfo" + (res != null ? " (repuesta=" + res + ")" : ""));
        }
        return res.getData();
    }

    private int getPinRetriesLeft() throws PinException {
        ResponseApdu verifyResponse;
        RetriesLeftApduCommand verifyCommandApdu = new RetriesLeftApduCommand();
        try {
            verifyResponse = this.getConnection().transmit(verifyCommandApdu);
        }
        catch (ApduConnectionException e) {
            throw new PinException("Error obteniendo el PIN del CallbackHandler: " + e, e);
        }
        if (verifyResponse.isOk() || verifyResponse.getBytes().length > 2) {
            return verifyResponse.getBytes()[1];
        }
        throw new PinException("Error comprobando los intentos restantes de PIN con respuesta: " + HexUtils.hexify(verifyResponse.getBytes(), true));
    }

    private PasswordCallback getInternalPasswordCallback() throws PinException {
        if (this.passwordCallback != null) {
            int retriesLeft = this.getPinRetriesLeft();
            if (retriesLeft == 0) {
                throw new AuthenticationModeLockedException();
            }
            return this.passwordCallback;
        }
        if (this.callbackHandler != null) {
            int retriesLeft = this.getPinRetriesLeft();
            if (retriesLeft == 0) {
                throw new AuthenticationModeLockedException();
            }
            PasswordCallback pwc = new PasswordCallback(CardMessages.getString("Gen.0", Integer.toString(retriesLeft)), false);
            try {
                this.callbackHandler.handle(new Callback[]{pwc});
            }
            catch (IOException e) {
                throw new PinException("Error obteniendo el PIN del CallbackHandler: " + e, e);
            }
            catch (UnsupportedCallbackException e) {
                throw new PinException("El CallbackHandler no soporta pedir el PIN al usuario: " + e, e);
            }
            return pwc;
        }
        throw new PinException("No hay ningun metodo para obtener el PIN");
    }

    private static void checkAtr(byte[] atrBytes) throws InvalidCardException {
        Atr tmpAtr = new Atr(atrBytes, ATR_MASK);
        if (ATR.equals(tmpAtr)) {
            LOGGER.info("Detectada G&D SmartCafe 3.2");
        } else if (ATR_MSC.equals(tmpAtr)) {
            LOGGER.info("Detectada G&D Mobile Security Card");
        } else if (ATR_TCL.equals(tmpAtr)) {
            LOGGER.info("Detectada G&D SmartCafe 3.2 via T=CL (conexion inalambrica)");
        } else {
            throw new InvalidCardException("La tarjeta no es una SmartCafe 3.2 (ATR encontrado: " + HexUtils.hexify(atrBytes, false) + ")");
        }
    }
}

