/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.gemalto.tuir5;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.apdu.gemalto.MseSetSignatureKeyApduCommand;
import es.gob.jmulticard.apdu.gemalto.VerifyApduCommand;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.gemalto.tuir5.TuiPrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCard;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class TuiR5
extends Iso7816FourCard
implements CryptoCard {
    private static final byte[] ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr ATR = new Atr(new byte[]{59, 111, 0, 0, -128, 102, -80, 7, 1, 1, 119, 7, 83, 2, 49, 16, -126, -112, 0}, ATR_MASK);
    private static final byte[][] APPLETS_AIDS = new byte[][]{{-96, 0, 0, 0, 24, 14, 0, 0, 1, 99, 66, 0}, {-96, 0, 0, 0, 24, 15, 0, 0, 1, 99, 66, 0}, {-96, 0, 0, 0, 24, 12, 0, 0, 1, 99, 66, 0}};
    private static final Location CDF_LOCATION = new Location("50005003");
    private static byte CLA = 0;
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private final PasswordCallback passwordCallback;
    private static final Map<String, X509Certificate> certificatesByAlias = new LinkedHashMap<String, X509Certificate>();

    public TuiR5(ApduConnection conn, PasswordCallback pwc) throws Iso7816FourCardException, IOException {
        super(CLA, conn);
        if (pwc == null) {
            throw new IllegalArgumentException("El PasswordCallback no puede ser nulo");
        }
        this.passwordCallback = pwc;
        this.connect(conn);
        this.selectPkcs15Applet();
        this.preloadCertificates();
    }

    private void connect(ApduConnection conn) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        long[] terminals = conn.getTerminals(false);
        if (terminals.length < 1) {
            throw new NoReadersFoundException();
        }
        InvalidCardException invalidCardException = null;
        CardNotPresentException cardNotPresentException = null;
        for (long terminal : terminals) {
            byte[] responseAtr;
            conn.setTerminal((int)terminal);
            try {
                responseAtr = conn.reset();
            }
            catch (CardNotPresentException e) {
                cardNotPresentException = e;
                continue;
            }
            Atr actualAtr = new Atr(responseAtr, ATR_MASK);
            if (!ATR.equals(actualAtr)) {
                invalidCardException = new InvalidCardException(this.getCardName(), ATR, responseAtr);
                continue;
            }
            return;
        }
        if (invalidCardException != null) {
            throw invalidCardException;
        }
        if (cardNotPresentException != null) {
            throw cardNotPresentException;
        }
        throw new ApduConnectionException("No se ha podido conectar con ningun lector de tarjetas");
    }

    private void preloadCertificates() throws IOException, Iso7816FourCardException {
        CertificateFactory cf;
        this.selectMasterFile();
        Cdf cdf = new Cdf();
        try {
            cdf.setDerValue(this.selectFileByLocationAndRead(CDF_LOCATION));
        }
        catch (Exception e) {
            throw new IOException("Error en la lectura del CDF: " + e, e);
        }
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IOException("Error obteniendo la factoria de certificados X.509: " + e, e);
        }
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            try {
                certificatesByAlias.put(cdf.getCertificateAlias(i), (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.selectFileByLocationAndRead(new Location(cdf.getCertificatePath(i))))));
                continue;
            }
            catch (CertificateException e) {
                throw new IOException("Error en la lectura del certificado " + i + " del dispositivo: " + e, e);
            }
        }
    }

    private void selectPkcs15Applet() throws ApduConnectionException, InvalidCardException, Iso7816FourCardException {
        for (byte[] aid : APPLETS_AIDS) {
            try {
                this.selectFileByName(aid);
                return;
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Aplicacion no encontrada con AID '" + HexUtils.hexify(aid, false) + "': " + e);
            }
        }
        throw new InvalidCardException("La tarjeta no contiene ningun Applet PKCS#15 de identificador conocido");
    }

    @Override
    public String[] getAliases() {
        return certificatesByAlias.keySet().toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return certificatesByAlias.get(alias);
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) throws CryptoCardException {
        ResponseApdu res;
        if (alias == null) {
            throw new IllegalArgumentException("El alias no puede ser nulo");
        }
        if (!certificatesByAlias.containsKey(alias)) {
            LOGGER.warning("La tarjeta no contiene el alias '" + alias + "', se devolvera null");
            return null;
        }
        String[] aliases = this.getAliases();
        byte index = -1;
        for (int i = 0; i < aliases.length; ++i) {
            if (!alias.equals(aliases[i])) continue;
            index = (byte)i;
            break;
        }
        if (index == -1) {
            throw new IllegalStateException("La tarjeta no contiene el alias: " + alias);
        }
        MseSetSignatureKeyApduCommand mseSet = new MseSetSignatureKeyApduCommand(CLA, MseSetSignatureKeyApduCommand.CryptographicMechanism.RSASSA_PKCS1v1_5_SHA1, index);
        try {
            res = this.sendArbitraryApdu(mseSet);
        }
        catch (Exception e) {
            throw new CryptoCardException("Error enviando la APDU de establecimiento de clave privada para firma: " + e, e);
        }
        if (res.isOk()) {
            return new TuiPrivateKeyReference(index);
        }
        throw new CryptoCardException("No se ha podido recuperar la referencia a la clave privada: " + HexUtils.hexify(res.getBytes(), true));
    }

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKeyReference keyRef) throws CryptoCardException {
        if (keyRef == null) {
            throw new IllegalArgumentException("La referencia a la clave privada no puede ser nula");
        }
        if (!(keyRef instanceof TuiPrivateKeyReference)) {
            throw new CryptoCardException("Solo se admiten claves privadas de tipo TuiPrivateKeyReference, pero se encontro: " + keyRef.getClass().getName());
        }
        return null;
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException {
        CommandApdu selectMf = new CommandApdu(CLA, -92, 8, 12, new byte[]{80, 0, 80, 1}, null);
        this.sendArbitraryApdu(selectMf);
    }

    @Override
    public String getCardName() {
        return "Gemalto TUI R5 (MPCOS)";
    }

    @Override
    public void verifyPin(PasswordCallback pinPc) throws ApduConnectionException, BadPinException {
        VerifyApduCommand verifyPinApduCommand = new VerifyApduCommand(CLA, this.passwordCallback);
        ResponseApdu verifyResponse = this.getConnection().transmit(verifyPinApduCommand);
        if (!verifyResponse.isOk()) {
            throw new BadPinException(verifyResponse.getStatusWord().getLsb() - -64);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getCardName()).append("\n Tarjeta con ").append(certificatesByAlias.size()).append(" certificado(s):\n");
        String[] aliases = this.getAliases();
        for (int i = 0; i < aliases.length; ++i) {
            sb.append("  ");
            sb.append(i + 1);
            sb.append(" - ");
            sb.append(aliases[i]);
        }
        return sb.toString();
    }
}

