/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.fnmt.ceres.asn1;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.der.Record;
import es.gob.jmulticard.asn1.der.pkcs15.CertificateObject;
import es.gob.jmulticard.asn1.der.pkcs15.Pkcs15Cdf;
import es.gob.jmulticard.card.fnmt.ceres.asn1.CeresCertificateObject;

public final class CeresCdf
extends Record
implements Pkcs15Cdf {
    private static final int BUFFER_SIZE = 150;

    public CeresCdf() {
        super(new OptionalDecoderObjectElement[]{new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true), new OptionalDecoderObjectElement(CeresCertificateObject.class, true)});
    }

    @Override
    public int getCertificateCount() {
        return this.getElementCount();
    }

    @Override
    public byte[] getCertificateId(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getIdentifier();
        }
        return null;
    }

    @Override
    public String getCertificatePath(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getPath();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("Fichero de Descripcion de Certificados CERES:\n");
        for (int index = 0; index < this.getCertificateCount(); ++index) {
            sb.append(" Certificado ");
            sb.append(Integer.toString(index));
            sb.append("\n  Ruta PKCS#15: ");
            sb.append(this.getCertificatePath(index));
            sb.append("\n  Identificador del certificado: ");
            sb.append(HexUtils.hexify(this.getCertificateId(index), false));
            if (index == this.getCertificateCount() - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

