/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.fnmt.ceres;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.ceres.CeresVerifyApduCommand;
import es.gob.jmulticard.apdu.ceres.LoadDataApduCommand;
import es.gob.jmulticard.apdu.ceres.SignDataApduCommand;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.dnie.RetriesLeftApduCommand;
import es.gob.jmulticard.apdu.iso7816eight.EnvelopeDataApduCommand;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.TlvException;
import es.gob.jmulticard.asn1.der.Record;
import es.gob.jmulticard.asn1.der.pkcs1.DigestInfo;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.PrKdf;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.CardMessages;
import es.gob.jmulticard.card.CompressionUtils;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.fnmt.ceres.CeresPrivateKeyReference;
import es.gob.jmulticard.card.fnmt.ceres.asn1.CeresCdf;
import es.gob.jmulticard.card.fnmt.ceres.asn1.CeresPrKdf;
import es.gob.jmulticard.card.iso7816eight.Iso7816EightCard;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class Ceres
extends Iso7816EightCard
implements CryptoCard {
    private static final byte[] ATR_MASK_TC = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1};
    private static final Atr ATR_TC = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 70, 78, 77, 84, 0, 0, 0, 0, 0, 0, 3, -112, 0}, ATR_MASK_TC);
    private static final byte[] ATR_MASK_ST = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1};
    private static final Atr ATR_ST = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 67, 69, 82, 69, 83, 2, 44, 52, 0, 0, 3, -112, 0}, ATR_MASK_ST);
    private static final byte[] ATR_MASK_SLE_FN20 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr ATR_SLE_FN20 = new Atr(new byte[]{59, -17, 0, 0, 64, 20, -128, 37, 67, 69, 82, 69, 83, 87, 5, 96, 1, 2, 3, -112, 0}, ATR_MASK_SLE_FN20);
    private static final byte[] ATR_MASK_SLE_FN19 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr ATR_SLE_FN19 = new Atr(new byte[]{59, -17, 0, 0, 64, 20, -128, 37, 67, 69, 82, 69, 83, 87, 1, 22, 1, 1, 3, -112, 0}, ATR_MASK_SLE_FN19);
    private static final byte CLA = 0;
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private final CryptoHelper cryptoHelper;
    private static final Location CDF_LOCATION = new Location("50156004");
    private static final Location PRKDF_LOCATION = new Location("50156001");
    private static final String MASTER_FILE_NAME = "Master.File";
    private static final byte ERROR_PIN_SW1 = 103;
    private static final byte ERROR_PIN_SW2 = 99;
    private static final boolean AUTO_RETRY = true;
    private Map<String, X509Certificate> certs;
    private Map<String, String> aliasByCertAndKeyId;
    private Map<String, Byte> keys;
    private PasswordCallback passwordCallback = null;
    private boolean authenticated = false;
    private CallbackHandler callbackHandler;

    public void setPasswordCallback(PasswordCallback pwc) {
        this.passwordCallback = pwc;
    }

    private static void checkAtr(byte[] atrBytes) throws InvalidCardException {
        Atr tmpAtr = new Atr(atrBytes, ATR_MASK_TC);
        if (ATR_TC.equals(tmpAtr)) {
            if (atrBytes[15] >= 4 && atrBytes[16] >= 48) {
                throw new InvalidCardException("Encontrada CERES en version " + HexUtils.hexify(new byte[]{atrBytes[15]}, false) + "." + HexUtils.hexify(new byte[]{atrBytes[16]}, false) + ", pero las versiones iguales o superiores a la 04.30 no estan soportadas por este controlador");
            }
            return;
        }
        tmpAtr = new Atr(atrBytes, ATR_MASK_ST);
        if (ATR_ST.equals(tmpAtr)) {
            return;
        }
        tmpAtr = new Atr(atrBytes, ATR_MASK_SLE_FN19);
        if (ATR_SLE_FN19.equals(tmpAtr)) {
            return;
        }
        tmpAtr = new Atr(atrBytes, ATR_MASK_SLE_FN20);
        if (ATR_SLE_FN20.equals(tmpAtr)) {
            return;
        }
        throw new InvalidCardException("CERES", ATR_TC, atrBytes);
    }

    public static void connect(ApduConnection conn) throws ApduConnectionException, InvalidCardException {
        conn.open();
        Ceres.checkAtr(conn.reset());
    }

    public Ceres(ApduConnection conn, CryptoHelper ch) throws ApduConnectionException, InvalidCardException {
        super((byte)0, conn);
        if (ch == null) {
            throw new IllegalArgumentException("El CryptoHelper no puede ser nulo");
        }
        Ceres.connect(this.getConnection());
        try {
            this.preload();
        }
        catch (Exception e) {
            throw new ApduConnectionException("Error cargando las estructuras iniciales de la tarjeta: " + e, e);
        }
        this.cryptoHelper = ch;
    }

    private void preload() throws ApduConnectionException, Iso7816FourCardException, IOException, CertificateException, Asn1Exception, TlvException {
        String alias;
        this.selectMasterFile();
        byte[] cdfBytes = this.selectFileByLocationAndRead(CDF_LOCATION);
        Record cdf = new CeresCdf();
        try {
            cdf.setDerValue(cdfBytes);
        }
        catch (Exception e) {
            cdf = new Cdf();
            cdf.setDerValue(cdfBytes);
        }
        this.certs = new LinkedHashMap<String, X509Certificate>(cdf.getCertificateCount());
        this.aliasByCertAndKeyId = new LinkedHashMap<String, String>(cdf.getCertificateCount());
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            X509Certificate cert;
            Location l = new Location(cdf.getCertificatePath(i).replace("\\", "").trim());
            try {
                cert = CompressionUtils.getCertificateFromCompressedOrNotData(this.selectFileByLocationAndRead(l));
            }
            catch (IOException e) {
                LOGGER.warning("No se ha encontrado un certificado referenciado, se pasa al siguiente: " + e);
                continue;
            }
            alias = i + " " + cert.getSerialNumber();
            this.aliasByCertAndKeyId.put(HexUtils.hexify(cdf.getCertificateId(i), false), alias);
            this.certs.put(alias, cert);
        }
        byte[] prkdfValue = this.selectFileByLocationAndRead(PRKDF_LOCATION);
        Record prkdf = new CeresPrKdf();
        try {
            prkdf.setDerValue(prkdfValue);
        }
        catch (Exception e) {
            prkdf = new PrKdf();
            prkdf.setDerValue(prkdfValue);
        }
        this.keys = new LinkedHashMap<String, Byte>();
        for (int i = 0; i < prkdf.getKeyCount(); ++i) {
            alias = this.aliasByCertAndKeyId.get(HexUtils.hexify(prkdf.getKeyId(i), false));
            if (alias == null) continue;
            this.keys.put(alias, prkdf.getKeyReference(i));
        }
        this.hideCertsWithoutKey();
    }

    private void hideCertsWithoutKey() {
        String[] aliases;
        try {
            aliases = this.getAliases();
        }
        catch (Exception e) {
            throw new IllegalStateException("No se han podido leer los alias de los certificados de la tarjeta CERES: " + e, e);
        }
        for (String alias : aliases) {
            if (this.keys.get(alias) != null) continue;
            this.certs.remove(alias);
        }
    }

    @Override
    public String[] getAliases() {
        return this.certs.keySet().toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return this.certs.get(alias);
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        return new CeresPrivateKeyReference(this.keys.get(alias), ((RSAPublicKey)this.certs.get(alias).getPublicKey()).getModulus().bitLength());
    }

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKeyReference keyRef) throws CryptoCardException, PinException {
        ResponseApdu res;
        byte[] digestInfo;
        if (data == null) {
            throw new CryptoCardException("Los datos a firmar no pueden ser nulos");
        }
        if (keyRef == null) {
            throw new IllegalArgumentException("La clave privada no puede ser nula");
        }
        if (!(keyRef instanceof CeresPrivateKeyReference)) {
            throw new IllegalArgumentException("La clave proporcionada debe ser de tipo CeresPrivateKeyReference, pero se ha recibido de tipo " + keyRef.getClass().getName());
        }
        CeresPrivateKeyReference ceresPrivateKey = (CeresPrivateKeyReference)keyRef;
        if (!this.authenticated) {
            try {
                this.verifyPin(this.getInternalPasswordCallback());
                this.authenticated = true;
            }
            catch (ApduConnectionException e1) {
                throw new CryptoCardException("Error en la verificacion de PIN: " + e1, e1);
            }
        }
        try {
            digestInfo = DigestInfo.encode(algorithm, data, this.cryptoHelper);
        }
        catch (Exception e) {
            throw new CryptoCardException("Error creando el DigestInfo para la firma con el algoritmo " + algorithm + ": " + e, e);
        }
        this.loadData(ceresPrivateKey.getKeyBitSize(), digestInfo);
        SignDataApduCommand cmd = new SignDataApduCommand(ceresPrivateKey.getKeyReference(), ceresPrivateKey.getKeyBitSize());
        try {
            res = this.sendArbitraryApdu(cmd);
        }
        catch (Exception e) {
            throw new CryptoCardException("Error firmando los datos: " + e, e);
        }
        if (!res.isOk()) {
            throw new CryptoCardException("No se han podido firmar los datos. Respuesta: " + HexUtils.hexify(res.getBytes(), true));
        }
        return res.getData();
    }

    private void loadData(int keyBitSize, byte[] digestInfo) throws CryptoCardException {
        byte[] paddedData;
        try {
            paddedData = CryptoHelper.addPkcs1PaddingForPrivateKeyOperation(digestInfo, keyBitSize);
        }
        catch (Exception e1) {
            throw new CryptoCardException("Error realizando el relleno PKCS#1 de los datos a firmar: " + e1, e1);
        }
        if (keyBitSize < 2048) {
            ResponseApdu res;
            try {
                res = this.sendArbitraryApdu(new LoadDataApduCommand(paddedData));
            }
            catch (Exception e) {
                throw new CryptoCardException("Error enviando los datos a firmar a la tarjeta: " + e, e);
            }
            if (!res.isOk()) {
                throw new CryptoCardException("No se han podido enviar los datos a firmar a la tarjeta. Respuesta: " + HexUtils.hexify(res.getBytes(), true));
            }
        } else if (keyBitSize == 2048) {
            ResponseApdu res;
            byte[] envelopedLoadDataApdu = new byte[]{-112, 88, 0, 0, 0, 1, 0};
            byte[] data = new byte[255];
            System.arraycopy(envelopedLoadDataApdu, 0, data, 0, envelopedLoadDataApdu.length);
            System.arraycopy(paddedData, 0, data, envelopedLoadDataApdu.length, 255 - envelopedLoadDataApdu.length);
            try {
                res = this.sendArbitraryApdu(new EnvelopeDataApduCommand(data));
            }
            catch (Exception e) {
                throw new CryptoCardException("Error en el primer envio a la tarjeta de los datos a firmar: " + e, e);
            }
            if (!res.isOk()) {
                throw new CryptoCardException("No se han podido enviar (primera tanda) los datos a firmar a la tarjeta. Respuesta: " + HexUtils.hexify(res.getBytes(), true));
            }
            data = new byte[8];
            System.arraycopy(paddedData, 255 - envelopedLoadDataApdu.length, data, 0, 8);
            try {
                res = this.sendArbitraryApdu(new EnvelopeDataApduCommand(data));
            }
            catch (Exception e) {
                throw new CryptoCardException("Error en el segundo envio a la tarjeta de los datos a firmar: " + e, e);
            }
            if (!res.isOk()) {
                throw new CryptoCardException("No se han podido enviar (segunda tanda) los datos a firmar a la tarjeta. Respuesta: " + HexUtils.hexify(res.getBytes(), true));
            }
        } else {
            throw new IllegalArgumentException("Solo se soportan claves de 2048 o menos bits");
        }
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, FileNotFoundException, Iso7816FourCardException {
        this.selectFileByName(MASTER_FILE_NAME);
    }

    @Override
    public void verifyPin(PasswordCallback pinPc) throws ApduConnectionException, PinException {
        if (pinPc == null) {
            throw new PinException("No se ha establecido un PasswordCallback");
        }
        CeresVerifyApduCommand chv = new CeresVerifyApduCommand(0, pinPc);
        ResponseApdu verifyResponse = this.sendArbitraryApdu(chv);
        if (!verifyResponse.isOk()) {
            if (verifyResponse.getStatusWord().getMsb() == 103 || verifyResponse.getStatusWord().getMsb() == 99) {
                this.passwordCallback = null;
                this.verifyPin(this.getInternalPasswordCallback());
                return;
            }
            if (new StatusWord(105, -125).equals(verifyResponse.getStatusWord())) {
                throw new AuthenticationModeLockedException();
            }
            throw new ApduConnectionException(new Iso7816FourCardException("Error en la verificacion de PIN (" + verifyResponse.getStatusWord() + ")", verifyResponse.getStatusWord()));
        }
    }

    protected PasswordCallback getInternalPasswordCallback() throws PinException {
        if (this.passwordCallback != null) {
            int retriesLeft = this.getPinRetriesLeft();
            if (retriesLeft == 0) {
                throw new AuthenticationModeLockedException();
            }
            return this.passwordCallback;
        }
        if (this.callbackHandler != null) {
            int retriesLeft = this.getPinRetriesLeft();
            if (retriesLeft == 0) {
                throw new AuthenticationModeLockedException();
            }
            PasswordCallback pwc = new PasswordCallback(CardMessages.getString("Gen.0", Integer.toString(retriesLeft)), false);
            try {
                this.callbackHandler.handle(new Callback[]{pwc});
            }
            catch (IOException e) {
                throw new PinException("Error obteniendo el PIN del CallbackHandler: " + e, e);
            }
            catch (UnsupportedCallbackException e) {
                throw new PinException("El CallbackHandler no soporta pedir el PIN al usuario: " + e, e);
            }
            return pwc;
        }
        throw new PinException("No hay ningun metodo para obtener el PIN");
    }

    private int getPinRetriesLeft() throws PinException {
        ResponseApdu verifyResponse;
        RetriesLeftApduCommand verifyCommandApdu = new RetriesLeftApduCommand();
        try {
            verifyResponse = this.getConnection().transmit(verifyCommandApdu);
        }
        catch (ApduConnectionException e) {
            throw new PinException("Error obteniendo el PIN del CallbackHandler: " + e, e);
        }
        return verifyResponse.getStatusWord().getLsb() - -64;
    }

    @Override
    public String getCardName() {
        return "FNMT-RCM CERES";
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callh) {
        this.callbackHandler = callh;
    }
}

