/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import java.util.Locale;

public final class DnieSubjectPrincipalParser {
    private final String name;
    private final String surname1;
    private final String surname2;
    private final String id;

    public DnieSubjectPrincipalParser(String subjectPrincipal) {
        this.name = DnieSubjectPrincipalParser.getRDNvalueFromLdapName("GIVENNAME", subjectPrincipal);
        this.surname1 = DnieSubjectPrincipalParser.getRDNvalueFromLdapName("SURNAME", subjectPrincipal);
        this.surname2 = DnieSubjectPrincipalParser.getRDNvalueFromLdapName("CN", subjectPrincipal) != null ? DnieSubjectPrincipalParser.getRDNvalueFromLdapName("CN", subjectPrincipal).replace("(AUTENTICACI\u00d3N)", "").replace("(FIRMA)", "").replaceAll(",", "").replace(this.name, "").replace(this.surname1, "").trim() : null;
        this.id = DnieSubjectPrincipalParser.getRDNvalueFromLdapName("SERIALNUMBER", subjectPrincipal);
    }

    public String getName() {
        return this.name;
    }

    public String getSurname1() {
        return this.surname1;
    }

    public String getSurname2() {
        return this.surname2;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Nombre: " + this.name + "\nPrimer apellido: " + this.surname1 + "\nSegundo apellido: " + this.surname2 + "\nNumero: " + this.id;
    }

    private static String getRDNvalueFromLdapName(String rdn, String principal) {
        int offset1 = 0;
        while ((offset1 = principal.toLowerCase(Locale.US).indexOf(rdn.toLowerCase(), offset1)) != -1) {
            if (offset1 > 0 && principal.charAt(offset1 - 1) != ',' && principal.charAt(offset1 - 1) != ' ') {
                ++offset1;
                continue;
            }
            offset1 += rdn.length();
            while (offset1 < principal.length() && principal.charAt(offset1) == ' ') {
                ++offset1;
            }
            if (offset1 >= principal.length()) {
                return null;
            }
            if (principal.charAt(offset1) != '=') continue;
            ++offset1;
            while (offset1 < principal.length() && principal.charAt(offset1) == ' ') {
                ++offset1;
            }
            if (offset1 >= principal.length()) {
                return "";
            }
            if (principal.charAt(offset1) == ',') {
                return "";
            }
            if (principal.charAt(offset1) == '\"') {
                if (++offset1 >= principal.length()) {
                    return "";
                }
                int offset2 = principal.indexOf(34, offset1);
                if (offset2 == offset1) {
                    return "";
                }
                if (offset2 != -1) {
                    return principal.substring(offset1, offset2);
                }
                return principal.substring(offset1);
            }
            int offset2 = principal.indexOf(44, offset1);
            if (offset2 != -1) {
                return principal.substring(offset1, offset2).trim();
            }
            return principal.substring(offset1).trim();
        }
        return null;
    }
}

