/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.JseCryptoHelper;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890Connection;
import es.gob.jmulticard.apdu.iso7816four.pace.MseSetPaceAlgorithmApduCommand;
import es.gob.jmulticard.card.CardMessages;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.dnie.Dnie3;
import es.gob.jmulticard.card.pace.InvalidCanOrMrzException;
import es.gob.jmulticard.card.pace.PaceChannelHelper;
import es.gob.jmulticard.card.pace.PaceConnection;
import es.gob.jmulticard.card.pace.PaceException;
import es.gob.jmulticard.card.pace.PaceInitializer;
import es.gob.jmulticard.card.pace.PaceInitializerCan;
import es.gob.jmulticard.card.pace.PaceInitializerMrz;
import es.gob.jmulticard.de.tsenger.androsmex.iso7816.SecureMessaging;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public class DnieNFC
extends Dnie3 {
    private static final int MAX_PACE_RETRIES = 2;
    private static MseSetPaceAlgorithmApduCommand.PacePasswordType paceInitType;
    private static String paceInitValue;

    DnieNFC(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch) throws PaceException, ApduConnectionException {
        this(DnieNFC.getPaceConnection(conn, ch), pwc, cryptoHelper, ch, true);
    }

    DnieNFC(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch, boolean loadCertsAndKeys) throws PaceException, ApduConnectionException {
        super(DnieNFC.getPaceConnection(conn, ch), pwc, cryptoHelper, ch, loadCertsAndKeys);
    }

    @Override
    public String getCardName() {
        return "DNIe 3.0 accedido de forma inalambrica";
    }

    private static ApduConnection getPaceConnection(ApduConnection con, CallbackHandler ch) throws ApduConnectionException, PaceException {
        Callback tic;
        String prompt = CardMessages.getString("DnieNFC.0");
        try {
            tic = (Callback)Class.forName("javax.security.auth.callback.TextInputCallback").getConstructor(String.class).newInstance(prompt);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.info("No se ha encontrado la clase 'javax.security.auth.callback.TextInputCallback', se usara 'es.gob.jmulticard.callback.CustomTextInputCallback': " + e);
            try {
                tic = (Callback)Class.forName("es.gob.jmulticard.callback.CustomTextInputCallback").getConstructor(String.class).newInstance(prompt);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                throw new IllegalStateException("No se ha encontrado ni la clase 'javax.security.auth.callback.TextInputCallback' ni 'es.gob.jmulticard.callback.CustomTextInputCallback': " + e1, e1);
            }
        }
        int counter = 0;
        paceInitValue = null;
        paceInitType = null;
        while (true) {
            if (paceInitValue == null || paceInitType == null) {
                try {
                    ch.handle(new Callback[]{tic});
                }
                catch (Exception e) {
                    throw new PaceException("Error obteniendo el CAN: " + e, e);
                }
                try {
                    Method m = tic.getClass().getMethod("getText", new Class[0]);
                    Object o = m.invoke((Object)tic, new Object[0]);
                    if (!(o instanceof String)) {
                        throw new IllegalStateException("El TextInputCallback ha devuelto un dato de tipo " + (o == null ? "null" : o.getClass().getName()));
                    }
                    paceInitValue = (String)o;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("El TextInputCallback no tiene un metodo 'getText': " + e);
                }
                paceInitType = DnieNFC.getPasswordType(paceInitValue);
                if (paceInitValue == null || paceInitValue.isEmpty() || paceInitType == null) {
                    throw new InvalidCanOrMrzException("El CAN/MRZ no puede ser nulo ni vacio");
                }
            }
            try {
                PaceInitializer paceInitializer;
                switch (paceInitType) {
                    case MRZ: {
                        paceInitializer = PaceInitializerMrz.deriveMrz(paceInitValue);
                        break;
                    }
                    case CAN: {
                        paceInitializer = new PaceInitializerCan(paceInitValue);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Tipo de inicializador PACE no soportado: " + (Object)((Object)paceInitType));
                    }
                }
                SecureMessaging sm = PaceChannelHelper.openPaceChannel((byte)0, paceInitializer, con, new JseCryptoHelper());
                return new PaceConnection(con, new JseCryptoHelper(), sm);
            }
            catch (InvalidCanOrMrzException e) {
                paceInitValue = null;
                paceInitType = null;
                if (counter < 2) {
                    Logger.getLogger("es.gob.jmulticard").warning("Error en el intento " + Integer.toString(counter + 1) + " de establecimiento de canal PACE (probablemente por CAN/MRZ invalido): " + e);
                    ++counter;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private static ApduConnection getPaceConnection(ApduConnection con) throws ApduConnectionException, PaceException {
        PaceInitializer paceInitializer;
        switch (paceInitType) {
            case MRZ: {
                paceInitializer = PaceInitializerMrz.deriveMrz(paceInitValue);
                break;
            }
            case CAN: {
                paceInitializer = new PaceInitializerCan(paceInitValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException("No se soporta el codigo de inicializacion de PACE: " + (Object)((Object)paceInitType));
            }
        }
        SecureMessaging sm = PaceChannelHelper.openPaceChannel((byte)0, paceInitializer, con, new JseCryptoHelper());
        return new PaceConnection(con, new JseCryptoHelper(), sm);
    }

    @Override
    public void openSecureChannelIfNotAlreadyOpened() throws CryptoCardException, PinException {
        if (!(this.getConnection() instanceof Cwa14890Connection)) {
            try {
                this.rawConnection = DnieNFC.getPaceConnection(this.getConnection());
            }
            catch (ApduConnectionException e) {
                throw new CryptoCardException("Error en la transmision de la APDU: " + e);
            }
            catch (PaceException e) {
                throw new CryptoCardException("Error en el establecimiento del canal PACE: " + e);
            }
        }
        super.openSecureChannelIfNotAlreadyOpened();
    }

    @Override
    public byte[] sign(byte[] data, String signAlgorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, PinException {
        byte[] ret = this.signInternal(data, signAlgorithm, privateKeyReference);
        try {
            this.setConnection(((Cwa14890Connection)this.getConnection()).getSubConnection());
            this.resetCard();
        }
        catch (ApduConnectionException e) {
            LOGGER.warning("Fallo en el reinicio del canal seguro: " + e);
        }
        return ret;
    }

    private void resetCard() {
        try {
            this.selectMasterFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static MseSetPaceAlgorithmApduCommand.PacePasswordType getPasswordType(String paceInitializationValue) {
        if (DnieNFC.isNumeric(paceInitializationValue) && paceInitializationValue.length() <= 6) {
            return MseSetPaceAlgorithmApduCommand.PacePasswordType.CAN;
        }
        return MseSetPaceAlgorithmApduCommand.PacePasswordType.MRZ;
    }

    private static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

