/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.dnie.BurnedDnieCardException;
import es.gob.jmulticard.card.dnie.Dnie;
import es.gob.jmulticard.card.dnie.Dnie3;
import es.gob.jmulticard.card.dnie.DnieNFC;
import es.gob.jmulticard.card.dnie.Tif;
import es.gob.jmulticard.card.pace.PaceException;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public final class DnieFactory {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    private static final byte[] ATR_NFC_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0};
    private static final Atr ATR_NFC = new Atr(new byte[]{59, -120, -128, 1, -31, -13, 94, 17, 119, -127, -95, 0, 3}, ATR_NFC_MASK);
    private static final Atr ATR = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 68, 78, 73, 101, 0, 0, 0, 0, 0, 0, 0, -112, 0}, ATR_MASK);
    private static final Atr ATR_TIF = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 84, 73, 70, 49, 0, 0, 0, 0, 0, 0, 0, -112, 0}, ATR_MASK);

    private DnieFactory() {
    }

    public static Dnie getDnie(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch) throws InvalidCardException, BurnedDnieCardException, ApduConnectionException {
        return DnieFactory.getDnie(conn, pwc, cryptoHelper, ch, true);
    }

    public static Dnie getDnie(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch, boolean loadCertsAndKeys) throws InvalidCardException, BurnedDnieCardException, ApduConnectionException {
        if (conn == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        InvalidCardException invalidCardException = null;
        CardNotPresentException cardNotPresentException = null;
        long[] terminals = conn.getTerminals(false);
        if (terminals.length < 1) {
            throw new NoReadersFoundException();
        }
        for (long terminal : terminals) {
            byte[] responseAtr;
            conn.setTerminal((int)terminal);
            try {
                responseAtr = conn.reset();
            }
            catch (CardNotPresentException e) {
                cardNotPresentException = e;
                continue;
            }
            Atr actualAtr = new Atr(responseAtr, ATR_MASK);
            byte[] actualAtrBytes = actualAtr.getBytes();
            if (ATR_NFC.equals(actualAtr)) {
                try {
                    LOGGER.info("Detectado DNIe 3.0 por NFC");
                    return new DnieNFC(conn, pwc, cryptoHelper, ch, loadCertsAndKeys);
                }
                catch (PaceException e) {
                    throw new ApduConnectionException("No se ha podido abrir el canal PACE: " + e);
                }
            }
            if (ATR.equals(actualAtr)) {
                if (actualAtrBytes[15] == 4) {
                    LOGGER.info("Detectado DNIe 3.0");
                    return new Dnie3(conn, pwc, cryptoHelper, ch, loadCertsAndKeys);
                }
                LOGGER.info("Detectado DNIe 2.0");
                return new Dnie(conn, pwc, cryptoHelper, ch, loadCertsAndKeys);
            }
            if (ATR_TIF.equals(actualAtr)) {
                LOGGER.info("Detectada tarjeta TIF");
                return new Tif(conn, pwc, cryptoHelper, ch);
            }
            if (actualAtrBytes[actualAtrBytes.length - 1] == -127 && actualAtrBytes[actualAtrBytes.length - 2] == 101) {
                throw new BurnedDnieCardException(actualAtr);
            }
            invalidCardException = new InvalidCardException("DNIe", ATR, responseAtr);
        }
        if (invalidCardException != null) {
            throw invalidCardException;
        }
        if (cardNotPresentException != null) {
            throw cardNotPresentException;
        }
        throw new ApduConnectionException("No se ha podido conectar con ningun lector de tarjetas");
    }
}

