/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.logging.Logger;

public final class DnieCertParseUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final String name;
    private String sn1;
    private final String sn2;
    private final String num;

    public DnieCertParseUtil(X509Certificate c) {
        if (c == null) {
            throw new IllegalArgumentException("El certificado no puede ser nulo");
        }
        String dn = c.getSubjectDN().toString();
        String cn = DnieCertParseUtil.getCN(dn);
        if (cn.contains("(")) {
            cn = cn.substring(0, cn.indexOf(40)).trim();
        }
        this.name = cn.substring(cn.indexOf(44) + 1, cn.length()).trim();
        this.sn1 = DnieCertParseUtil.getRDNvalueFromLdapName("SN", dn);
        if (this.sn1 == null) {
            this.sn1 = DnieCertParseUtil.getRDNvalueFromLdapName("SURNAME", dn);
        }
        if (this.sn1 == null) {
            this.sn1 = DnieCertParseUtil.getRDNvalueFromLdapName("OID.2.5.4.4", dn);
        }
        if (this.sn1 == null) {
            this.sn1 = DnieCertParseUtil.getRDNvalueFromLdapName("2.5.4.4", dn);
        }
        this.sn2 = cn.replace(",", "").replace(this.name, "").replace(this.sn1, "").trim();
        this.num = DnieCertParseUtil.getRDNvalueFromLdapName("SERIALNUMBER", dn);
    }

    public String getName() {
        return this.name;
    }

    public String getSurname1() {
        return this.sn1;
    }

    public String getSurname2() {
        return this.sn2;
    }

    public String getNumber() {
        return this.num;
    }

    private static String getCN(String principal) {
        if (principal == null) {
            return null;
        }
        String rdn = DnieCertParseUtil.getRDNvalueFromLdapName("cn", principal);
        if (rdn == null) {
            rdn = DnieCertParseUtil.getRDNvalueFromLdapName("ou", principal);
        }
        if (rdn != null) {
            return rdn;
        }
        int i = principal.indexOf(61);
        if (i != -1) {
            LOGGER.warning("No se ha podido obtener el Common Name ni la Organizational Unit, se devolvera el fragmento mas significativo");
            return DnieCertParseUtil.getRDNvalueFromLdapName(principal.substring(0, i), principal);
        }
        LOGGER.warning("Principal no valido, se devolvera la entrada");
        return principal;
    }

    private static String getRDNvalueFromLdapName(String rdn, String principal) {
        int offset1 = 0;
        while ((offset1 = principal.toLowerCase(Locale.US).indexOf(rdn.toLowerCase(), offset1)) != -1) {
            if (offset1 > 0 && principal.charAt(offset1 - 1) != ',' && principal.charAt(offset1 - 1) != ' ') {
                ++offset1;
                continue;
            }
            offset1 += rdn.length();
            while (offset1 < principal.length() && principal.charAt(offset1) == ' ') {
                ++offset1;
            }
            if (offset1 >= principal.length()) {
                return null;
            }
            if (principal.charAt(offset1) != '=') continue;
            ++offset1;
            while (offset1 < principal.length() && principal.charAt(offset1) == ' ') {
                ++offset1;
            }
            if (offset1 >= principal.length()) {
                return "";
            }
            if (principal.charAt(offset1) == ',') {
                return "";
            }
            if (principal.charAt(offset1) == '\"') {
                if (++offset1 >= principal.length()) {
                    return "";
                }
                int offset2 = principal.indexOf(34, offset1);
                if (offset2 == offset1) {
                    return "";
                }
                if (offset2 != -1) {
                    return principal.substring(offset1, offset2);
                }
                return principal.substring(offset1);
            }
            int offset2 = principal.indexOf(44, offset1);
            if (offset2 != -1) {
                return principal.substring(offset1, offset2).trim();
            }
            return principal.substring(offset1).trim();
        }
        return null;
    }
}

