/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.card.cwa14890.Cwa14890PrivateConstants;
import es.gob.jmulticard.card.cwa14890.Cwa14890PublicConstants;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;

final class Dnie3PinCwa14890Constants
implements Cwa14890PublicConstants,
Cwa14890PrivateConstants {
    private static final byte[] REF_C_CV_CA_PUBLIC_KEY = new byte[]{2, 15};
    private static final byte[] C_CV_CA = new byte[]{127, 33, -127, -50, 95, 55, -127, -128, 60, -70, -36, 54, -124, -66, -13, 32, 65, -83, 21, 80, -119, 37, -115, -3, 32, -58, -111, 21, -41, 47, -100, 56, -86, -103, -83, 108, 26, -19, -6, -78, -65, -84, -112, -110, -4, 112, -52, -64, 12, -81, 72, 42, 75, -29, 26, -3, -67, 60, -68, -116, -125, -126, -49, 6, -68, 7, 25, -70, -85, -75, 107, 110, -56, 7, 96, -92, -87, 63, -94, -41, -61, 71, -13, 68, 39, -7, -1, 92, -115, -26, -42, 93, -84, -107, -14, -15, -99, -84, 0, 83, -33, 17, -91, 7, -5, 98, 94, -21, -115, -92, -64, 41, -98, 74, 33, 18, -85, 112, 71, 88, -117, -115, 109, -89, 89, 34, 20, -14, -37, -95, 64, -57, -47, 34, 87, -101, 95, 56, 61, 34, 83, -56, -71, -53, 91, -61, 84, 58, 85, 102, 11, -38, -128, -108, 106, -5, 5, 37, -24, -27, 88, 107, 78, 99, -24, -110, 65, 73, 120, 54, -40, -45, -85, 8, -116, -44, 76, 33, 77, 106, -56, 86, -30, -96, 7, -12, 79, -125, 116, 51, 55, 55, 26, -35, -114, 3, 0, 1, 0, 1, 66, 8, 101, 115, 82, 68, 73, 96, 0, 6};
    private static final byte[] CHR_C_CV_CA = new byte[]{101, 115, 83, 68, 73, 96, 0, 6};
    private static final byte[] REF_ICC_PRIVATE_KEY = new byte[]{2, 31};
    private static final byte[] C_CV_IFD = new byte[]{127, 33, -127, -51, 95, 55, -127, -128, 105, -60, -28, -108, -16, 8, -30, 66, 20, -79, -63, 49, -74, 31, -50, -100, 21, -6, 60, -80, 97, -35, 111, 2, -40, -94, -51, 48, -41, 47, -74, -33, -119, -102, -15, 91, 113, 120, 33, -65, -79, -81, 125, 117, -123, 1, 109, -116, 54, -81, 74, -62, -96, -80, -59, 42, -42, 91, 105, 37, 103, 49, -61, 77, 89, 2, 14, -121, -85, 115, -94, 48, -6, 105, -18, -126, -77, 58, 49, -33, 4, 12, -23, 15, 10, -4, 58, 17, 29, 53, -38, -107, 102, -88, -51, -85, -22, 14, 63, 117, -108, -60, 64, -45, 116, 80, 122, -108, 53, 87, 89, -77, -98, -59, -27, -4, -72, 3, -115, 121, 61, 95, -101, -88, -75, -79, 11, 112, 95, 56, 60, 76, -122, -111, -57, -66, 47, -40, -63, 35, 102, 14, -104, 101, -31, 79, 25, -33, -5, -73, -1, 56, 8, -55, -14, 4, -25, -105, -48, 109, -40, 51, 58, -59, -125, -122, -18, 78, -74, 30, 32, -20, -89, -17, 56, -43, -80, 94, -79, 21, -106, 106, 90, -119, -83, 88, -91, 0, 1, 0, 1, 66, 8, 101, 115, 83, 68, 73, 96, 0, 6};
    private static final byte[] CHR_C_CV_IFD = new byte[]{64, 0, 0, 0, 0, 0, 0, 1};
    private static final RSAPrivateKey IFD_PRIVATE_KEY = new RSAPrivateKey(){
        private static final long serialVersionUID = 6991556885804507378L;
        private final BigInteger ifdModulus = new BigInteger(1, new byte[]{-12, 39, -105, -115, -95, 89, -70, 2, 121, 48, -118, 108, 106, -119, 80, 90, -38, 90, 103, -61, -38, 38, 121, -22, -12, -95, -80, 17, -98, -35, 77, -12, 110, 120, 4, 36, 113, -87, -47, 48, 29, 63, -78, -113, 56, -59, 125, 8, -119, -9, 49, -37, -114, -35, -68, 19, 103, -63, 52, -31, -23, 71, 120, 107, -114, -56, -28, -71, -54, 106, -89, -62, 76, -122, -111, -57, -66, 47, -40, -63, 35, 102, 14, -104, 101, -31, 79, 25, -33, -5, -73, -1, 56, 8, -55, -14, 4, -25, -105, -48, 109, -40, 51, 58, -59, -125, -122, -18, 78, -74, 30, 32, -20, -89, -17, 56, -43, -80, 94, -79, 21, -106, 106, 90, -119, -83, 88, -91});
        private final BigInteger ifdPrivateExponent = new BigInteger(1, new byte[]{-46, 122, 3, 35, 124, 114, 46, 113, -115, 105, -12, 26, -20, 104, -67, -107, -28, -32, -60, -51, 73, 21, -100, 74, -103, 99, 125, -74, 98, -2, -93, 2, 81, -19, 50, -100, -4, 67, -119, -21, 113, 123, -123, 2, 4, -51, -13, 48, -42, 70, -4, 123, 43, 25, 41, -42, -116, -66, 57, 73, 123, 98, 58, -126, -57, 100, 26, -61, 72, 121, 87, 61, -22, 13, -85, -57, -54, 48, -102, -28, -77, -19, -38, -6, -18, 85, -43, 66, -9, -128, 35, 3, 81, -25, 94, 127, 50, -36, 101, 46, -15, -19, 71, -91, 28, 24, -39, -33, -97, -12, -115, -121, -115, -74, 34, -22, 110, -109, 112, -23, -58, 59, 53, -117, 124, 17, 90, -95});
        private final byte[] encoded = new byte[]{48, -126, 1, 54, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 1, 32, 48, -126, 1, 28, 2, 1, 0, 2, -127, -127, 0, -12, 39, -105, -115, -95, 89, -70, 2, 121, 48, -118, 108, 106, -119, 80, 90, -38, 90, 103, -61, -38, 38, 121, -22, -12, -95, -80, 17, -98, -35, 77, -12, 110, 120, 4, 36, 113, -87, -47, 48, 29, 63, -78, -113, 56, -59, 125, 8, -119, -9, 49, -37, -114, -35, -68, 19, 103, -63, 52, -31, -23, 71, 120, 107, -114, -56, -28, -71, -54, 106, -89, -62, 76, -122, -111, -57, -66, 47, -40, -63, 35, 102, 14, -104, 101, -31, 79, 25, -33, -5, -73, -1, 56, 8, -55, -14, 4, -25, -105, -48, 109, -40, 51, 58, -59, -125, -122, -18, 78, -74, 30, 32, -20, -89, -17, 56, -43, -80, 94, -79, 21, -106, 106, 90, -119, -83, 88, -91, 2, 1, 0, 2, -127, -128, -46, 122, 3, 35, 124, 114, 46, 113, -115, 105, -12, 26, -20, 104, -67, -107, -28, -32, -60, -51, 73, 21, -100, 74, -103, 99, 125, -74, 98, -2, -93, 2, 81, -19, 50, -100, -4, 67, -119, -21, 113, 123, -123, 2, 4, -51, -13, 48, -42, 70, -4, 123, 43, 25, 41, -42, -116, -66, 57, 73, 123, 98, 58, -126, -57, 100, 26, -61, 72, 121, 87, 61, -22, 13, -85, -57, -54, 48, -102, -28, -77, -19, -38, -6, -18, 85, -43, 66, -9, -128, 35, 3, 81, -25, 94, 127, 50, -36, 101, 46, -15, -19, 71, -91, 28, 24, -39, -33, -97, -12, -115, -121, -115, -74, 34, -22, 110, -109, 112, -23, -58, 59, 53, -117, 124, 17, 90, -95, 2, 1, 0, 2, 1, 0, 2, 1, 0, 2, 1, 0, 2, 1, 0};

        @Override
        public BigInteger getModulus() {
            return this.ifdModulus;
        }

        @Override
        public String getFormat() {
            return "PKCS#8";
        }

        @Override
        public byte[] getEncoded() {
            byte[] out = new byte[this.encoded.length];
            System.arraycopy(this.encoded, 0, out, 0, this.encoded.length);
            return out;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }

        @Override
        public BigInteger getPrivateExponent() {
            return this.ifdPrivateExponent;
        }
    };
    private static final PublicKey CA_COMPONENT_PUBLIC_KEY = new PublicKey(){
        private static final long serialVersionUID = -143874096089393139L;
        private final byte[] encoded = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -22, -34, -38, 69, 83, 50, -108, 80, 57, -38, -92, 4, -56, -21, -60, -45, -73, -11, -36, -122, -110, -125, -51, -22, 47, 16, 30, 42, -75, 79, -80, -48, -80, 61, -113, 3, 13, -81, 36, 88, 2, -126, -120, -11, 76, -27, 82, -8, -6, 87, -85, 47, -79, 3, -79, 18, 66, 126, 17, 19, 29, 29, 39, -31, 10, 91, 80, 14, -86, -27, -39, 64, 48, 30, 48, -21, 38, -61, -23, 6, 107, 37, 113, 86, -19, 99, -99, 112, -52, -64, -112, -72, 99, -81, -69, 59, -2, -40, -63, 123, -25, 103, 48, 52, -71, -126, 62, -105, 126, -42, 87, 37, 41, 39, -7, 87, 91, -97, -1, 102, -111, -37, 100, -8, 11, 94, -110, -51, 2, 3, 1, 0, 1};

        @Override
        public String getFormat() {
            return "X.509";
        }

        @Override
        public byte[] getEncoded() {
            byte[] out = new byte[this.encoded.length];
            System.arraycopy(this.encoded, 0, out, 0, this.encoded.length);
            return out;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }
    };

    Dnie3PinCwa14890Constants() {
    }

    @Override
    public byte[] getRefCCvCaPublicKey() {
        return REF_C_CV_CA_PUBLIC_KEY;
    }

    @Override
    public byte[] getCCvCa() {
        return C_CV_CA;
    }

    @Override
    public byte[] getChrCCvCa() {
        return CHR_C_CV_CA;
    }

    @Override
    public byte[] getRefIccPrivateKey() {
        return REF_ICC_PRIVATE_KEY;
    }

    @Override
    public byte[] getCCvIfd() {
        return C_CV_IFD;
    }

    @Override
    public byte[] getChrCCvIfd() {
        return CHR_C_CV_IFD;
    }

    @Override
    public RSAPrivateKey getIfdPrivateKey() {
        return IFD_PRIVATE_KEY;
    }

    @Override
    public PublicKey getCaComponentPublicKey() {
        return CA_COMPONENT_PUBLIC_KEY;
    }

    @Override
    public int getIfdKeyLength() {
        return 128;
    }
}

