/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.card.dnie.CountryCodes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public final class Dnie3Dg01Mrz {
    private final String mrzString;
    private final byte[] rawData;
    private String name;
    private String surname;
    private String dateOfBirth;
    private String nationality;
    private String sex;
    private String dateOfExpiry;
    private String docNumber;
    private String docType;
    private String issuer;
    private String optData;
    private static final SimpleDateFormat SDFORMAT = new SimpleDateFormat("yyMMdd");
    private final Properties countryNames = CountryCodes.getCountryCodes();

    Dnie3Dg01Mrz(byte[] rawBytes) {
        this.rawData = (byte[])rawBytes.clone();
        byte[] mrzBytes = new byte[this.rawData[4]];
        System.arraycopy(this.rawData, 5, mrzBytes, 0, mrzBytes.length);
        this.mrzString = new String(mrzBytes);
        if (this.rawData[4] == 88) {
            String mrz1 = this.mrzString.substring(0, 44);
            String mrz2 = this.mrzString.substring(44, 88);
            this.docType = mrz1.substring(0, 2).replace('<', ' ').trim();
            this.issuer = mrz1.substring(2, 5).replace('<', ' ').trim();
            String helpName = mrz1.substring(5, 44);
            for (int i = 0; i < helpName.length(); ++i) {
                if (helpName.charAt(i) != '<' || helpName.charAt(i + 1) != '<') continue;
                this.surname = helpName.substring(0, i).replace('<', ' ').trim();
                this.name = helpName.substring(i + 2).replace('<', ' ').trim();
                break;
            }
            this.docNumber = mrz2.substring(0, 9).replace('<', ' ').trim();
            this.nationality = mrz2.substring(10, 13).replace('<', ' ').trim();
            this.dateOfBirth = mrz2.substring(13, 19);
            this.sex = mrz2.substring(20, 21);
            this.dateOfExpiry = mrz2.substring(21, 27);
            this.optData = mrz2.substring(28, 42).replace('<', ' ').trim();
        } else {
            String mrz1 = this.mrzString.substring(0, 30);
            String mrz2 = this.mrzString.substring(30, 60);
            String mrz3 = this.mrzString.substring(60, 90);
            this.docType = mrz1.substring(0, 2).replace('<', ' ').trim();
            this.issuer = mrz1.substring(2, 5).replace('<', ' ').trim();
            this.docNumber = mrz1.substring(5, 14).replace('<', ' ').trim();
            this.optData = mrz1.substring(15, 30).replace('<', ' ').trim();
            this.dateOfBirth = mrz2.substring(0, 6);
            this.sex = mrz2.substring(7, 8);
            this.dateOfExpiry = mrz2.substring(8, 14);
            this.nationality = mrz2.substring(15, 18).replace('<', ' ').trim();
            for (int i = 0; i < mrz3.length(); ++i) {
                if (mrz3.charAt(i) != '<' || mrz3.charAt(i + 1) != '<') continue;
                this.surname = mrz3.substring(0, i).replace('<', ' ').trim();
                this.name = mrz3.substring(i + 2).replace('<', ' ').trim();
                break;
            }
        }
    }

    public String toString() {
        return this.mrzString;
    }

    public byte[] getBytes() {
        return (byte[])this.rawData.clone();
    }

    public String getName() {
        return this.name;
    }

    public String getSurname() {
        return this.surname;
    }

    public Date getDateOfBirth() throws ParseException {
        return SDFORMAT.parse(this.dateOfBirth);
    }

    public String getNationality() {
        String c = this.countryNames.getProperty(this.nationality);
        return c != null ? c : "Desconocido";
    }

    public Gender getSex() {
        return Gender.getGender(this.sex);
    }

    public Date getDateOfExpiry() throws ParseException {
        return SDFORMAT.parse(this.dateOfExpiry);
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public String getIssuer() {
        return this.countryNames.getProperty(this.issuer);
    }

    public String getSubjectNumber() {
        return this.optData;
    }

    public String getDocType() {
        return this.docType;
    }

    public byte[] getRawData() {
        return (byte[])this.rawData.clone();
    }

    private static enum Gender {
        MALE("Hombre"),
        FEMALE("Mujer");

        private final String desc;

        private Gender(String d) {
            this.desc = d;
        }

        public String toString() {
            return this.desc;
        }

        static Gender getGender(String text) {
            if (text == null) {
                throw new IllegalArgumentException("El texto de descripcion del sexo no puede ser nulo");
            }
            if ("F".equalsIgnoreCase(text.trim())) {
                return FEMALE;
            }
            if ("M".equalsIgnoreCase(text.trim())) {
                return MALE;
            }
            throw new IllegalArgumentException("Sexo indeterminado: " + text);
        }
    }
}

